package com.ejianc.business.zdsmaterial.material.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 材料明细
 * 
 * @author generator
 * 
 */
public interface IMaterialService extends IBaseService<MaterialEntity> {

    /**
     * 根据分类Id查询分类下的所有材料明细
     *
     * @param categoryIds
     * @return
     */
    List<MaterialVO> queryListByCategoryId(List<Long> categoryIds);

    /**
     * 查询所有编码匹配的材料
     *
     * @param codes
     * @return
     */
    List<MaterialVO> getByCodes(List<String> codes);

    /**
     * 校验指定的物资明细 是有在相同分类下存在 单位和属性都相同的物资
     *
     * @param saveOrUpdateVOs
     * @return
     */
    List<MaterialVO> checkUnitAndProperty(List<MaterialVO> saveOrUpdateVOs, boolean checkId);

    /**
     * 批量保存更新物资信息
     *
     * @param saveOrUpdateVOs
     * @return
     */
    List<MaterialVO> saveOrUpdateMaterials(List<MaterialVO> saveOrUpdateVOs);

    void deleteBatch(List<Long> ids);

    /**
     * 批量查询物资详情
     *
     * @param ids
     * @param queryRelations 是否查询物资明细对应 属性关系列表
     * @return
     */
    List<MaterialVO> queryDetailList(List<Long> ids, boolean queryRelations);

    long countMaterial(Map<String, Object> params);

    List<MaterialVO> pageList(Map<String, Object> params);

    List<MaterialVO> materialCheck(List<MaterialVO> checkVos, boolean generateCode);

    void updateMaterialStatusByCategory(List<Long> categoryIds, Integer setBlockStatus,
                                        Integer enabled, Integer beforeBlockStatus, String newCategoryName, List<Long> excludeMaterialIds);

    void updateCategoryName(Long categoryId, String newCategoryName, List<Long> noIncludeMaterialIds);

    List<Long> updateMaterialByProperty(List<Long> stopUsePropertyIds, String newCategoryName, Integer enabled, Integer blockFlag);

    /**
     * 业务新增物资
     *
     * @param saveList
     * @return
     */
    List<MaterialVO> addNewMaterialsFromBill(List<MaterialVO> saveList);

    /**
     * 业务端删除新增物资
     *
     * @param sourceIds
     * @return
     */
    List<MaterialVO> deleteMaterialsFromBill(List<Long> sourceIds);

    /**
     * 批量生成物资编码
     *
     * @param categoryCode
     * @param count
     * @return
     */
    List<String> generateMaterialCodeBatch(String categoryCode, int count);

    /**
     * 更新物资的属性名及属性值
     *
     * @param changedProperty
     * @param changeNameValues
     * @param delPropertyValueIds
     * @param newCategoryName
     * @return
     */
    List<Long> updatePropertyAndValues(List<MaterialCategoryPropertyEntity> changedProperty,
                                 List<MaterialCategoryPropertySubItemEntity> changeNameValues,
                                 List<Long> delPropertyValueIds,
                                 String newCategoryName);

    List<Long> updateByPropertyValueDel(List<Long> delPropertyValueIds);

    void saveExcelImport(List<MaterialVO> saveImportVos);

    MaterialVO queryExitFlag(String name, String propertyShowName, String unitName, Long categoryId);

    List<MaterialVO> queryExcelFlag(String name, String propertyShowName, String unitName, String categoryName);

    List<Long> getAllInvalidMaterialCategoryIds(String categoryName);

    void delInvalidMaterial(List<Long> ids);

    void materialBatchValid(List<Long> ids);

    List<MaterialVO> saveFromInvalidMaterial(List<MaterialVO> saveList);

    Long pageCount(Map<String, Object> pageParams);

    List<MaterialVO> queryPage(Map<String, Object> pageParams);

    CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response);

    /**
     * 临时档案准入前校验
     *  1、验证必选属性是否都已选值
     *  2、验证属性值是否在库
     *
     * @param ids
     * @return
     */
    String beforeValidCheck(List<Long> ids);

    void generateMaterialCodeBatchNew(List<MaterialVO> unCodeList);

    void handAdd(MaterialEntity material);
}
