package com.ejianc.business.zdsmaterial.plan.conjecture.controller.api;

import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureApiVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @description: materialConjectureApi
 * @author songlx
 * @date 2025/7/8
 * @version 1.0
 */
@Controller
@RequestMapping("/api/materialConjectureApi/")
public class MaterialConjectureApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialConjectureService service;

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;

    @PostMapping(value = "materialConjecture")
    @ResponseBody
    public CommonResponse<List<MaterialConjectureVO>> materialConjecture(@RequestBody List<MaterialConjectureVO> list) {
        String authority = request.getHeader("authority");
        logger.info("authority:{}", authority);
        Long billId = list.get(0).getBillId();
        String identificationId = list.get(0).getIdentificationId();
        logger.info("==============MaterialConjectureApi=={}==={}开始", billId, identificationId);
        List<MaterialConjectureEntity> materialConjectureEntities = BeanMapper.mapList(list, MaterialConjectureEntity.class);
        //保存入库
        service.saveOrUpdateBatch(materialConjectureEntities, list.size(), false);
        long startTime = System.nanoTime(); // 记录开始时间
        //同步物料识别
        List<MaterialConjectureVO> result = service.materialConjecture(materialConjectureEntities, authority);
        long endTime = System.nanoTime(); // 记录结束时间
        long duration = endTime - startTime; // 计算耗时
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        logger.info("==============MaterialConjectureApi=={}==={}耗时 {} 秒", billId, identificationId, seconds);
        budgetPorjectDetailApi.updateMaterialConjecture(result);
        return CommonResponse.success(result);
    }

    @GetMapping(value = "getConjectureProgress")
    @ResponseBody
    public CommonResponse<MaterialConjectureApiVO> getConjectureProgress(@RequestParam String identificationId) {
        MaterialConjectureApiVO resp = new MaterialConjectureApiVO();
        List<MaterialConjectureEntity> identifyList = service
                .getAllByIdentifyId(identificationId, null, null, null, null, null, null, null);
        Integer completeMatch = 0, partialMatch = 0, misMatch = 0;
        List<MaterialConjectureEntity> respList = new ArrayList<>();
        for (MaterialConjectureEntity m : identifyList) {
            switch (m.getMateType()) {
                case "0": //不匹配
                    misMatch++;
                    break;
                case "1": //部分匹配
                    partialMatch++;
                    break;
                case "2": //完全匹配
                    completeMatch++;
                    break;
                default:
            }
            respList.add(m);
        }

        resp.setCompleteMatch(completeMatch);
        resp.setPartialMatch(partialMatch);
        resp.setMisMatch(misMatch);
        resp.setIdentifyList(CollectionUtils.isNotEmpty(respList) ?
                BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList<>());
        return CommonResponse.success(resp);
    }
}
