package com.ejianc.business.zdsmaterial.plan.purchase.service;

import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 采购计划详情
 * 
 * @author generator
 * 
 */
public interface IPurchasePlanDetailService extends IBaseService<PurchasePlanDetailEntity> {
    /**
     * 根据物资id查询已生效的计划量
     * @param materialIds
     * @return
     */
    List<PurchasePlanDetailVO> selectPlanSumByMaterialIds(List<Long> materialIds, Long projectId);
    List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params);
    /**
     *批量设置流水号
     */
    List<PurchasePlanDetailEntity> setMaterialNo(List<PurchasePlanDetailEntity> list);

    /**
     * 根据物资流水号查询匹配的物资明细
     *
     * @param materialSerialNos
     * @return
     */
    List<PurchasePlanDetailVO> findAllByMaterialNos(List<String> materialSerialNos);

    List<PurchasePlanDetailEntity> getAllMaterialByProjectAndMaterialIds(Long projectId, List<Long> materialIds, Long planId, List<Integer> billStates);
}
