/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.order.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IAllotApplyService;
import com.ejianc.business.zdsmaterial.cloudstore.config.OperationLog;
import com.ejianc.business.zdsmaterial.cloudstore.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderService;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"allotOrder"})
public class AllotOrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAllotOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IAllotApplyService allotApplyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @OperationLog(events="\u8c03\u62e8\u8ba2\u5355\u7f16\u8f91/\u5165\u5e93\u7f16\u8f91", handlerName="allotOrderOperationRecordService")
    public CommonResponse<AllotOrderVO> saveOrUpdate(@RequestBody AllotOrderVO saveOrUpdateVO) {
        AllotOrderEntity entity = (AllotOrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotOrderEntity.class));
        AllotOrderVO vo = null;
        if ("saveEdit".equals(saveOrUpdateVO.getOprType())) {
            if (entity.getEditNum() >= 1) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u652f\u6301\u591a\u6b21\u4fee\u6539");
            }
            vo = this.service.saveEditAllotOrderInfo(entity);
        } else {
            vo = this.service.saveOrderInStoreEdit(entity);
        }
        return this.queryDetail(vo.getId());
    }

    @PostMapping(value={"/saveInStore"})
    @OperationLog(events="\u8c03\u62e8\u8ba2\u5355\u5165\u5e93", handlerName="allotOrderOperationRecordService")
    public CommonResponse<AllotOrderVO> saveInStore(@RequestBody AllotOrderVO saveOrUpdateVO) {
        AllotOrderVO vo = this.service.saveOrderInStore((AllotOrderEntity)((Object)this.service.selectById(saveOrUpdateVO.getId())));
        return this.queryDetail(vo.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<AllotOrderVO> queryDetail(Long id) {
        AllotOrderEntity entity = (AllotOrderEntity)((Object)this.service.selectById(id));
        AllotOrderVO vo = (AllotOrderVO)BeanMapper.map((Object)((Object)entity), AllotOrderVO.class);
        List<Long> materialMarketIds = vo.getAllotOrderDetailList().stream().map(AllotOrderDetailVO::getSourceId).collect(Collectors.toList());
        Map<Long, BigDecimal> materialOrderAvailableNum = this.goodsService.getAllotableNum(materialMarketIds);
        vo.getAllotOrderDetailList().stream().forEach(detail -> {
            detail.setBeforeMemo(detail.getMemo());
            detail.setOrderAvailableNum(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u53d6\u6d88.getCode().equals(entity.getBusinessStatus()) || AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u53d6\u6d88.getCode().equals(entity.getBusinessStatus()) || AllotOrderBusinessStatusEnums.\u4ea4\u6613\u5b8c\u6210.getCode().equals(entity.getBusinessStatus()) ? (BigDecimal)materialOrderAvailableNum.get(detail.getSourceId()) : ComputeUtil.safeAdd((BigDecimal)((BigDecimal)materialOrderAvailableNum.get(detail.getSourceId())), (BigDecimal)detail.getAllotNum()));
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<AllotOrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("inCorpName");
        fuzzyFields.add("categoryNames");
        fuzzyFields.add("purUserName");
        fuzzyFields.add("purUserPhone");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map params = param.getParams();
        if (null == params.get("storeType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570storeType\u4e3a\u7a7a\uff01");
        }
        if (null == params.get("queryType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570queryType\u4e3a\u7a7a\uff01");
        }
        String queryType = ((Parameter)params.get("queryType")).getValue().toString();
        params.remove("queryType");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put(queryType + "ParentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(queryType + "OrgId", new Parameter("in", departmentIds));
        }
        if (null == params.get("businessStatus")) {
            if (null == params.get("pageType")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570pageType\u4e3a\u7a7a\uff01");
            }
            if ("pending".equals(((Parameter)params.get("pageType")).getValue().toString())) {
                params.put("businessStatus", new Parameter("in", (Object)"1,2,3,4"));
            } else if ("dealed".equals(((Parameter)params.get("pageType")).getValue().toString())) {
                params.put("businessStatus", new Parameter("in", (Object)"5,6"));
            } else {
                params.put("businessStatus", new Parameter("in", (Object)"7,8"));
            }
            params.remove("pageType");
        }
        if (null != params.get("myOrderFlag")) {
            if (((Parameter)params.get("myOrderFlag")).getValue().toString().indexOf("2") < 0) {
                params.put("purUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            }
            params.remove("myOrderFlag");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        String exportExcelName = "AllotOrder-project-export.xlsx";
        String exportTitle = "\u8c03\u51fa\u8ba2\u5355\u5217\u8868";
        Map params = param.getParams();
        if (null == params.get("storeType")) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570storeType\u4e3a\u7a7a\uff01");
        }
        if (null == params.get("queryType")) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570queryType\u4e3a\u7a7a\uff01");
        }
        String queryType = ((Parameter)params.get("queryType")).getValue().toString();
        params.remove("queryType");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put(queryType + "ParentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(queryType + "OrgId", new Parameter("in", departmentIds));
        }
        if (null == params.get("businessStatus")) {
            if (null == params.get("pageType")) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570pageType\u4e3a\u7a7a\uff01");
            }
            if ("pending".equals(((Parameter)params.get("pageType")).getValue().toString())) {
                params.put("businessStatus", new Parameter("in", (Object)"1,2,3,4"));
            } else if ("dealed".equals(((Parameter)params.get("pageType")).getValue().toString())) {
                params.put("businessStatus", new Parameter("in", (Object)"5,6"));
            } else {
                params.put("businessStatus", new Parameter("in", (Object)"7,8"));
                exportExcelName = exportExcelName.replace("-export", "-canceled-export");
            }
            params.remove("pageType");
        }
        if (null != params.get("storeType") && ((Parameter)params.get("storeType")).getValue().toString().equals("2")) {
            exportExcelName = "AllotOrder-org-export.xlsx";
        }
        if ("in".equals(queryType)) {
            exportTitle = "\u8c03\u5165\u8ba2\u5355\u5217\u8868";
            exportExcelName = "AllotOrder-org-export.xlsx";
        }
        if (null != params.get("pageType") && "canceled".equals(((Parameter)params.get("pageType")).getValue().toString())) {
            exportExcelName = exportExcelName.replace("-export", "-canceled-export");
        }
        if (null != params.get("myOrderFlag")) {
            if (((Parameter)params.get("myOrderFlag")).getValue().toString().indexOf("2") < 0) {
                params.put("purUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            }
            params.remove("myOrderFlag");
        }
        List list = this.service.queryList(param);
        list.stream().forEach(item -> item.setBusinessStatusName(AllotOrderBusinessStatusEnums.getNameByCode((Integer)item.getBusinessStatus())));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)list, AllotOrderVO.class));
        ExcelExport.getInstance().exportWithTrans(exportExcelName, beans, response, exportTitle);
    }

    @PostMapping(value={"/cancelOrder"})
    @OperationLog(events="\u8c03\u62e8\u8ba2\u5355\u53d6\u6d88", handlerName="allotOrderOperationRecordService")
    public CommonResponse<String> cancelOrder(@RequestBody AllotOrderVO allotOrderVO) {
        AllotOrderEntity order = (AllotOrderEntity)((Object)this.service.selectById(allotOrderVO.getId()));
        if (!(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5f85\u786e\u8ba4.getCode().equals(order.getBusinessStatus()) || AllotOrderBusinessStatusEnums.\u8c03\u51fa\u65b9\u5f85\u786e\u8ba4.getCode().equals(order.getBusinessStatus()) || AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u5f85\u6536\u8d27.getCode().equals(order.getBusinessStatus()))) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        this.service.cancelOrder(order);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/confirmOrder"})
    @OperationLog(events="\u8c03\u5165\u65b9\u8c03\u62e8\u8ba2\u5355\u786e\u8ba4", handlerName="allotOrderOperationRecordService")
    public CommonResponse<String> confirmOrder(@RequestBody AllotOrderVO allotOrderVO) {
        this.service.confirmOrder(allotOrderVO.getId());
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

