package com.ejianc.business.zdsstore.api;

import com.ejianc.business.zdsstore.hystrix.AccountSettleHystrix;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name = "ejc-zdsstore-web", url = "${common.env.feign-client-url}", path = "ejc-zdsstore-web", fallback = AccountSettleHystrix.class)
public interface IStoreApi {

    @RequestMapping(value = "/api/store/queryStoreByProject", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<StoreVO> queryStoreByProject(@RequestParam Long projectId, @RequestParam Integer attrFlag);
}
