package com.ejianc.business.zdsstore.consts;

import java.util.HashMap;
import java.util.Map;

/***
 * 仓库属性
 */
public enum StoreAttrEnum {

    主材库("1","主材库"),
    临建材料("2","临建材料"),
    甲供材("3","甲供材"),
    实际仓("4","实际仓"),
    云仓库("5","云仓库");
    private String code;

    private String description;

    private static Map<String, StoreAttrEnum> enumsMap = new HashMap();

    StoreAttrEnum(String code, String description ){
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String getDescriptionByCode(String code) {
        return enumsMap.get(code).getDescription();
    }

    public static StoreAttrEnum getByCode(String code) {
        return enumsMap.get(code);
    }

    static {
        for(StoreAttrEnum e : values()) {
            enumsMap.put(e.getCode(), e);
        }
    }
}
