package com.ejianc.business.zdsstore.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author songlx
 * @version 1.0
 * @description: 根据先进先出计算的物资的单价和金额
 * @date 2022/1/26
 */
public class UseMaterialPriceVO implements Serializable {

    @ApiModelProperty("物资分类id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资内码")
    private String materialInnerCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额含税")
    private BigDecimal taxMny;
    @ApiModelProperty("金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("税额")
    private BigDecimal tax;

    //不存库, 周转材先进先出返回
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal purchasePrice;
    @ApiModelProperty("原值单价")
    private BigDecimal purchaseTaxPrice;

    @ApiModelProperty("原值金额(无税)")
    private BigDecimal purchaseMny;
    @ApiModelProperty("原值金额")
    private BigDecimal purchaseTaxMny;

    @ApiModelProperty("品牌主键")
    private Long brandId;
    @ApiModelProperty("品牌名称")
    private String brandName;


    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public BigDecimal getPurchaseTaxPrice() {
        return purchaseTaxPrice;
    }

    public void setPurchaseTaxPrice(BigDecimal purchaseTaxPrice) {
        this.purchaseTaxPrice = purchaseTaxPrice;
    }

    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }

    public BigDecimal getPurchaseTaxMny() {
        return purchaseTaxMny;
    }

    public void setPurchaseTaxMny(BigDecimal purchaseTaxMny) {
        this.purchaseTaxMny = purchaseTaxMny;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }

    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
}
