package com.ejianc.business.zdsstore.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 仓库库存存量表
 *
 * @author generator
 *
 */
@ApiModel("仓库库存存量表")
public class SurplusVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("仓库")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("材料类型编码")
    private String materialType;
    @ApiModelProperty("材料类型名称")
    private String materialTypeName;
    @ApiModelProperty("物资分类id")
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialCategoryCode")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资内码")
    private String materialInnerCode;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("库存余额(无税)")
    private BigDecimal surplusMny;
    @ApiModelProperty("库存余额")
    private BigDecimal surplusTaxMny;
    @ApiModelProperty("库存余量")
    private BigDecimal surplusNum;
    @ApiModelProperty("入库金额(无税)")
    private BigDecimal instoreMny;
    @ApiModelProperty("入库金额")
    private BigDecimal instoreTaxMny;
    @ApiModelProperty("入库总量")
    private BigDecimal instoreNum;
    @ApiModelProperty("出库占用数量")
    private BigDecimal outLockNum;
    @ApiModelProperty("退货数量")
    private BigDecimal returnGoodsNum;

    @ApiModelProperty("出库占用金额(无税)")
    private BigDecimal outLockMny;
    @ApiModelProperty("出库占用金额")
    private BigDecimal outLockTaxMny;

    @ApiModelProperty("品牌主键")
    private Long brandId;
    @ApiModelProperty("品牌名称")
    private String brandName;
    @ApiModelProperty("闲置数量")
    private BigDecimal idleNum;
    @ApiModelProperty("产品代码")
    private String productCode;
    @ApiModelProperty("仓库属性")
    private String storeType;
    @ApiModelProperty("仓库属性名称")
    private String storeTypeName;


    //库存余量 (包含锁定数量) 不存库 = surplusNum + outLockNum
    private BigDecimal surplusHasOutLockNum;

    //库存均价
    private BigDecimal surplusTaxPrice;

    //库存均价
    private BigDecimal surplusPrice;

    public BigDecimal getOutLockMny() {
        return outLockMny;
    }

    public void setOutLockMny(BigDecimal outLockMny) {
        this.outLockMny = outLockMny;
    }

    public BigDecimal getOutLockTaxMny() {
        return outLockTaxMny;
    }

    public void setOutLockTaxMny(BigDecimal outLockTaxMny) {
        this.outLockTaxMny = outLockTaxMny;
    }

    public BigDecimal getSurplusTaxPrice() {
        return surplusTaxPrice;
    }

    public void setSurplusTaxPrice(BigDecimal surplusTaxPrice) {
        this.surplusTaxPrice = surplusTaxPrice;
    }

    public BigDecimal getSurplusPrice() {
        return surplusPrice;
    }

    public void setSurplusPrice(BigDecimal surplusPrice) {
        this.surplusPrice = surplusPrice;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public BigDecimal getReturnGoodsNum() {
        return returnGoodsNum;
    }

    public void setReturnGoodsNum(BigDecimal returnGoodsNum) {
        this.returnGoodsNum = returnGoodsNum;
    }

    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 仓库
     */
    public Long getStoreId() {
        return storeId;
    }

    /**
     * 仓库
     */
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    /**
     * 仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 材料类型编码
     */
    public String getMaterialType() {
        return materialType;
    }

    /**
     * 材料类型编码
     */
    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
    /**
     * 材料类型名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料类型名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资分类id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类编码
     */
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    /**
     * 物资分类编码
     */
    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资内码
     */
    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    /**
     * 物资内码
     */
    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }
    /**
     * 规格型号
     */
    public String getMaterialSpec() {
        return materialSpec;
    }

    /**
     * 规格型号
     */
    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    /**
     * 计量单位id
     */
    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    /**
     * 计量单位id
     */
    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }
    /**
     * 计量单位
     */
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    /**
     * 计量单位
     */
    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }
    /**
     * 库存余额(无税)
     */
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    /**
     * 库存余额(无税)
     */
    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    /**
     * 库存余额
     */
    public BigDecimal getSurplusTaxMny() {
        return surplusTaxMny;
    }

    /**
     * 库存余额
     */
    public void setSurplusTaxMny(BigDecimal surplusTaxMny) {
        this.surplusTaxMny = surplusTaxMny;
    }
    /**
     * 库存余量
     */
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    /**
     * 库存余量
     */
    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    /**
     * 入库金额(无税)
     */
    public BigDecimal getInstoreMny() {
        return instoreMny;
    }

    /**
     * 入库金额(无税)
     */
    public void setInstoreMny(BigDecimal instoreMny) {
        this.instoreMny = instoreMny;
    }
    /**
     * 入库金额
     */
    public BigDecimal getInstoreTaxMny() {
        return instoreTaxMny;
    }

    /**
     * 入库金额
     */
    public void setInstoreTaxMny(BigDecimal instoreTaxMny) {
        this.instoreTaxMny = instoreTaxMny;
    }
    /**
     * 入库总量
     */
    public BigDecimal getInstoreNum() {
        return instoreNum;
    }

    /**
     * 入库总量
     */
    public void setInstoreNum(BigDecimal instoreNum) {
        this.instoreNum = instoreNum;
    }

    /**
     * 出库占用数量
     */
    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    /**
     * 出库占用数量
     */
    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }

    public BigDecimal getSurplusHasOutLockNum() {
        return surplusHasOutLockNum;
    }

    public void setSurplusHasOutLockNum(BigDecimal surplusHasOutLockNum) {
        this.surplusHasOutLockNum = surplusHasOutLockNum;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getIdleNum() {
        return idleNum;
    }

    public void setIdleNum(BigDecimal idleNum) {
        this.idleNum = idleNum;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }
}
