package com.ejianc.business.zdsstore.api;

import com.ejianc.business.zdsstore.hystrix.AccountSettleHystrix;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author 姜轶凯
 * @version 1.0
 * @description: 对账结算api
 * @date 2022/3/9
 */
@FeignClient(name = "ejc-zdsstore-web", url = "${common.env.feign-client-url}", path = "ejc-zdsstore-web", fallback = AccountSettleHystrix.class)
public interface IAccountSettleApi {

    @RequestMapping(value = "/api/accountSettle/changeAccountSettleByType", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> changeAccountSettleByType(@RequestBody StoreApiVO storeApiVO);


    /**
     * @param storeApiVO
     * @description: 结算单审批通过
     * 更新入库单价为结算单价，同时需要更新库存余额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/3/10
     */
    @RequestMapping(value = "/api/accountSettle/settlePass", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreApiVO> settlePass(@RequestBody StoreApiVO storeApiVO);

    /**
     * @param storeApiVO
     * @description: 结算单弃审校验
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author 姜轶凯
     * @date: 2022/3/10
     */
    @RequestMapping(value = "/api/accountSettle/settleRollback", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreApiVO> settleRollback(@RequestBody StoreApiVO storeApiVO);

    /**
     * 出口结算
     * @param storeApiVO
     * @return
     */
    @RequestMapping(value = "/api/accountSettle/changeSettleFlag", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> changeSettleFlag(@RequestBody StoreApiVO storeApiVO);

}
