package com.ejianc.business.zdsstore.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 对账/结算VO
 * 
 * @author generator
 * 
 */
@ApiModel("对账/结算VO")
public class StoreApiVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    

    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("来源单据id")
    private Long sourceId;
    @ApiModelProperty("来源单据编码")
    private String sourceBillCode;
    @ApiModelProperty("来源单据日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date sourceBillDate;

    private Integer inOutType;
    @ApiModelProperty("出入库类型名称")
    private String inOutTypeName;
    @ApiModelProperty("出入库属性1入库2出库")
    private Integer inOutFlag;

    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("采购合同id")
    private Long purchaseContractId;
    @ApiModelProperty("采购合同名称")
    private String purchaseContractName;
    @ApiModelProperty("物资名称")
    private String materialNames;

    @ApiModelProperty("金额含税")
    private BigDecimal taxMny;
    @ApiModelProperty("金额(无税)")
    private BigDecimal mny;

    @ApiModelProperty("是否对账1是0否")
    private Integer accountFlag;
    @ApiModelProperty("对账主表id")
    private Long accountId;
    @ApiModelProperty("对账时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date accountDate;
    @ApiModelProperty("对账单号")
    private String accountCode;

    @ApiModelProperty("是否结算1是0否")
    private Integer settleFlag;
    @ApiModelProperty("结算主表id")
    private Long settleId;
    @ApiModelProperty("结算时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;
    @ApiModelProperty("结算单号")
    private String settleCode;


    @ApiModelProperty("明细")
    private List<FlowVO> detail;

    public Integer getAccountFlag() {
        return accountFlag;
    }

    public void setAccountFlag(Integer accountFlag) {
        this.accountFlag = accountFlag;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }


    public Date getAccountDate() {
        return accountDate;
    }

    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }


    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public Integer getInOutType() {
        return inOutType;
    }

    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }

    public String getInOutTypeName() {
        return inOutTypeName;
    }

    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }

    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getPurchaseContractId() {
        return purchaseContractId;
    }

    public void setPurchaseContractId(Long purchaseContractId) {
        this.purchaseContractId = purchaseContractId;
    }

    public String getPurchaseContractName() {
        return purchaseContractName;
    }

    public void setPurchaseContractName(String purchaseContractName) {
        this.purchaseContractName = purchaseContractName;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public List<FlowVO> getDetail() {
        return detail;
    }

    public void setDetail(List<FlowVO> detail) {
        this.detail = detail;
    }
}
