package com.ejianc.business.zdsstore.api;

import com.ejianc.business.zdsstore.hystrix.IdleManageHystrix;
import com.ejianc.business.zdsstore.vo.IdleFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 出入库管理api
 * @date 2022/1/17
 */
@FeignClient(name = "ejc-zdsstore-web", url = "${common.env.feign-client-url}", path = "ejc-zdsstore-web", fallback = IdleManageHystrix.class)
public interface IIdleManageApi {


    @RequestMapping(value = "/api/idleManage/inOutStore", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> inOutStore(@RequestBody List<IdleFlowVO> flowVOS);

    @RequestMapping(value = "/api/idleManage/inOutStoreRollback", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<String> inOutStoreRollback(@RequestParam("sourceId") Long sourceId);
}
