package com.ejianc.business.zdsstore.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 调拨出库
 *
 * @author generator
 *
 */
public class AllotOutVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long projectId; // 出库项目id
    private String projectName; // 出库项目名称
    private Long orgId; // 出库组织id
    private String orgName; // 出库组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long storeId; // 出库仓库id
    private String storeName; // 出库仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出的时间
    private BigDecimal outMny; // 调出金额
    private BigDecimal outTaxMny; // 调出金额
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    private Long inProjectId; // 调入项目id
    private String inProjectName; // 调入项目名称
    private Long inParentOrgId; // 调入项目部上级组织Id
    private String inParentOrgName; // 调入项目部上级组织名称
    private String inParentOrgCode; // 调入项目部上级组织编码
    private Long inOrgId; // 调入组织id
    private String inOrgName; // 调入组织名称
    private String materialNames; // 出库物资名称集合
    private Long receiverId; // 通知收料状人id
    private String receiverName; // 通知收料状人
    private String memo; // 备注
    private String returnReason; // 调入组织退回原因
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    private String receiverPersonId; // 收料人id
    private String receiverPerson; // 收料人
    private Long inStoreId; // 入库id
    private String inStoreName; // 入库名称
    private Date receiveDate; // 收料时间
    private BigDecimal  sumAllotDiffMny;//调拨差额(无税)
    private BigDecimal  sumAllotDiffTaxMny;//调拨差额
    private String relationFlag; // 关联状态
    private String proportionFlag; // 分摊状态
    @SubEntity
    private List<AllotOutDetailVO> allotOutDetailList = new ArrayList<>(); // 调拨出库子表

    private String orgCode; // 项目组织编码

    private String inOrgCode; // 调入组织名称
    private String inCompanyName; // 调入单位名称(项目大区)
    private String companyName; // 调出单位名称（项目大区）
    private String projectCode; // 出库项目编码
    private String inProjectCode; // 调入项目编码
    private Integer allocatOutType; // 调拨出库类型 1 项目仓库 2 大区仓库


    private Long inStoreOrgId;//调入单位
    private String inStoreOrgName;//调入单位 名称
    private String inStoreOrgCode;//调入单位 编码
    private Long outStoreOrgId;//调出单位
    private String outStoreOrgName;//调出单位 名称
    private String outStoreOrgCode;//调出单位 编码
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getInStoreOrgId() {
        return inStoreOrgId;
    }
    @ReferDeserialTransfer
    public void setInStoreOrgId(Long inStoreOrgId) {
        this.inStoreOrgId = inStoreOrgId;
    }

    public String getInStoreOrgName() {
        return inStoreOrgName;
    }

    public void setInStoreOrgName(String inStoreOrgName) {
        this.inStoreOrgName = inStoreOrgName;
    }


    public String getInStoreOrgCode() {
        return inStoreOrgCode;
    }

    public void setInStoreOrgCode(String inStoreOrgCode) {
        this.inStoreOrgCode = inStoreOrgCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOutStoreOrgId() {
        return outStoreOrgId;
    }
    @ReferDeserialTransfer
    public void setOutStoreOrgId(Long outStoreOrgId) {
        this.outStoreOrgId = outStoreOrgId;
    }

    public String getOutStoreOrgName() {
        return outStoreOrgName;
    }

    public void setOutStoreOrgName(String outStoreOrgName) {
        this.outStoreOrgName = outStoreOrgName;
    }


    public String getOutStoreOrgCode() {
        return outStoreOrgCode;
    }

    public void setOutStoreOrgCode(String outStoreOrgCode) {
        this.outStoreOrgCode = outStoreOrgCode;
    }

    public Integer getAllocatOutType() {
        return allocatOutType;
    }

    public void setAllocatOutType(Integer allocatOutType) {
        this.allocatOutType = allocatOutType;
    }

    public String getInProjectCode() {
        return inProjectCode;
    }

    public void setInProjectCode(String inProjectCode) {
        this.inProjectCode = inProjectCode;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getInCompanyName() {
        return inCompanyName;
    }

    public void setInCompanyName(String inCompanyName) {
        this.inCompanyName = inCompanyName;
    }

    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="zdsstore-store")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getInProjectId() {
        return inProjectId;
    }
    @ReferDeserialTransfer
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }

    public String getInParentOrgName() {
        return inParentOrgName;
    }

    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }

    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getInOrgId() {
        return inOrgId;
    }
    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getReceiverId() {
        return receiverId;
    }
    @ReferDeserialTransfer
    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }
    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }

     public List<AllotOutDetailVO> getAllotOutDetailList() {
        return allotOutDetailList;
     }

     public void setAllotOutDetailList(List<AllotOutDetailVO> allotOutDetailList) {
        this.allotOutDetailList = allotOutDetailList;
     }

    public String getReceiverPersonId() {
        return receiverPersonId;
    }

    public void setReceiverPersonId(String receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }

    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public BigDecimal getSumAllotDiffMny() {
        return sumAllotDiffMny;
    }

    public void setSumAllotDiffMny(BigDecimal sumAllotDiffMny) {
        this.sumAllotDiffMny = sumAllotDiffMny;
    }

    public BigDecimal getSumAllotDiffTaxMny() {
        return sumAllotDiffTaxMny;
    }

    public void setSumAllotDiffTaxMny(BigDecimal sumAllotDiffTaxMny) {
        this.sumAllotDiffTaxMny = sumAllotDiffTaxMny;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public StoreManageVO getStoreManageVO(AllotOutVO vo ){

        StoreManageVO storeManageVO = new StoreManageVO();
       if (vo!=null){
           List<AllotOutDetailVO> allotOutDetailList = vo.getAllotOutDetailList();
           if (vo.getStoreId()!=null)
           storeManageVO.setStoreId(vo.getStoreId());
           storeManageVO.setSourceId(vo.getId());
           storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
           ArrayList<FlowVO> flowVOS = new ArrayList<>();
           vo.getAllotOutDetailList().forEach(t->{
               FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.调拨出库, 0);
               flowVO.setBrandId(t.getBrandId());
               flowVO.setBrandName(t.getBrandName());
               flowVO.setStoreId(t.getDetailStoreId());
               flowVO.setStoreName(t.getDetailStoreName());
               flowVO.setSourceBillTypeName("调拨出库");
               flowVO.setSourceBillTypeCode("EJCBT202312000014");
               flowVO.setProjectId(vo.getProjectId());
               flowVO.setProjectName(vo.getProjectName());
               flowVO.setOrgId(vo.getOrgId());
               flowVO.setOrgName(vo.getOrgName());
               flowVO.setParentOrgId(vo.getParentOrgId());
               flowVO.setParentOrgName(vo.getParentOrgName());
               flowVO.setParentOrgCode(vo.getParentOrgCode());
               flowVO.setEmployeeId(vo.getEmployeeId());
               flowVO.setEmployeeName(vo.getEmployeeName());
               flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
               flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
               flowVO.setMaterialId(t.getMaterialId());
               flowVO.setMaterialName(t.getMaterialName());
               flowVO.setMaterialSpec(t.getMaterialSpec());
               flowVO.setMaterialUnitId(t.getMaterialUnitId());
               flowVO.setMaterialUnitName(t.getMaterialUnit());
               flowVO.setNum(t.getAllocatNum());
               flowVO.setTaxPrice(t.getAllocatTaxPrice());
               flowVO.setPrice(t.getAllocatPrice());
               flowVO.setTax(t.getAllocatTax());
               flowVO.setTaxMny(t.getAllocatTaxMny());
               flowVO.setMny(t.getAllocatMny());
               flowVO.setTaxRate(t.getAllocatTaxRate());
               flowVO.setSourceId(vo.getId());
               flowVO.setSourceDetailId(t.getId());
               flowVO.setSourceBillCode(vo.getBillCode());
               flowVO.setSourceBillDate(vo.getOutDate());
               flowVO.setSourceBillRemark(vo.getMemo());
               flowVO.setRowState(t.getRowState());
               flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
               flowVO.setBrandId(t.getBrandId());
               flowVO.setBrandName(t.getBrandName());
               flowVO.setProductCode(t.getProductCode());
               flowVOS.add(flowVO);
           });
           storeManageVO.setFlowVOList(flowVOS);
       }
        return storeManageVO;
    }

    public List<StoreManageVO> getStoreManageVOList(AllotOutVO vo ){
        List<StoreManageVO> list = new ArrayList<>();
        if (vo!=null){
            List<AllotOutDetailVO> allotOutDetailList = vo.getAllotOutDetailList();
            allotOutDetailList.forEach(t->{
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(t.getDetailStoreId());
                storeManageVO.setSourceId(vo.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
                ArrayList<FlowVO> flowVOS = new ArrayList<>();
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.调拨出库, 0);
                flowVO.setBrandId(t.getBrandId());
                flowVO.setRowState(t.getRowState());
                flowVO.setBrandName(t.getBrandName());
                flowVO.setStoreId(t.getDetailStoreId());
                flowVO.setStoreName(t.getDetailStoreName());
                flowVO.setProductCode(t.getProductCode());
                flowVO.setSourceBillTypeName("调拨出库");
                flowVO.setSourceBillTypeCode("EJCBT202312000014");
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialUnit());
                flowVO.setNum(t.getAllocatNum());
                flowVO.setTaxPrice(t.getAllocatTaxPrice());
                flowVO.setPrice(t.getAllocatPrice());
                flowVO.setTax(t.getAllocatTax());
                flowVO.setTaxMny(t.getAllocatTaxMny());
                flowVO.setMny(t.getAllocatMny());
                flowVO.setTaxRate(t.getAllocatTaxRate());
                flowVO.setSourceId(vo.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillRemark(vo.getMemo());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                if(null!=vo.getAllocatOutType()){
                    flowVO.setCusDef3(vo.getAllocatOutType().toString());
                }
                flowVO.setMaterialCategoryCode(t.getMaterialCategoryCode());
                flowVO.setMaterialCode(t.getMaterialCode());

                flowVOS.add(flowVO);
                storeManageVO.setFlowVOList(flowVOS);
                list.add(storeManageVO);
            });
        }
    return list;
    }
}
