package com.ejianc.business.zdsstore.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料退库表
 *
 * @author generator
 */
public class PickReturnVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private Long orgId; // 所属项目部id
    private String orgName; // 所属项目部名称
    private Long parentOrgId; // 项目部上级组织
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private String billCode; // 退库单号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate; // 退库日期
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    private Long contractId; // 分包合同id
    private String contractName; // 分包合同名称
    private Long subOrgId; // 分包单位id
    private String subOrgName; // 分包单位名称
    private String managerName; // 负责人姓名
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 部门id
    private String departmentName; // 部门名称
    private Long projectId; // 所属项目
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private String instoreType; // 入库类型
    private String memo; // 备注
    private String materialNames; // 材料分类名称
    private BigDecimal totalTaxMny; // 退库金额含税
    private BigDecimal totalMny; // 退库金额不含税
    private String pickReturnName; // 退料人
    private String pickReturnReason; // 退库原因
    @SubEntity
    private List<PickReturnDetailVO> pickReturnDetailList = new ArrayList<>(); // 材料退库明细表
    @SubEntity
    private List<PickReturnDetailVO> pickSubReturnDetailList = new ArrayList<>(); // 材料退库明细表 来源供方
    private String relationFlag; // 关联状态
    private String proportionFlag; // 分摊状态

    private String totalSelfTaxMny;//合计子表自购材物资的含税金额
    private String totalSelfMny;//合计子表自购材物资的无税金额

    private String orgCode; // 项目组织编码

    private Integer pickType; //领料方式：1-内部领料，2-分包领料
    private String pickTypeName; //领料方式名称

    private Integer confirmStatus;//确认状态 0：未确认 1：已确认；2:已退回
    private Integer sourceType;//来源：0：自制 1：供方申请
    private Long sourceId;//来源id
    private Long sourceSystemId;//来源id
    private Integer signStatus; // 签字状态，0-未签字,1-已签字

    public List<PickReturnDetailVO> getPickSubReturnDetailList() {
        return pickSubReturnDetailList;
    }

    public void setPickSubReturnDetailList(List<PickReturnDetailVO> pickSubReturnDetailList) {
        this.pickSubReturnDetailList = pickSubReturnDetailList;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Long getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(Long sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getPickType() {
        return pickType;
    }

    public void setPickType(Integer pickType) {
        this.pickType = pickType;
    }

    public String getPickTypeName() {
        return pickTypeName;
    }

    public void setPickTypeName(String pickTypeName) {
        this.pickTypeName = pickTypeName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getSubOrgId() {
        return subOrgId;
    }

    public void setSubOrgId(Long subOrgId) {
        this.subOrgId = subOrgId;
    }

    public String getSubOrgName() {
        return subOrgName;
    }

    public void setSubOrgName(String subOrgName) {
        this.subOrgName = subOrgName;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getInstoreType() {
        return instoreType;
    }

    public void setInstoreType(String instoreType) {
        this.instoreType = instoreType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public String getPickReturnName() {
        return pickReturnName;
    }

    public void setPickReturnName(String pickReturnName) {
        this.pickReturnName = pickReturnName;
    }

    public String getPickReturnReason() {
        return pickReturnReason;
    }

    public void setPickReturnReason(String pickReturnReason) {
        this.pickReturnReason = pickReturnReason;
    }

    public List<PickReturnDetailVO> getPickReturnDetailList() {
        return pickReturnDetailList;
    }

    public void setPickReturnDetailList(List<PickReturnDetailVO> pickReturnDetailList) {
        this.pickReturnDetailList = pickReturnDetailList;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getTotalSelfTaxMny() {
        return totalSelfTaxMny;
    }

    public void setTotalSelfTaxMny(String totalSelfTaxMny) {
        this.totalSelfTaxMny = totalSelfTaxMny;
    }

    public String getTotalSelfMny() {
        return totalSelfMny;
    }

    public void setTotalSelfMny(String totalSelfMny) {
        this.totalSelfMny = totalSelfMny;
    }

    public StoreManageVO getStoreManageVO(PickReturnVO vo, Long storeId) {
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo != null) {
            storeManageVO.setSourceId(vo.getId());
            storeManageVO.setStoreId(storeId);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料退库);
            List<FlowVO> list = new ArrayList<>();
            vo.getPickReturnDetailList().forEach(item -> {
                if (storeId.equals(item.getStoreId())) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料退库, 0);
                    flowVO.setSourceId(vo.getId());//主表id
                    flowVO.setSourceDetailId(item.getId());//子表id
                    flowVO.setSourceBillCode(vo.getBillCode());
                    flowVO.setSourceBillDate(vo.getInstoreDate());
                    flowVO.setSourceBillTypeName("材料退库");
                    flowVO.setSourceBillTypeCode("EJCBT202312000017");
                    flowVO.setProjectId(vo.getProjectId());//项目
                    flowVO.setProjectName(vo.getProjectName());
                    flowVO.setParentOrgId(vo.getParentOrgId());
                    flowVO.setParentOrgCode(vo.getParentOrgCode());
                    flowVO.setParentOrgName(vo.getParentOrgName());
                    flowVO.setOrgId(vo.getOrgId());
                    flowVO.setOrgName(vo.getOrgName());
                    flowVO.setStoreId(storeId);//仓库
                    flowVO.setStoreName(item.getStoreName());
                    flowVO.setBillCode(vo.getBillCode());//退库编号
                    flowVO.setBillDate(vo.getInstoreDate());//退库日期
                    flowVO.setPickContractId(vo.getContractId());//主表合同
                    flowVO.setPickContractName(vo.getContractName());//主表合同名称
                    flowVO.setSupplierId(vo.getSubOrgId());//分包单位
                    flowVO.setSupplierName(vo.getSubOrgName());
                    flowVO.setSourceBillPurpose(vo.getPickReturnReason());
                    flowVO.setEmployeeId(vo.getEmployeeId());
                    flowVO.setEmployeeName(vo.getEmployeeName());
                    flowVO.setPickType(vo.getPickType());
                    flowVO.setPickTypeName(vo.getPickTypeName());
                    flowVO.setMaterialCode(item.getMaterialCode());
                    flowVO.setMaterialCategoryCode(item.getMaterialCategoryCode());
                    flowVO.setProductCode(item.getProductCode());
                    flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                    flowVO.setMaterialId(item.getMaterialId());
                    flowVO.setMaterialName(item.getMaterialName());
                    flowVO.setMaterialCode(item.getMaterialCode());
                    flowVO.setMaterialSpec(item.getMaterialSpec());
                    flowVO.setMaterialUnitId(item.getMaterialUnitId());
                    flowVO.setMaterialUnitName(item.getMaterialUnitName());
                    flowVO.setNum(item.getReturnNum());//退库数量
                    flowVO.setTaxMny(item.getTaxMny());//金额
                    flowVO.setTaxPrice(item.getTaxPrice());//单价
                    flowVO.setTax(item.getTax());//税额
                    flowVO.setMny(item.getMny());
                    flowVO.setBrandName(item.getBrandName());
                    flowVO.setBrandId(item.getBrandId());
                    flowVO.setPrice(item.getPrice());
                    flowVO.setInOutId(item.getInOutId());//出入库关系id
                    flowVO.setSourceBillPurpose(vo.getMemo());
                    flowVO.setSourceBillDetailRemark(item.getMemo());
                    flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                    list.add(flowVO);
                }
            });
            storeManageVO.setFlowVOList(list);
        }
        return storeManageVO;
    }
}
