package com.ejianc.business.zdsstore.api;

import com.ejianc.business.zdsstore.hystrix.StoreFlowHystrix;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.InOutVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 出入库管理api
 * @date 2022/1/17
 */
@FeignClient(name = "ejc-zdsstore-web", url = "${common.env.feign-client-url}", path = "ejc-zdsstore-web", fallback = StoreFlowHystrix.class)
public interface IStoreFlowApi {


    /**
     * @param queryParam
     * @description: 查询流水
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/3/9
     */
    @RequestMapping(value = "/api/storeFlow/getFlowList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowList(@RequestBody QueryParam queryParam);

    /**
     * @param queryParam
     * @description: 查询出入库关系
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.InOutVO>
     * @author 姜轶凯
     * @date: 2022/3/9
     */
    @RequestMapping(value = "/api/storeFlow/getInOutVOList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<InOutVO>> getInOutVOList(@RequestBody QueryParam queryParam);

    /**
     * 批量获取最新单价
     * @param flowVOS
     * @return
     */
    @RequestMapping(value = "/api/storeFlow/getNewPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<FlowVO>> getNewPrice(@RequestBody List<FlowVO> flowVOS);


    /**
     * 批量获取最新的库存余量
     * @param surplusVOS
     * @return
     */
    @RequestMapping(value = "/api/storeFlow/getNewSurplusNum", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<SurplusVO>> getNewSurplusNum(@RequestBody List<SurplusVO> surplusVOS);

    /**
     * 根据仓库查询库存参照
     * @param storeId
     * @return
     */
    @RequestMapping(value = "/api/storeFlow/refSurplusData", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<SurplusVO>> refSurplusData(@RequestParam("storeId") Long storeId);
}
