package com.ejianc.business.zdsstore.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/18 11:33
 */
public class ProjectStaticsVO implements Serializable {

    private String subContractCode;

    private BigDecimal inStoreNum;
    private BigDecimal outStoreNum;

    @ApiModelProperty("流水单号")
    private String billCode;
    @ApiModelProperty("流水日期")
    private Date billDate;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("仓库")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("生效时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    @ApiModelProperty("生效状态0自由1已生效")
    private Integer effectiveState;
    @ApiModelProperty("针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成")
    private Integer outUseFlag;
    @ApiModelProperty("业务经办人ID")
    private Long employeeId;
    @ApiModelProperty("业务经办人名称")
    private String employeeName;
    @ApiModelProperty("出入库类型:收料入库等")
    private Integer inOutType;
    @ApiModelProperty("出入库类型名称")
    private String inOutTypeName;
    @ApiModelProperty("出入库属性1入库2出库")
    private Integer inOutFlag;
    @ApiModelProperty("是否甲供1是0否")
    private Integer partyaFlag;
    @ApiModelProperty("是否退货1是0否")
    private Integer returnGoodsFlag;
    @ApiModelProperty("是否退库1是0否")
    private Integer returnStoreFlag;
    @ApiModelProperty("是否对账1是0否")
    private Integer accountFlag;
    @ApiModelProperty("对账主表id")
    private Long accountId;
    @ApiModelProperty("对账子表id")
    private Long accountDetailId;
    @ApiModelProperty("对账时间")
    private Date accountDate;
    @ApiModelProperty("对账单号")
    private String accountCode;
    @ApiModelProperty("是否结算1是0否")
    private Integer settleFlag;
    @ApiModelProperty("结算主表id")
    private Long settleId;
    @ApiModelProperty("结算子表id")
    private Long settleDetailId;
    @ApiModelProperty("结算时间")
    private Date settleDate;
    @ApiModelProperty("结算单号")
    private String settleCode;
    @ApiModelProperty("仓库属性")
    private String storeType;
    @ApiModelProperty("仓库属性名称")
    private String storeTypeName;
    @ApiModelProperty("材料类型编码")
    private String materialType;
    @ApiModelProperty("材料类型名称")
    private String materialTypeName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("采购合同id")
    private Long purchaseContractId;
    @ApiModelProperty("采购合同名称")
    private String purchaseContractName;
    @ApiModelProperty("物资分类id")
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialCategoryCode")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资内码")
    private String materialInnerCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额含税")
    private BigDecimal taxMny;
    @ApiModelProperty("金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("外加剂id,逗号分隔")
    private String admixtureId;
    @ApiModelProperty("外加剂名称,逗号分隔")
    private String admixtureName;
    @ApiModelProperty("外加剂综合单价")
    private BigDecimal admixturePrice;
    @ApiModelProperty("领料单位id")
    private Long pickUnitId;
    @ApiModelProperty("领料单位")
    private String pickUnitName;
    @ApiModelProperty("领料合同id")
    private Long pickContractId;
    @ApiModelProperty("领料合同")
    private String pickContractName;
    @ApiModelProperty("累计出库数量")
    private BigDecimal outNum;
    @ApiModelProperty("出库占用数量")
    private BigDecimal outLockNum;
    @ApiModelProperty("入库余额(无税)")
    private BigDecimal surplusMny;
    @ApiModelProperty("入库余额")
    private BigDecimal surplusTaxMny;
    @ApiModelProperty("入库余量")
    private BigDecimal surplusNum;
    @ApiModelProperty("库存数量")
    private BigDecimal stockNum;
    @ApiModelProperty("来源单据类型名称")
    private String sourceBillTypeName;
    @ApiModelProperty("来源单据类型编码")
    private String sourceBillTypeCode;
    @ApiModelProperty("来源单据id")
    private Long sourceId;
    @ApiModelProperty("来源单据明细id")
    private Long sourceDetailId;
    @ApiModelProperty("来源单据编码")
    private String sourceBillCode;
    @ApiModelProperty("来源单据日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date sourceBillDate;
    @ApiModelProperty("来源单据备注")
    private String sourceBillRemark;
    @ApiModelProperty("来源单据明细备注")
    private String sourceBillDetailRemark;
    @ApiModelProperty("来源单据用途")
    private String sourceBillPurpose;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    @ApiModelProperty("自定义字段1")
    private String cusDef1;
    @ApiModelProperty("是否推送低值易耗品仓库 1是 其他皆为否")
    private String consumableFlag;
    @ApiModelProperty("自定义字段3")
    private String cusDef3;
    @ApiModelProperty("自定义字段4")
    private String cusDef4;
    @ApiModelProperty("自定义字段5")
    private String cusDef5;
    @ApiModelProperty("自定义字段6")
    private String cusDef6;
    @ApiModelProperty("自定义字段7")
    private String cusDef7;
    @ApiModelProperty("自定义字段8")
    private String cusDef8;
    @ApiModelProperty("自定义字段9")
    private String cusDef9;
    @ApiModelProperty("自定义字段10")
    private String cusDef10;

    @ApiModelProperty("直入直出流水id")
    private Long straightOutFlowId;
    @ApiModelProperty("出入关系id,退库使用,关联发生退库的出库关系")
    private Long inOutId;

    @ApiModelProperty("暂估单价(无税)")
    private BigDecimal estimatePrice;
    @ApiModelProperty("暂估单价")
    private BigDecimal estimateTaxPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 周转材当前净值=入库金额-摊销金额-出库净值
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("当前净值(无税)")
    private BigDecimal netMny;
    @ApiModelProperty("当前净值")
    private BigDecimal netTaxMny;

    /**
     * 周转材摊销金额（累计值）
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("摊销金额(无税)")
    private BigDecimal shareMny;
    @ApiModelProperty("摊销金额")
    private BigDecimal shareTaxMny;

    /**
     * 周转材出库净值（累计值）=出库数量 * (（入库金额-摊销金额-出库净值）/库存数量)，每次出库后重算
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("出库净值(无税)")
    private BigDecimal outNetMny;
    @ApiModelProperty("出库净值")
    private BigDecimal outNetTaxMny;

    /**
     * 周转材采购入库原价=入库单价，调拨入库=调出采购均价（调出单计算、调入单传入）
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal purchasePrice;
    @ApiModelProperty("原值单价")
    private BigDecimal purchaseTaxPrice;

    @ApiModelProperty("是否周转材 1是0否")
    private Integer turnFlag;

    @ApiModelProperty("上次摊销日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date lastShareDate;

    @ApiModelProperty("来源 0-自制,1-订单")
    private Integer sourceType;

    @ApiModelProperty("合同单价无税")
    private BigDecimal contractPrice;

    @ApiModelProperty("合同单价含税")
    private BigDecimal contractTaxPrice;


    @ApiModelProperty("结算单价(无税),不存库")
    private BigDecimal settlePrice;
    @ApiModelProperty("结算单价,不存库")
    private BigDecimal settleTaxPrice;

    @ApiModelProperty("结算金额(无税),不存库")
    private BigDecimal settleMny;
    @ApiModelProperty("结算金额,不存库")
    private BigDecimal settleTaxMny;
    @ApiModelProperty("结算税额,不存库")
    private BigDecimal settleTax;

    @ApiModelProperty("成本金额(无税),不存库")
    private BigDecimal costMny;
    @ApiModelProperty("成本金额,不存库")
    private BigDecimal costTaxMny;
    @ApiModelProperty("成本税额,不存库")
    private BigDecimal costTax;


    @ApiModelProperty("调差金额(无税),不存库")
    private BigDecimal diffMny;
    @ApiModelProperty("调差金额,不存库")
    private BigDecimal diffTaxMny;
    @ApiModelProperty("调差税额,不存库")
    private BigDecimal diffTax;

    @ApiModelProperty("是否有合同,不存库")
    private String contractFlagStr;
    @ApiModelProperty("来源,不存库")
    private String sourceTypeStr;
    //报表使用-材料收发存汇总
    @ApiModelProperty("出库金额")
    private BigDecimal outTaxMny;
    @ApiModelProperty("出库金额")
    private BigDecimal outMny;

    @ApiModelProperty("领料方式：1-内部领料，2-分包领料")
    private Integer pickType;
    @ApiModelProperty("领料方式名称")
    private String pickTypeName;

    private String licensePlate; // 车牌号

    private String subEmployeeName; // 分包负责人

    private String useFor; // 使用部位
    private Long brandId; // 品牌主键
    private String brandName; // 品牌名称
    @ApiModelProperty("产品代码")
    private String productCode;

    public String getSubContractCode() {
        return subContractCode;
    }

    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }

    public BigDecimal getInStoreNum() {
        return inStoreNum;
    }

    public void setInStoreNum(BigDecimal inStoreNum) {
        this.inStoreNum = inStoreNum;
    }

    public BigDecimal getOutStoreNum() {
        return outStoreNum;
    }

    public void setOutStoreNum(BigDecimal outStoreNum) {
        this.outStoreNum = outStoreNum;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getEffectiveState() {
        return effectiveState;
    }

    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }

    public Integer getOutUseFlag() {
        return outUseFlag;
    }

    public void setOutUseFlag(Integer outUseFlag) {
        this.outUseFlag = outUseFlag;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Integer getInOutType() {
        return inOutType;
    }

    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }

    public String getInOutTypeName() {
        return inOutTypeName;
    }

    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }

    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public Integer getPartyaFlag() {
        return partyaFlag;
    }

    public void setPartyaFlag(Integer partyaFlag) {
        this.partyaFlag = partyaFlag;
    }

    public Integer getReturnGoodsFlag() {
        return returnGoodsFlag;
    }

    public void setReturnGoodsFlag(Integer returnGoodsFlag) {
        this.returnGoodsFlag = returnGoodsFlag;
    }

    public Integer getReturnStoreFlag() {
        return returnStoreFlag;
    }

    public void setReturnStoreFlag(Integer returnStoreFlag) {
        this.returnStoreFlag = returnStoreFlag;
    }

    public Integer getAccountFlag() {
        return accountFlag;
    }

    public void setAccountFlag(Integer accountFlag) {
        this.accountFlag = accountFlag;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAccountDetailId() {
        return accountDetailId;
    }

    public void setAccountDetailId(Long accountDetailId) {
        this.accountDetailId = accountDetailId;
    }

    public Date getAccountDate() {
        return accountDate;
    }

    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }

    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getSettleDetailId() {
        return settleDetailId;
    }

    public void setSettleDetailId(Long settleDetailId) {
        this.settleDetailId = settleDetailId;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getPurchaseContractId() {
        return purchaseContractId;
    }

    public void setPurchaseContractId(Long purchaseContractId) {
        this.purchaseContractId = purchaseContractId;
    }

    public String getPurchaseContractName() {
        return purchaseContractName;
    }

    public void setPurchaseContractName(String purchaseContractName) {
        this.purchaseContractName = purchaseContractName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }

    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getAdmixtureId() {
        return admixtureId;
    }

    public void setAdmixtureId(String admixtureId) {
        this.admixtureId = admixtureId;
    }

    public String getAdmixtureName() {
        return admixtureName;
    }

    public void setAdmixtureName(String admixtureName) {
        this.admixtureName = admixtureName;
    }

    public BigDecimal getAdmixturePrice() {
        return admixturePrice;
    }

    public void setAdmixturePrice(BigDecimal admixturePrice) {
        this.admixturePrice = admixturePrice;
    }

    public Long getPickUnitId() {
        return pickUnitId;
    }

    public void setPickUnitId(Long pickUnitId) {
        this.pickUnitId = pickUnitId;
    }

    public String getPickUnitName() {
        return pickUnitName;
    }

    public void setPickUnitName(String pickUnitName) {
        this.pickUnitName = pickUnitName;
    }

    public Long getPickContractId() {
        return pickContractId;
    }

    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }

    public String getPickContractName() {
        return pickContractName;
    }

    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }

    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public BigDecimal getSurplusTaxMny() {
        return surplusTaxMny;
    }

    public void setSurplusTaxMny(BigDecimal surplusTaxMny) {
        this.surplusTaxMny = surplusTaxMny;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public BigDecimal getStockNum() {
        return stockNum;
    }

    public void setStockNum(BigDecimal stockNum) {
        this.stockNum = stockNum;
    }

    public String getSourceBillTypeName() {
        return sourceBillTypeName;
    }

    public void setSourceBillTypeName(String sourceBillTypeName) {
        this.sourceBillTypeName = sourceBillTypeName;
    }

    public String getSourceBillTypeCode() {
        return sourceBillTypeCode;
    }

    public void setSourceBillTypeCode(String sourceBillTypeCode) {
        this.sourceBillTypeCode = sourceBillTypeCode;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public String getSourceBillRemark() {
        return sourceBillRemark;
    }

    public void setSourceBillRemark(String sourceBillRemark) {
        this.sourceBillRemark = sourceBillRemark;
    }

    public String getSourceBillDetailRemark() {
        return sourceBillDetailRemark;
    }

    public void setSourceBillDetailRemark(String sourceBillDetailRemark) {
        this.sourceBillDetailRemark = sourceBillDetailRemark;
    }

    public String getSourceBillPurpose() {
        return sourceBillPurpose;
    }

    public void setSourceBillPurpose(String sourceBillPurpose) {
        this.sourceBillPurpose = sourceBillPurpose;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getCusDef1() {
        return cusDef1;
    }

    public void setCusDef1(String cusDef1) {
        this.cusDef1 = cusDef1;
    }

    public String getConsumableFlag() {
        return consumableFlag;
    }

    public void setConsumableFlag(String consumableFlag) {
        this.consumableFlag = consumableFlag;
    }

    public String getCusDef3() {
        return cusDef3;
    }

    public void setCusDef3(String cusDef3) {
        this.cusDef3 = cusDef3;
    }

    public String getCusDef4() {
        return cusDef4;
    }

    public void setCusDef4(String cusDef4) {
        this.cusDef4 = cusDef4;
    }

    public String getCusDef5() {
        return cusDef5;
    }

    public void setCusDef5(String cusDef5) {
        this.cusDef5 = cusDef5;
    }

    public String getCusDef6() {
        return cusDef6;
    }

    public void setCusDef6(String cusDef6) {
        this.cusDef6 = cusDef6;
    }

    public String getCusDef7() {
        return cusDef7;
    }

    public void setCusDef7(String cusDef7) {
        this.cusDef7 = cusDef7;
    }

    public String getCusDef8() {
        return cusDef8;
    }

    public void setCusDef8(String cusDef8) {
        this.cusDef8 = cusDef8;
    }

    public String getCusDef9() {
        return cusDef9;
    }

    public void setCusDef9(String cusDef9) {
        this.cusDef9 = cusDef9;
    }

    public String getCusDef10() {
        return cusDef10;
    }

    public void setCusDef10(String cusDef10) {
        this.cusDef10 = cusDef10;
    }

    public Long getStraightOutFlowId() {
        return straightOutFlowId;
    }

    public void setStraightOutFlowId(Long straightOutFlowId) {
        this.straightOutFlowId = straightOutFlowId;
    }

    public Long getInOutId() {
        return inOutId;
    }

    public void setInOutId(Long inOutId) {
        this.inOutId = inOutId;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateTaxPrice() {
        return estimateTaxPrice;
    }

    public void setEstimateTaxPrice(BigDecimal estimateTaxPrice) {
        this.estimateTaxPrice = estimateTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNetMny() {
        return netMny;
    }

    public void setNetMny(BigDecimal netMny) {
        this.netMny = netMny;
    }

    public BigDecimal getNetTaxMny() {
        return netTaxMny;
    }

    public void setNetTaxMny(BigDecimal netTaxMny) {
        this.netTaxMny = netTaxMny;
    }

    public BigDecimal getShareMny() {
        return shareMny;
    }

    public void setShareMny(BigDecimal shareMny) {
        this.shareMny = shareMny;
    }

    public BigDecimal getShareTaxMny() {
        return shareTaxMny;
    }

    public void setShareTaxMny(BigDecimal shareTaxMny) {
        this.shareTaxMny = shareTaxMny;
    }

    public BigDecimal getOutNetMny() {
        return outNetMny;
    }

    public void setOutNetMny(BigDecimal outNetMny) {
        this.outNetMny = outNetMny;
    }

    public BigDecimal getOutNetTaxMny() {
        return outNetTaxMny;
    }

    public void setOutNetTaxMny(BigDecimal outNetTaxMny) {
        this.outNetTaxMny = outNetTaxMny;
    }

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public BigDecimal getPurchaseTaxPrice() {
        return purchaseTaxPrice;
    }

    public void setPurchaseTaxPrice(BigDecimal purchaseTaxPrice) {
        this.purchaseTaxPrice = purchaseTaxPrice;
    }

    public Integer getTurnFlag() {
        return turnFlag;
    }

    public void setTurnFlag(Integer turnFlag) {
        this.turnFlag = turnFlag;
    }

    public Date getLastShareDate() {
        return lastShareDate;
    }

    public void setLastShareDate(Date lastShareDate) {
        this.lastShareDate = lastShareDate;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }

    public BigDecimal getContractTaxPrice() {
        return contractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        this.contractTaxPrice = contractTaxPrice;
    }

    public BigDecimal getSettlePrice() {
        return settlePrice;
    }

    public void setSettlePrice(BigDecimal settlePrice) {
        this.settlePrice = settlePrice;
    }

    public BigDecimal getSettleTaxPrice() {
        return settleTaxPrice;
    }

    public void setSettleTaxPrice(BigDecimal settleTaxPrice) {
        this.settleTaxPrice = settleTaxPrice;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }

    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }

    public BigDecimal getDiffTaxMny() {
        return diffTaxMny;
    }

    public void setDiffTaxMny(BigDecimal diffTaxMny) {
        this.diffTaxMny = diffTaxMny;
    }

    public BigDecimal getDiffTax() {
        return diffTax;
    }

    public void setDiffTax(BigDecimal diffTax) {
        this.diffTax = diffTax;
    }

    public String getContractFlagStr() {
        return contractFlagStr;
    }

    public void setContractFlagStr(String contractFlagStr) {
        this.contractFlagStr = contractFlagStr;
    }

    public String getSourceTypeStr() {
        return sourceTypeStr;
    }

    public void setSourceTypeStr(String sourceTypeStr) {
        this.sourceTypeStr = sourceTypeStr;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public Integer getPickType() {
        return pickType;
    }

    public void setPickType(Integer pickType) {
        this.pickType = pickType;
    }

    public String getPickTypeName() {
        return pickTypeName;
    }

    public void setPickTypeName(String pickTypeName) {
        this.pickTypeName = pickTypeName;
    }

    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }

    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
}
