package com.ejianc.business.zdsstore.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.consts.ZDSStoreBillBypeEnums;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料退货表
 *
 * @author generator
 *
 */
public class ReturnGoodsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String billCode; // 出库编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 出库日期
    private Long projectId; // 出库项目id
    private String projectName; // 出库项目名称
    private String projectCode; // 所属项目编码
    private Long orgId; // 出库组织id
    private String orgName; // 出库组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long storeId; // 出库仓库id
    private String storeName; // 出库仓库名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode;//合同编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private BigDecimal returnTaxMny; // 退货金额
    private BigDecimal returnMny; // 退货金额不含税
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private String materialNames; // 出库物资名称集合
    private String memo; // 备注
    private String returnReason; // 退货原因
    private BigDecimal mnyDisparity; //退货差额
    private BigDecimal taxMnyDisparity; //退货差额（含税）

    private String orgCode; // 项目组织编码
    private Integer businessType; //业务类型 1-退货 2-换货
    private String sourceSystemId;
    private Integer signStatus; //签字状态 1-未签字 2-已签字

    private String sourceId;
    private Long signUserId; // 签字人id
    private String signUserName; // 签字人名称
    private String signUserPhone; // 签字人手机号
    private Date signTime; // 签字时间

    public Long getSignUserId() {
        return signUserId;
    }

    public void setSignUserId(Long signUserId) {
        this.signUserId = signUserId;
    }

    public String getSignUserName() {
        return signUserName;
    }

    public void setSignUserName(String signUserName) {
        this.signUserName = signUserName;
    }

    public String getSignUserPhone() {
        return signUserPhone;
    }

    public void setSignUserPhone(String signUserPhone) {
        this.signUserPhone = signUserPhone;
    }

    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public BigDecimal getMnyDisparity() {
        return mnyDisparity;
    }

    public void setMnyDisparity(BigDecimal mnyDisparity) {
        this.mnyDisparity = mnyDisparity;
    }

    public BigDecimal getTaxMnyDisparity() {
        return taxMnyDisparity;
    }

    public void setTaxMnyDisparity(BigDecimal taxMnyDisparity) {
        this.taxMnyDisparity = taxMnyDisparity;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @SubEntity
    private List<ReturnGoodsDetailVO> returnGoodsDetailList = new ArrayList<>(); // 材料退货明细表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="zdsstore-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    @ReferSerialTransfer(referCode="zds-ref-cont")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="zds-mat-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getReturnTaxMny() {
        return returnTaxMny;
    }

    public void setReturnTaxMny(BigDecimal returnTaxMny) {
        this.returnTaxMny = returnTaxMny;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

     public List<ReturnGoodsDetailVO> getReturnGoodsDetailList() {
        return returnGoodsDetailList;
     }

     public void setReturnGoodsDetailList(List<ReturnGoodsDetailVO> returnGoodsDetailList) {
        this.returnGoodsDetailList = returnGoodsDetailList;
     }

    public StoreManageVO getStoreManageVO(ReturnGoodsVO vo){
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo!=null){
            storeManageVO.setOutEffectiveON(true);
            storeManageVO.setStoreId(vo.getStoreId());
            storeManageVO.setSourceId(vo.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料退货);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            vo.getReturnGoodsDetailList().forEach(item->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.材料退货,0);
                flowVO.setSourceId(vo.getId());//主表id
                flowVO.setSourceDetailId(item.getId());//子表id
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillTypeName(ZDSStoreBillBypeEnums.材料退货.getName());
                flowVO.setSourceBillTypeCode(ZDSStoreBillBypeEnums.材料退货.getCode());
                flowVO.setStoreId(vo.getStoreId());
                flowVO.setStoreName(vo.getStoreName());
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setPurchaseContractId(vo.getContractId());
                flowVO.setPurchaseContractName(vo.getContractName());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setEffectiveDate(new Date());
                flowVO.setEffectiveState(1);
                flowVO.setSupplierId(vo.getSupplierId());
                flowVO.setSupplierName(vo.getSupplierName());
                flowVO.setMaterialCategoryId(item.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(item.getMaterialCategoryName());
                flowVO.setMaterialCategoryCode(item.getMaterialTypeCode());
                flowVO.setMaterialId(item.getMaterialId());
                flowVO.setMaterialName(item.getMaterialName());
                flowVO.setMaterialCode(item.getMaterialCode());
                flowVO.setMaterialSpec(item.getMaterialSpec());
                flowVO.setMaterialUnitId(item.getMaterialUnitId());
                flowVO.setMaterialUnitName(item.getMaterialUnitName());
                flowVO.setNum(item.getReturnNum());//退货数量？？？？？
                flowVO.setTaxPrice(item.getReturnTaxPrice());
                flowVO.setPrice(item.getReturnPrice());
                flowVO.setTaxRate(item.getTaxRate());
                flowVO.setTaxMny(item.getTaxMny());
                flowVO.setMny(item.getMny());
                flowVO.setTax(item.getTax());
                flowVO.setContractTaxPrice(item.getContractPrice());//合同单价
                flowVO.setSourceBillPurpose(vo.getMemo());
                flowVO.setSourceBillDetailRemark(item.getMemo());
                flowVO.setSourceType(StoreCommonConsts.ZERO);// 0-自制,1-订单
                flowVO.setBrandName(item.getBrandName());
                flowVO.setBrandId(item.getBrandId());
                flowVO.setProductCode(item.getProductCode());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            ArrayList<Long> longs = new ArrayList<>();
            longs.add(vo.getId());
            storeManageVO.setSourceIdsForRollBack(longs);
        }
        return storeManageVO;
    }
}
