/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="returnGoods")
public class ReturnGoodsBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReturnGoodsService returnGoodsService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private ISurplusService surplusService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        ReturnGoodsVO returnGoodsVO = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        if (returnGoodsVO != null && returnGoodsVO.getReturnGoodsDetailList().size() > 0) {
            StoreManageVO storeManageVO = returnGoodsVO.getStoreManageVO(returnGoodsVO);
            ArrayList<SurplusVO> queryVos = new ArrayList<SurplusVO>();
            HashMap flowMap = new HashMap();
            storeManageVO.getFlowVOList().stream().forEach(flow -> {
                SurplusVO s = new SurplusVO();
                s.setStoreId(entity.getStoreId());
                s.setBrandId(flow.getBrandId());
                s.setMaterialId(flow.getMaterialId());
                flowMap.put(flow.getMaterialId() + "-" + flow.getBrandId(), flow);
            });
            List<SurplusVO> queryRs = this.surplusService.querySurplusBatch(queryVos);
            FlowVO tmp = null;
            for (SurplusVO s : queryRs) {
                tmp = (FlowVO)flowMap.get(s.getMaterialId() + "-" + s.getBrandId());
                if (null == tmp) continue;
                tmp.setPrice(s.getSurplusPrice());
                tmp.setTaxPrice(s.getSurplusTaxPrice());
                tmp.setMny(ComputeUtil.safeMultiply((BigDecimal)tmp.getNum(), (BigDecimal)tmp.getPrice()));
                tmp.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)tmp.getNum(), (BigDecimal)tmp.getTaxPrice()));
                tmp.setTax(ComputeUtil.safeSub((BigDecimal)tmp.getTaxMny(), (BigDecimal)tmp.getMny()));
                tmp.setTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTax(), (BigDecimal)tmp.getTaxPrice()), (BigDecimal)new BigDecimal("100")));
            }
            this.storeManageService.inOutStore(storeManageVO);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getOutDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5355\u636e\u5f02\u5e38\uff0c\u5f03\u5ba1\u5931\u8d25");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null && entity.getReturnGoodsDetailList().size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
            ArrayList<Long> longs = new ArrayList<Long>();
            longs.add(entity.getId());
            storeManageVO.setSourceIdsForRollBack(longs);
            this.storeManageService.inOutStoreRollback(storeManageVO);
        }
        return CommonResponse.success();
    }

    public static String toMD5(String plainText) {
        StringBuffer buf = new StringBuffer("");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                    continue;
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

