/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.zdsstore.bean.AllotInEntity;
import com.ejianc.business.zdsstore.bean.AllotOutDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.consts.AllocatEnum;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.mapper.AllotInMapper;
import com.ejianc.business.zdsstore.service.IAllotInService;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotInExportVO;
import com.ejianc.business.zdsstore.vo.AllotInVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotInService")
public class AllotInServiceImpl
extends BaseServiceImpl<AllotInMapper, AllotInEntity>
implements IAllotInService {
    @Autowired
    private IAllotInService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAllotOutService allotOutService;
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;

    @Override
    public CommonResponse<String> sureToReceive(AllotInVO vo) {
        AllotInEntity entity = (AllotInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        LambdaUpdateWrapper allotinWrapper = new LambdaUpdateWrapper();
        allotinWrapper.eq(BaseEntity::getId, (Object)vo.getId());
        allotinWrapper.set(AllotInEntity::getReceiveDate, (Object)vo.getReceiveDate());
        allotinWrapper.set(AllotInEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        allotinWrapper.set(AllotInEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.RECEIVED.getCode()));
        allotinWrapper.set(AllotInEntity::getPassDate, (Object)vo.getPassDate());
        allotinWrapper.set(AllotInEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
        allotinWrapper.set(AllotInEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
        boolean b = this.service.update((Wrapper)allotinWrapper);
        AllotInEntity allot = (AllotInEntity)((Object)this.service.selectById(vo.getId()));
        if (CollectionUtils.isNotEmpty(allot.getAllotInDetailList())) {
            AllotInVO allotInVO = (AllotInVO)BeanMapper.map((Object)((Object)allot), AllotInVO.class);
            List storeManageVOList = vo.getStoreManageVOList(allotInVO);
            for (StoreManageVO manageVO : storeManageVOList) {
                this.storeManageService.inOutStore(manageVO);
            }
        }
        if (b) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)entity.getAllotOutId());
            wrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.RECEIVED.getCode()));
            wrapper.set(AllotOutEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
            wrapper.set(AllotOutEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
            wrapper.set(AllotOutEntity::getReceiveDate, (Object)vo.getReceiveDate());
            this.allotOutService.update((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> sureToReceive(AllotInEntity allotInEntity) {
        allotInEntity.setReceiveDate(new Date());
        allotInEntity.setReceiveState(Integer.parseInt(AllocationState.RECEIVED.getCode()));
        allotInEntity.setPassDate(new Date());
        allotInEntity.setReceiverPersonId(allotInEntity.getEmployeeId().toString());
        allotInEntity.setReceiverPerson(allotInEntity.getEmployeeName());
        this.service.saveOrUpdate((Object)allotInEntity);
        if (CollectionUtils.isNotEmpty(allotInEntity.getAllotInDetailList())) {
            AllotInVO allotInVO = (AllotInVO)BeanMapper.map((Object)((Object)allotInEntity), AllotInVO.class);
            List storeManageVOList = new AllotInVO().getStoreManageVOList(allotInVO);
            for (StoreManageVO manageVO : storeManageVOList) {
                this.storeManageService.inOutStore(manageVO);
            }
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)allotInEntity.getAllotOutId());
        wrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.RECEIVED.getCode()));
        wrapper.set(AllotOutEntity::getReceiverPersonId, (Object)allotInEntity.getReceiverPersonId());
        wrapper.set(AllotOutEntity::getReceiverPerson, (Object)allotInEntity.getReceiverPerson());
        wrapper.set(AllotOutEntity::getReceiveDate, (Object)allotInEntity.getReceiveDate());
        this.allotOutService.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> sureToReturn(AllotInVO vo) {
        AllotInEntity entity = (AllotInEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        AllotOutEntity allotOut = (AllotOutEntity)((Object)this.allotOutService.selectById(entity.getAllotOutId()));
        CommonResponse commonResponse = this.billTypeApi.checkQuote("EJCBT202312000014", allotOut.getId());
        boolean success = commonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u8c03\u62e8\u51fa\u5e93\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        wrapper.set(AllotInEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        wrapper.set(AllotInEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.REJECT.getCode()));
        wrapper.set(AllotInEntity::getReceiveDate, (Object)vo.getReceiveDate());
        wrapper.set(AllotInEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
        wrapper.set(AllotInEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
        wrapper.set(AllotInEntity::getReturnReason, (Object)vo.getReturnReason());
        boolean update = this.service.update((Wrapper)wrapper);
        if (update) {
            AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.allotOutService.selectById(entity.getAllotOutId()));
            if (allotOutEntity != null) {
                List<AllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAllotOutDetailList();
                for (AllotOutDetailEntity allotOutDetailEntity : allotOutDetailList) {
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(allotOutDetailEntity.getDetailStoreId());
                    storeManageVO.setSourceId(allotOutDetailEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                    storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                    ArrayList<Long> longs = new ArrayList<Long>();
                    longs.add(allotOutDetailEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    this.storeManageService.inOutStoreRollback(storeManageVO);
                }
            }
            LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
            allotOutWrapper.eq(BaseEntity::getId, (Object)entity.getAllotOutId());
            allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.REJECT.getCode()));
            allotOutWrapper.set(AllotOutEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            allotOutWrapper.set(AllotOutEntity::getReturnReason, (Object)vo.getReturnReason());
            allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, (Object)vo.getReceiverPersonId());
            allotOutWrapper.set(AllotOutEntity::getReceiverPerson, (Object)vo.getReceiverPerson());
            allotOutWrapper.set(AllotOutEntity::getRelationFlag, (Object)0);
            this.allotOutService.update((Wrapper)allotOutWrapper);
        }
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        fuzzyFields.add("companyName");
        fuzzyFields.add("inCompanyName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotInVos = BeanMapper.mapList((Iterable)list, AllotInExportVO.class);
        allotInVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            }
            if (vo.getReceiveDate() != null) {
                vo.setAllocatReceiveDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getReceiveDate()));
            }
            if (vo.getPassDate() != null) {
                vo.setAllocatPassDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getPassDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotInVos);
        ExcelExport.getInstance().export("allocationInExport.xlsx", beans, response);
    }
}

