package com.ejianc.business.zdsstore.controller.api;

import com.ejianc.business.zdsstore.service.IAccountSettleService;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/accountSettle/")
@Api(value = "对账结算API接口", tags = {"对账结算API接口"})
public class AccountSettleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAccountSettleService accountSettleService;
    /**
     * @param storeApiVO 数据
     * @description: 对账结算
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author 姜轶凯
     * @date: 2022/3/9
     */
    @ApiOperation("对账或者结算操作")
    @RequestMapping(value = "/changeAccountSettleByType", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> changeAccountSettleByType(@RequestBody StoreApiVO storeApiVO){
        CommonResponse<String> commonResponse = accountSettleService.changeAccountSettleByType(storeApiVO);
        return commonResponse ;
    }

    /**
     * @param storeApiVO
     * @description: 结算单审批通过
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/3/10
     */
    @RequestMapping(value = "/settlePass", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreApiVO> settlePass(@RequestBody StoreApiVO storeApiVO){
        CommonResponse<StoreApiVO> commonResponse = accountSettleService.settlePass(storeApiVO);
        return commonResponse;
    }
    /**
     * @param storeApiVO
     * @description: 结算单弃审校验
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author 姜轶凯
     * @date: 2022/3/10
     */
    @RequestMapping(value = "/settleRollback", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<StoreApiVO> settleRollback(@RequestBody StoreApiVO storeApiVO){
        CommonResponse<StoreApiVO> commonResponse = accountSettleService.settleRollback(storeApiVO);
        return commonResponse;
    }

    /**
     * @param storeApiVO 数据
     * @description: 出库结算
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author 姜轶凯
     * @date: 2022/3/9
     */
    @ApiOperation("对账或者结算操作")
    @RequestMapping(value = "/changeSettleFlag", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> changeSettleFlag(@RequestBody StoreApiVO storeApiVO){
        CommonResponse<String> commonResponse = accountSettleService.changeSettleFlag(storeApiVO);
        return commonResponse ;
    }
}
