package com.ejianc.business.zdsstore.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IAccountSettleService;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreApiVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("accountSettleService")
public class AccountSettleImpl implements IAccountSettleService {

    @Autowired
    private ISurplusService surplusService;

    @Autowired
    private IFlowService flowService;

//    @Override
//    public CommonResponse<String> changeAccountSettleByType(StoreApiVO storeApiVO) {
//        Integer accountFlag = storeApiVO.getAccountFlag();
//        Integer settleFlag = storeApiVO.getSettleFlag();
//
//        List<FlowVO> detail = storeApiVO.getDetail();
//        if (CollectionUtils.isNotEmpty(detail)) {
//            for (FlowVO flowVO : detail) {
//                LambdaUpdateWrapper<FlowEntity> updateWrapper = new LambdaUpdateWrapper<>();
//                updateWrapper.eq(FlowEntity::getSourceDetailId, flowVO.getSourceDetailId());
//                updateWrapper.eq(FlowEntity::getInOutFlag, StoreCommonConsts.IN_OUT_TYPE_IN);
//                if (accountFlag != null) {
//                    if (StoreCommonConsts.NO.equals(accountFlag)) {
//                        updateWrapper.set(FlowEntity::getAccountFlag, StoreCommonConsts.NO);
//                        updateWrapper.set(FlowEntity::getAccountId, null);
//                        updateWrapper.set(FlowEntity::getAccountDetailId, null);
//                        updateWrapper.set(FlowEntity::getAccountDate, null);
//                        updateWrapper.set(FlowEntity::getAccountCode, null);
//                    } else if (StoreCommonConsts.YES.equals(accountFlag)) {
//                        updateWrapper.set(FlowEntity::getAccountFlag, StoreCommonConsts.YES);
//                        updateWrapper.set(FlowEntity::getAccountId, storeApiVO.getAccountId());
//                        updateWrapper.set(FlowEntity::getAccountDetailId, flowVO.getAccountDetailId());
//                        updateWrapper.set(FlowEntity::getAccountDate, storeApiVO.getAccountDate());
//                        updateWrapper.set(FlowEntity::getAccountCode, storeApiVO.getAccountCode());
//                    }
//                }
//                if (settleFlag != null) {
//                    if (StoreCommonConsts.NO.equals(settleFlag)) {
//                        updateWrapper.set(FlowEntity::getSettleFlag, StoreCommonConsts.NO);
//                        updateWrapper.set(FlowEntity::getSettleId, null);
//                        updateWrapper.set(FlowEntity::getSettleDetailId, null);
//                        updateWrapper.set(FlowEntity::getSettleDate, null);
//                        updateWrapper.set(FlowEntity::getSettleCode, null);
//                        if("NoContract".equals(flowVO.getCusDef1())) {
//                            updateWrapper.set(FlowEntity::getPurchaseContractId, null);
//                            updateWrapper.set(FlowEntity::getPurchaseContractName, null);
//                        }
//                    } else if (StoreCommonConsts.YES.equals(settleFlag)) {
//                        updateWrapper.set(FlowEntity::getSettleFlag, StoreCommonConsts.YES);
//                        updateWrapper.set(FlowEntity::getSettleId, storeApiVO.getSettleId());
//                        updateWrapper.set(FlowEntity::getSettleDetailId, flowVO.getSettleDetailId());
//                        updateWrapper.set(FlowEntity::getSettleDate, storeApiVO.getSettleDate());
//                        updateWrapper.set(FlowEntity::getSettleCode, storeApiVO.getSettleCode());
//                        if("NoContract".equals(flowVO.getCusDef1())) {
//                            updateWrapper.set(FlowEntity::getPurchaseContractId, storeApiVO.getPurchaseContractId());
//                            updateWrapper.set(FlowEntity::getPurchaseContractName, storeApiVO.getPurchaseContractName());
//                        }
//                    }
//                }
//                flowService.update(updateWrapper);
//            }
//        }
//        return CommonResponse.success("结算对账成功");
//    }

    @Override
    public CommonResponse<String> changeAccountSettleByType(StoreApiVO storeApiVO) {
        Integer accountFlag = storeApiVO.getAccountFlag();
        Integer settleFlag = storeApiVO.getSettleFlag();

        List<FlowVO> detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> sourceDetailIds = detail.stream().map(FlowVO::getSourceDetailId).collect(Collectors.toList());
            Map<Long,FlowVO> map = new HashMap<>();
            detail.forEach(t -> map.put(t.getSourceDetailId(), t));
            QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("source_detail_Id", sourceDetailIds);
            queryWrapper.eq("in_out_flag",StoreCommonConsts.IN_OUT_TYPE_IN);
            List<FlowEntity> instoreList = flowService.list(queryWrapper);
            List<FlowEntity> updateList = new ArrayList<>();

            for (FlowEntity flowEntity : instoreList) {
                FlowVO flowVO = map.get(flowEntity.getSourceDetailId());
                if(null!=flowVO){
                    if (accountFlag != null) {
                        if (StoreCommonConsts.NO.equals(accountFlag)) {
                            flowEntity.setAccountFlag(StoreCommonConsts.NO);
                            flowEntity.setAccountId(null);
                            flowEntity.setAccountDetailId(null);
                            flowEntity.setAccountDate(null);
                            flowEntity.setAccountCode(null);
                        } else if (StoreCommonConsts.YES.equals(accountFlag)) {
                            flowEntity.setAccountFlag(StoreCommonConsts.YES);
                            flowEntity.setAccountId(storeApiVO.getAccountId());
                            flowEntity.setAccountDetailId(flowVO.getAccountDetailId());
                            flowEntity.setAccountDate(storeApiVO.getAccountDate());
                            flowEntity.setAccountCode(storeApiVO.getAccountCode());
                        }
                    }
                    if (settleFlag != null) {
                        if (StoreCommonConsts.NO.equals(settleFlag)) {
                            flowEntity.setSettleFlag(StoreCommonConsts.NO);
                            flowEntity.setSettleId(null);
                            flowEntity.setSettleDetailId(null);
                            flowEntity.setSettleDate(null);
                            flowEntity.setSettleCode(null);
                            if("NoContract".equals(flowVO.getCusDef1())) {
                                flowEntity.setPurchaseContractId(null);
                                flowEntity.setPurchaseContractName(null);
                            }
                        } else if (StoreCommonConsts.YES.equals(settleFlag)) {
                            flowEntity.setSettleFlag(StoreCommonConsts.YES);
                            flowEntity.setSettleId(storeApiVO.getSettleId());
                            flowEntity.setSettleDetailId(flowVO.getSettleDetailId());
                            flowEntity.setSettleDate(storeApiVO.getSettleDate());
                            flowEntity.setSettleCode(storeApiVO.getSettleCode());
                            if("NoContract".equals(flowVO.getCusDef1())) {
                                flowEntity.setPurchaseContractId(storeApiVO.getPurchaseContractId());
                                flowEntity.setPurchaseContractName(storeApiVO.getPurchaseContractName());
                            }
                        }
                    }
                    updateList.add(flowEntity);
                }
            }
            flowService.updateBatchById(updateList);
        }
        return CommonResponse.success("结算对账成功");
    }

    /**
     * @param storeApiVO
     * @description: 结算单审批通过
     * 4、结算审批通过回写单价。只传变化的单价
     * 校验：是否有锁定出库数量
     * 业务操作: 更新对应入库入库单价=结算单价，盈余金额， 库存表盈余金额
     * 生成调差单： 按入库的出库数量生成调差单
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/3/10
     */
    @Override
    public CommonResponse<StoreApiVO> settlePass(StoreApiVO storeApiVO) {
        List<FlowVO> detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            //仓库\物资维度剩余金额更新map
            Map<String, SurplusVO> surplusUpdateMap = new HashMap<>();

            List<Long> storeIds = new ArrayList<>();
            List<Long> materialIds = new ArrayList<>();

            Map<Long, FlowVO> settleflowMap = new HashMap<>();
            detail.forEach(t -> settleflowMap.put(t.getSourceDetailId(), t));

            QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("source_detail_Id", new ArrayList<>(settleflowMap.keySet()));
            queryWrapper.eq("in_out_flag",StoreCommonConsts.IN_OUT_TYPE_IN);
            List<FlowEntity> instoreList = flowService.list(queryWrapper);

            Map<Long, FlowEntity> flowMap = new HashMap<>();
            for (FlowEntity t : instoreList) {
                if (ComputeUtil.isNotEmpty(t.getOutLockNum())) {
                    return CommonResponse.error("物资[名称:" + t.getMaterialName() + ",规格:" + StrUtil.emptyToDefault(t.getMaterialSpec(), "无") + "]已被自由态出库单占用中,不允许结算!", storeApiVO);
                }
                Long storeId = t.getStoreId();
                Long materialId = t.getMaterialId();
                Long sourceDetailId = t.getSourceDetailId();
                BigDecimal surplusMnyOld = t.getSurplusMny();
                BigDecimal surplusTaxMnyOld = t.getSurplusTaxMny();
                FlowVO settleFlow = settleflowMap.get(sourceDetailId);

                // 结算单价和入库单价一致时不需要处理
                if (settleFlow == null || ComputeUtil.equals(t.getTaxPrice(), settleFlow.getSettleTaxPrice())) {
                    continue;
                }

                //放入回参 出库数量和入库单价
                settleFlow.setOutNum(t.getOutNum());
                settleFlow.setPrice(t.getPrice());
                settleFlow.setTaxPrice(t.getTaxPrice());

                storeIds.add(storeId);
                materialIds.add(materialId);
                String storeKey = String.valueOf(storeId) + materialId;
                SurplusVO surplusUpdateVO = surplusUpdateMap.get(storeKey);
                if (surplusUpdateVO == null) {
                    surplusUpdateVO = new SurplusVO();
                    surplusUpdateVO.setStoreId(storeId);
                    surplusUpdateVO.setMaterialId(materialId);
                }

                //更新入库单价为结算单价
                t.setPrice(settleFlow.getSettlePrice());
                t.setTaxPrice(settleFlow.getSettleTaxPrice());
                BigDecimal surplusMnyNew = ComputeUtil.safeMultiply(t.getSurplusNum(), t.getPrice());
                BigDecimal surplusTaxMnyNew = ComputeUtil.safeMultiply(t.getSurplusNum(), t.getTaxPrice());
                // 重新计算盈余金额
                t.setSurplusMny(surplusMnyNew);
                t.setSurplusTaxMny(surplusTaxMnyNew);

                //计算库存更新差额
                BigDecimal surplusMnyDiff = ComputeUtil.safeSub(surplusMnyNew, surplusMnyOld);
                BigDecimal surplusTaxMnyDiff = ComputeUtil.safeSub(surplusTaxMnyNew, surplusTaxMnyOld);
                surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusMny(), surplusMnyDiff));
                surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusTaxMny(), surplusTaxMnyDiff));
                surplusUpdateMap.put(storeKey, surplusUpdateVO);

                //计算成本金额、调差金额
               /* 调整金额=结算金额—入库金额；

                调整金额（无税）=结算金额（无税）—入库金额（无税）；

                调整税额=结算税额—入库税额；

                成本金额=（结算单价—入库单价）*已出库数量；

                成本金额（无税）=（结算单价（无税）—入库单价（无税））*已出库数量；*/

                settleFlow.setDiffMny(ComputeUtil.safeSub(settleFlow.getSettleMny(), t.getMny()));
                settleFlow.setDiffTaxMny(ComputeUtil.safeSub(settleFlow.getSettleTaxMny(), t.getTaxMny()));
                settleFlow.setDiffTax(ComputeUtil.safeSub(settleFlow.getDiffTaxMny(), settleFlow.getDiffMny()));

                BigDecimal diffPrice = ComputeUtil.safeSub(settleFlow.getSettlePrice(), settleFlow.getPrice());
                BigDecimal diffTaxPrice = ComputeUtil.safeSub(settleFlow.getSettleTaxPrice(), settleFlow.getTaxPrice());

                settleFlow.setCostMny(ComputeUtil.safeMultiply(settleFlow.getOutNum(), diffPrice));
                settleFlow.setCostTaxMny(ComputeUtil.safeMultiply(settleFlow.getOutNum(), diffTaxPrice));
                settleFlow.setCostTax(ComputeUtil.safeSub(settleFlow.getCostTaxMny(), settleFlow.getCostMny()));

                flowMap.put(sourceDetailId, t);
            }

            if (CollectionUtils.isNotEmpty(storeIds) && CollectionUtils.isNotEmpty(materialIds)) {
                QueryWrapper<SurplusEntity> surplusEntityQueryWrapper = new QueryWrapper<>();
                surplusEntityQueryWrapper.in("store_id", storeIds);
                surplusEntityQueryWrapper.in("material_id", materialIds);
                List<SurplusEntity> list = surplusService.list(surplusEntityQueryWrapper);

                list.forEach(t -> {
                    String storeKey = String.valueOf(t.getStoreId()) + t.getMaterialId();
                    SurplusVO surplusVO = surplusUpdateMap.get(storeKey);
                    if(null!=surplusVO){
                        t.setSurplusMny(ComputeUtil.safeAdd(t.getSurplusMny(), surplusVO.getSurplusMny()));
                        t.setSurplusTaxMny(ComputeUtil.safeAdd(t.getSurplusTaxMny(), surplusVO.getSurplusTaxMny()));
                    }
                });
                surplusService.saveOrUpdateBatch(list);
                flowService.saveOrUpdateBatch(new ArrayList<>(flowMap.values()));
                storeApiVO.setDetail(new ArrayList<>(settleflowMap.values()));
            }

        }
        return CommonResponse.success(storeApiVO);
    }

    @Override
    public CommonResponse<StoreApiVO> settleRollback(StoreApiVO storeApiVO) {
        List<FlowVO> detail = storeApiVO.getDetail();
        Long settleId = storeApiVO.getSettleId();
            //结算单价
            Map<String, SurplusVO> surplusUpdateMap = new HashMap<>();
            List<Long> storeIds = new ArrayList<>();
            List<Long> materialIds = new ArrayList<>();
            if (settleId!=null) {
                QueryWrapper<FlowEntity> objectQueryWrapper = new QueryWrapper<>();
                objectQueryWrapper.eq("settle_id", settleId);
                List<FlowEntity> flowEntityList = flowService.list(objectQueryWrapper);
                if (CollectionUtils.isNotEmpty(flowEntityList)) {
                    List<Long> ids = flowEntityList.stream().map(FlowEntity::getId).collect(Collectors.toList());
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("ids", ids);
                    Integer count = flowService.settleCount(map);
                    if (count.equals(StoreCommonConsts.ZERO)) {
                        List<FlowVO> list = BeanMapper.mapList(flowEntityList, FlowVO.class);
                        for (FlowVO flowVO : list) {
                            BigDecimal surplusMnyNew = ComputeUtil.safeMultiply(flowVO.getSurplusNum(), flowVO.getEstimatePrice());
                            BigDecimal surplusTaxMnyNew = ComputeUtil.safeMultiply(flowVO.getSurplusNum(), flowVO.getEstimatePrice());
                            // 重新计算盈余金额
                            flowVO.setSurplusMny(surplusMnyNew);
                            flowVO.setSurplusTaxMny(surplusTaxMnyNew);

                            Long storeId = flowVO.getStoreId();
                            Long materialId = flowVO.getMaterialId();
                            storeIds.add(flowVO.getStoreId());
                            materialIds.add(flowVO.getMaterialId());

                            String storeKey = String.valueOf(storeId) + materialId;
                            SurplusVO surplusUpdateVO = surplusUpdateMap.get(storeKey);
                            if (surplusUpdateVO == null) {
                                surplusUpdateVO = new SurplusVO();
                                surplusUpdateVO.setStoreId(storeId);
                                surplusUpdateVO.setMaterialId(materialId);
                            }
                            //弃审之前的金额
                            BigDecimal surplusMnyOld = ComputeUtil.safeMultiply(flowVO.getSurplusNum(), flowVO.getPrice());
                            BigDecimal surplusTaxMnyOld = ComputeUtil.safeMultiply(flowVO.getSurplusNum(), flowVO.getTaxPrice());
                            //计算差价
                            BigDecimal surplusMnyDiff = ComputeUtil.safeSub(surplusMnyNew, surplusMnyOld);
                            BigDecimal surplusTaxMnyDiff = ComputeUtil.safeSub(surplusTaxMnyNew, surplusTaxMnyOld);
                            flowVO.setTaxPrice(flowVO.getEstimateTaxPrice());
                            flowVO.setPrice(flowVO.getEstimatePrice());
                            surplusUpdateVO.setSurplusMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusMny(), surplusMnyDiff));
                            surplusUpdateVO.setSurplusTaxMny(ComputeUtil.safeAdd(surplusUpdateVO.getSurplusTaxMny(), surplusTaxMnyDiff));
                            surplusUpdateMap.put(storeKey, surplusUpdateVO);
                        }

                        if (CollectionUtils.isNotEmpty(storeIds) && CollectionUtils.isNotEmpty(materialIds)) {
                            QueryWrapper<SurplusEntity> surplusEntityQueryWrapper = new QueryWrapper<>();
                            surplusEntityQueryWrapper.in("store_id", storeIds);
                            surplusEntityQueryWrapper.in("material_id", materialIds);
                            List<SurplusEntity> surplusEntityList = surplusService.list(surplusEntityQueryWrapper);

                            surplusEntityList.forEach(t -> {
                                String storeKey = String.valueOf(t.getStoreId()) + t.getMaterialId();
                                SurplusVO surplusVO = surplusUpdateMap.get(storeKey);
                                if(null!=surplusVO){ //edit by sunyj  因为前两行查询surplusEntityList 取的范围要比 surplusUpdateMap存的大，可能会出现surplusVO为null的情况
                                    t.setSurplusMny(ComputeUtil.safeAdd(t.getSurplusMny(), surplusVO.getSurplusMny()));
                                    t.setSurplusTaxMny(ComputeUtil.safeAdd(t.getSurplusTaxMny(), surplusVO.getSurplusTaxMny()));
                                }
                            });
                            List<FlowEntity> updateFlowList = BeanMapper.mapList(list, FlowEntity.class);
                            flowService.saveOrUpdateBatch(updateFlowList);
                            surplusService.saveOrUpdateBatch(surplusEntityList);
                            storeApiVO.setDetail(list);
                        }

                    } else {
                        return CommonResponse.error("已存在出库单使用此结算单价出库，不能弃审！");
                    }
                }

            }else {
                return CommonResponse.error("结算单id为空");
            }
        return CommonResponse.success(storeApiVO);
    }

    @Override
    public CommonResponse<String> changeSettleFlag(StoreApiVO storeApiVO) {
        Integer settleFlag = storeApiVO.getSettleFlag();

        List<FlowVO> detail = storeApiVO.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (FlowVO flowVO : detail) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("sourceDetailId",flowVO.getSourceDetailId());
                if (settleFlag != null) {
                    if (StoreCommonConsts.NO.equals(settleFlag)) {
                        map.put("settleFlag",StoreCommonConsts.NO);
                        map.put("settleId",null);
                        map.put("settleDetailId",null);
                        map.put("settleDate",null);
                        map.put("settleCode",null);
                    } else if (StoreCommonConsts.YES.equals(settleFlag)) {
                        map.put("settleFlag",StoreCommonConsts.YES);
                        map.put("settleId",storeApiVO.getSettleId());
                        map.put("settleDetailId",flowVO.getSettleDetailId());
                        map.put("settleDate",storeApiVO.getSettleDate());
                        map.put("settleCode",storeApiVO.getSettleCode());
                    }
                }

                flowService.changeSettleFlag(map);
            }
        }
        return CommonResponse.success("结算成功");
    }

    public static void main(String[] args) {
        System.out.println("1".equals(null));
    }
}
