package com.ejianc.business.zdsstore.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zdsstore.bean.StoreEntity;
import com.ejianc.business.zdsstore.bean.SurplusEntity;
import com.ejianc.business.zdsstore.consts.StoreAttrEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.mapper.StoreMapper;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 仓库表
 *
 * @author generator
 *
 */
@Service("storeService")
public class StoreServiceImpl extends BaseServiceImpl<StoreMapper, StoreEntity> implements IStoreService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private StoreMapper storeMapper;

    @Autowired
    private ISurplusService surplusService;

    @Override
    public List<StoreEntity> queryStoreList(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.eq("s.dr", StoreCommonConsts.NO);
        wrapper.groupBy("s.id");
        return storeMapper.queryStoreList(wrapper);
    }

    /***
     *  设置仓库属性
     * @param storeManageVO
     * @return
     */
    @Override
    public StoreManageVO  setStoreAttr(StoreManageVO storeManageVO) {
        String storeType;
        String storeTypeName;
        Long storeId = storeManageVO.getStoreId();

        StoreEntity storeEntity = storeMapper.selectById(storeId);
        storeType = storeEntity.getAttrFlag().toString();
        storeTypeName = StoreAttrEnum.getDescriptionByCode(storeEntity.getAttrFlag().toString());

        List<FlowVO> flowVOList = storeManageVO.getFlowVOList();
        if (CollectionUtils.isNotEmpty(flowVOList)){
            for (FlowVO flowVO : flowVOList) {
                flowVO.setStoreType(storeType);
                flowVO.setStoreTypeName(storeTypeName);
            }
        }
        storeManageVO.setFlowVOList(flowVOList);

        //直入直出时，出库流水也需要初始化仓库材料属性
        List<FlowVO> straightOutFlowVOList = storeManageVO.getStraightOutFlowVOList();
        if (CollectionUtils.isNotEmpty(straightOutFlowVOList)){
            for (FlowVO straightOut : straightOutFlowVOList) {
                straightOut.setStoreType(storeType);
                straightOut.setStoreTypeName(storeTypeName);
            }
        }
        return storeManageVO;
    }

    /**
     * 校验仓库能否删除
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> checkStoreMaterialList(Long id) {
        QueryWrapper<SurplusEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("store_id",id);
        queryWrapper.gt("surplus_num",0);
        List<SurplusEntity> list = surplusService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list) && list.size()>0){
            return CommonResponse.error("当前仓库有物资");
        }
        return CommonResponse.success();
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    private final String OPERATE = "storeBill";
    @Autowired
    private JedisPool jedisPool;
    /**
     *
     */
    @Override
    public StoreEntity autoByProjectId(Long projectId ,Integer attrFlag){
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        StoreEntity storeEntity = null;
        String key = OPERATE + "::" + projectId.toString();
        try {
            jedis = jedisPool.getResource();
            autoBuid(projectId, null);
            QueryWrapper<StoreEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id",projectId);
            queryWrapper.eq("attr_flag",attrFlag);
            queryWrapper.eq("dr",StoreCommonConsts.NO);
            List<StoreEntity> storeEntities = this.list(queryWrapper);
            if (!storeEntities.isEmpty()){
                storeEntity = storeEntities.get(0);
            }
        }catch (Exception e) {
            logger.error("项目id-{}查询对应项目仓库失败，", projectId, e);
            throw new BusinessException("查询对应项目仓库失败");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return storeEntity;


    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
    @Override
    public void autoBuid(Long projectId, Long parentOrgId) {
        if (null != projectId) {
            CommonResponse<ProjectVO> projectResponse = projectPoolApi.queryDetailById(projectId);
            if (!projectResponse.isSuccess()){
                logger.error("获取项目信息失败, {}", projectResponse.getMsg());
                throw new BusinessException("获取项目信息失败 请联系管理员");
            }
            ProjectVO project = projectResponse.getData();
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(project.getOrgId());
            if (!orgResponse.isSuccess()){
                logger.error("获取组织信息, {}", orgResponse.getMsg());
                throw new BusinessException("获取组织信息失败 请联系管理员");
            }
            OrgVO orgVO = orgResponse.getData();

            LambdaQueryWrapper<StoreEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(StoreEntity::getProjectId, projectId);
            List<StoreEntity> entities = list(wrapper);
            if (CollectionUtils.isEmpty(entities)) {
                List<StoreEntity> insertList = new ArrayList<>();
                insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.主材库.getCode()), project.getProjectName() + StoreAttrEnum.主材库.getDescription(), project, orgVO));
                insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.临建材料.getCode()), project.getProjectName() + StoreAttrEnum.临建材料.getDescription(), project, orgVO));
                insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.甲供材.getCode()), project.getProjectName() + StoreAttrEnum.甲供材.getDescription(), project, orgVO));

                this.saveOrUpdateBatch(insertList);
            }else {
                List<StoreEntity> insertList = new ArrayList<>();
                Set<Integer> set = entities.stream().map(StoreEntity::getAttrFlag).collect(Collectors.toSet());
                if (!set.contains(Integer.valueOf(StoreAttrEnum.主材库.getCode()))) {
                    insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.主材库.getCode()), project.getProjectName() + StoreAttrEnum.主材库.getDescription(), project, orgVO));
                }
                if (!set.contains(Integer.valueOf(StoreAttrEnum.临建材料.getCode()))) {
                    insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.临建材料.getCode()), project.getProjectName() + StoreAttrEnum.临建材料.getDescription(), project, orgVO));
                }
                if (!set.contains(Integer.valueOf(StoreAttrEnum.甲供材.getCode()))) {
                    insertList.add(buidStore(Integer.valueOf(StoreAttrEnum.甲供材.getCode()), project.getProjectName() + StoreAttrEnum.甲供材.getDescription(), project, orgVO));
                }
                if (CollectionUtils.isNotEmpty(insertList)) {
                    this.saveOrUpdateBatch(insertList);
                }
            }
        }

        if (null != parentOrgId) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(parentOrgId);
            if (!orgResponse.isSuccess()){
                logger.error("获取组织信息, {}", orgResponse.getMsg());
                throw new BusinessException("获取组织信息失败 请联系管理员");
            }
            OrgVO orgVO = orgResponse.getData();
            LambdaQueryWrapper<StoreEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(StoreEntity::getParentOrgId, parentOrgId);
            wrapper.eq(StoreEntity::getAttrFlag, StoreAttrEnum.实际仓.getCode());
            if (count(wrapper) <= 0) {
                this.saveOrUpdate(buidStore(Integer.valueOf(StoreAttrEnum.实际仓.getCode()), orgVO.getName() + StoreAttrEnum.实际仓.getDescription(), null, orgVO));
            }
        }
    }

    @Override
    public List<StoreVO> queryCloudStoreByOrg(Long orgId) {
        StoreEntity storeEntity = null;
        CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(orgId);
        String[] orgArr = orgResponse.getData().getInnerCode().split("\\|");
        for (int i = orgArr.length; i > 0; i--) {
            LambdaQueryWrapper<StoreEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(StoreEntity::getAttrFlag, StoreAttrEnum.云仓库.getCode());
            queryWrapper.eq(StoreEntity::getState, 1);
            queryWrapper.eq(StoreEntity::getParentOrgId, orgArr[i-1]);
            storeEntity = getOne(queryWrapper, false);
            if (null != storeEntity) {
                break;
            }
        }
        if (null == storeEntity) {
            throw new BusinessException("该组织及其上级未建立云仓库！");
        }
        LambdaQueryWrapper<StoreEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(StoreEntity::getAttrFlag, StoreAttrEnum.云仓库.getCode());
        queryWrapper.eq(StoreEntity::getState, 1);
        queryWrapper.likeRight(StoreEntity::getParentOrgInnerCode, storeEntity.getParentOrgInnerCode());
        List<StoreEntity> result = list(queryWrapper);
        return CollectionUtils.isNotEmpty(result) ? BeanMapper.mapList(result, StoreVO.class) : null;
    }

    private StoreEntity buidStore(Integer attrFlag, String name, ProjectVO project, OrgVO orgVO) {
        StoreEntity storeEntity = new StoreEntity();
        storeEntity.setId(IdWorker.getId());
        if(null != orgVO){
            storeEntity.setParentOrgId(orgVO.getId());
            storeEntity.setParentOrgName(orgVO.getName());
            storeEntity.setParentOrgCode(orgVO.getCode());
            storeEntity.setProjectType(StoreCommonConsts.NO);
        }
        if (null != project) {
            storeEntity.setProjectId(project.getId());
            storeEntity.setProjectName(project.getProjectName());
            storeEntity.setProjectCode(project.getBillCode());
            storeEntity.setOrgId(project.getProjectDepartmentId());
            storeEntity.setOrgName(project.getProjectName());
            storeEntity.setOrgCode(project.getBillCode());
            storeEntity.setProjectType(StoreCommonConsts.YES);
        }
        storeEntity.setState(StoreCommonConsts.YES);
        storeEntity.setAttrFlag(attrFlag);
        storeEntity.setName(name);
        storeEntity.setTotalMny(BigDecimal.ZERO);
        storeEntity.setMemo("自增");
        storeEntity.setDefaultFlag(0);

        return  storeEntity;
    }
}
