/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.bean.ReturnGoodsEntity;
import com.ejianc.business.zdsstore.service.IReturnGoodsService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.ReturnGoodsDetailVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsExportVO;
import com.ejianc.business.zdsstore.vo.ReturnGoodsVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"returnGoods"})
public class ReturnGoodsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_RG_01";
    @Autowired
    private IReturnGoodsService service;
    @Autowired
    private ISurplusService surplusService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> saveOrUpdate(@RequestBody ReturnGoodsVO saveOrUpdateVO) {
        ReturnGoodsVO voByContract;
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(null == (voByContract = this.service.queryByContractId(saveOrUpdateVO.getContractId())) || null != saveOrUpdateVO.getId() && voByContract.getId().equals(saveOrUpdateVO.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5408\u540c\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        ReturnGoodsVO vo = this.service.saveOrUpdateReturnGoods(saveOrUpdateVO);
        return this.queryDetail(vo.getId());
    }

    @PostMapping(value={"/syncSignStatus"})
    public CommonResponse<String> syncSignStatus(HttpServletRequest request) {
        String billData = request.getParameter("billData");
        this.logger.info("\u63a5\u6536\u5230\u4f9b\u65b9\u6750\u6599\u9000\u8d27\u4fe1\u606f\uff1a{}", (Object)billData);
        ReturnGoodsVO returnGoodsVO = (ReturnGoodsVO)JSONObject.parseObject((String)billData, ReturnGoodsVO.class);
        this.service.syncSignStatus(returnGoodsVO);
        return CommonResponse.success((String)"\u8ba2\u5355\u4fe1\u606f\u540c\u6b65\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReturnGoodsVO> queryDetail(Long id) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.service.selectById(id));
        ReturnGoodsVO vo = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getReturnGoodsDetailList())) {
            ArrayList<SurplusVO> query = new ArrayList<SurplusVO>();
            vo.getReturnGoodsDetailList().stream().forEach(item -> {
                SurplusVO f = new SurplusVO();
                f.setStoreId(vo.getStoreId());
                f.setMaterialId(item.getMaterialId());
                f.setBrandId(item.getBrandId());
                query.add(f);
            });
            List<SurplusVO> rs = this.surplusService.querySurplusBatch(query);
            Map<String, SurplusVO> rsMap = rs.stream().collect(Collectors.toMap(item -> item.getStoreId().toString() + item.getMaterialId().toString() + item.getBrandId().toString(), item -> item));
            SurplusVO tmp = null;
            for (ReturnGoodsDetailVO item2 : vo.getReturnGoodsDetailList()) {
                tmp = rsMap.get(vo.getStoreId().toString() + item2.getMaterialId().toString() + item2.getBrandId().toString());
                if (null == tmp) continue;
                item2.setInstorePrice(tmp.getSurplusPrice());
                item2.setInstoreTaxPrice(tmp.getSurplusTaxPrice());
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReturnGoodsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReturnGoodsVO returnGoodsVO : vos) {
            }
        }
        this.service.removeByPickReturnIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("storeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReturnGoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            ReturnGoodsExportVO exportVO = (ReturnGoodsExportVO)BeanMapper.map((Object)vo, ReturnGoodsExportVO.class);
            exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVO.setOutDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("returnGoodsListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refReturnGoodsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReturnGoodsVO>> refReturnGoodsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReturnGoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/returnGoodsCheck"})
    @ResponseBody
    public CommonResponse<String> returnGoodsCheck(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ReturnGoodsEntity one = (ReturnGoodsEntity)((Object)this.service.getOne((Wrapper)query));
        if (!(one == null || null != billId && one.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u5408\u540c\u9002\u7528\u5f53\u524d\u5355\u636e\uff01");
    }
}

