package com.ejianc.business.zdsstore.bean;

import java.util.Date;
import java.math.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 仓库盘点表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_check")
public class CheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value = "store_attr_flag")
    private Integer storeAttrFlag; // 仓库属性  1-主材库；2-临建材料，3-甲供材，4-实际仓，5-云仓库
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="check_date")
    private Date checkDate; // 盘点日期
    @TableField(value="relation_in_store_id")
    private Long relationInStoreId; // 盘点单对应入库单据Id
    @TableField(value="relation_out_store_id")
    private Long relationOutStoreId; // 盘点单对应出库单据Id
    @TableField(value="check_info")
    private String checkInfo; // 盘点说明
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(exist = false)
    @SubEntity(serviceName = "checkDetailService", pidName = "checkId")
    private List<CheckDetailEntity> checkSubList;
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额(无税)

    @TableField(value="total_inventory")
    private BigDecimal totalInventory; // 盘点盈亏

    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态

    @TableField(value="org_code")
    private String orgCode; // 项目组织编码

    public BigDecimal getTotalInventory() {
        return totalInventory;
    }

    public void setTotalInventory(BigDecimal totalInventory) {
        this.totalInventory = totalInventory;
    }

    public Integer getStoreAttrFlag() {
        return storeAttrFlag;
    }

    public void setStoreAttrFlag(Integer storeAttrFlag) {
        this.storeAttrFlag = storeAttrFlag;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public List<CheckDetailEntity> getCheckSubList() {
        return checkSubList;
    }

    public void setCheckSubList(List<CheckDetailEntity> checkSubList) {
        this.checkSubList = checkSubList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Long getRelationInStoreId() {
        return relationInStoreId;
    }

    public void setRelationInStoreId(Long relationInStoreId) {
        this.relationInStoreId = relationInStoreId;
    }
    public Long getRelationOutStoreId() {
        return relationOutStoreId;
    }

    public void setRelationOutStoreId(Long relationOutStoreId) {
        this.relationOutStoreId = relationOutStoreId;
    }
    public String getCheckInfo() {
        return checkInfo;
    }

    public void setCheckInfo(String checkInfo) {
        this.checkInfo = checkInfo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    
}
