package com.ejianc.business.zdsstore.service.handler;

import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * @author songlx
 * @description: 仓库管理服务接口
 * @date: 2022/1/25
 */
public interface IStoreManageHandler {

    /**
     * @description: 针对不同出入类型正向实现
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/1/25
     */
    CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO);


    /**
     * @description: 针对不同出入类型逆向实现
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.store.vo.StoreManageVO>
     * @author songlx
     * @date: 2022/1/25
     */
    CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO);
}
