/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MsgSendUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISmsMessageApi smsMessageApi;
    @Autowired
    private EnvironmentTools environmentTools;

    public String sendMsg(String[] channel, String[] receivers, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        ArrayList<String> user = new ArrayList<String>(Arrays.asList(receivers));
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        receivers = user.toArray(new String[user.size()]);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setContent(content);
        parameter.setSubject(subject);
        parameter.setMsgType(msgType);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        parameter.setChannel(channel);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params, String pcUrl) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        if (receivers != null) {
            ArrayList<String> user = new ArrayList<String>(Arrays.asList(receivers));
            Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
            receivers = user.toArray(new String[user.size()]);
        }
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setZdsExtEmailParams(params);
        parameter.setContent(content);
        parameter.setSubject(subject);
        parameter.setMsgType(msgType);
        parameter.setPcUrl(this.baseHost + pcUrl);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        parameter.setChannel(new String[]{"email"});
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendSms(String phone, String templateCode, String signName, Map<String, String> params) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        SmsMsgSendParam parameter = new SmsMsgSendParam();
        parameter.setPhone(phone);
        parameter.setTemplateCode(templateCode);
        parameter.setSignName(signName);
        parameter.setParams(params);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.smsMessageApi.sendMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendSmsNoAuth(String phone, String templateCode, String signName, Map<String, String> params) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        SmsMsgSendParam messageParam = new SmsMsgSendParam();
        messageParam.setPhone(phone);
        messageParam.setTemplateCode(templateCode);
        messageParam.setSignName(signName);
        messageParam.setParams(params);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)messageParam));
        String messageUrl = this.environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
            CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (response.isSuccess()) {
                this.logger.info("\u9080\u8bf7\u7801\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u6210\u529f\uff01{}", (Object)phone);
            } else {
                this.logger.info("\u9080\u8bf7\u7801\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u6210\u529f \u53d1\u9001\u5931\u8d25\uff01{}----{}", (Object)phone, (Object)responseStr);
            }
            this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->{}" + responseStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u77ed\u4fe1\u53d1\u9001\u6210\u529f \u53d1\u9001\u5931\u8d25\uff01{}----{}", (Object)phone, (Object)e.getMessage());
        }
        return "\u53d1\u9001\u6210\u529f\uff01";
    }
}

