/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreMnyGroupByDateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statisics"})
@Api(value="\u4ed3\u5e93\u6d41\u6c34\u8868", tags={"\u4ed3\u5e93\u6d41\u6c34\u8868"})
public class StatisicsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFlowService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Object inOutFlag = ((Parameter)param.getParams().get("inOutFlag")).getValue();
        if (inOutFlag != null) {
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.ONE) {
                fuzzyFields.add("purchaseContractName");
                fuzzyFields.add("supplierName");
            }
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.TWO) {
                fuzzyFields.add("pickContractName");
                fuzzyFields.add("pickUnitName");
            }
        }
        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        fuzzyFields.add("brandName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (null == param.getParams().get("turnFlag")) {
            param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        }
        if (null != param.getParams().get("contractFlagStr")) {
            param.getParams().put("purchaseContractId", new Parameter("sql", (Object)("IFNULL(purchase_contract_id, -1) " + ("\u6709".equals(((Parameter)param.getParams().get("contractFlagStr")).getValue()) ? "> 0" : " = -1"))));
            param.getParams().remove("contractFlagStr");
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().remove("parentOrgId");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Page page = new Page();
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = ((Parameter)param.getParams().get("contractFlag")).getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter("ne", null));
            }
            param.getParams().remove("contractFlag");
            page = this.service.queryPage(param, false);
            param.getParams().put("contractFlag", new Parameter("eq", contractFlag));
        } else {
            page = this.service.queryPage(param, false);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FlowVO.class));
        pageData.getRecords().forEach(item -> {
            if (item.getPurchaseContractId() != null && !"".equals(item.getPurchaseContractName())) {
                item.setContractFlagStr("\u6709");
            } else {
                item.setContractFlagStr("\u65e0");
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u6750\u6599\u8fdb\u573a\u7edf\u8ba1\u62a5\u8868\u5bfc\u51fa")
    @RequestMapping(value={"/inExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void inExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("purchaseContractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List orgVOList = null;
        if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().remove("parentOrgId");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = new ArrayList();
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = ((Parameter)param.getParams().get("contractFlag")).getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter("ne", null));
            }
            param.getParams().remove("contractFlag");
            list = this.service.queryList(param);
            param.getParams().put("contractFlag", new Parameter("eq", contractFlag));
        } else {
            list = this.service.queryList(param);
        }
        HashMap beans = new HashMap();
        ArrayList dataList = new ArrayList();
        list.forEach(item -> {
            FlowVO vo = (FlowVO)BeanMapper.map((Object)item, FlowVO.class);
            if (vo.getPurchaseContractId() != null && !"".equals(vo.getPurchaseContractName())) {
                vo.setContractFlagStr("\u6709");
            } else {
                vo.setContractFlagStr("\u65e0");
            }
            if (vo.getSourceType() != null && vo.getSourceType() == 0) {
                vo.setSourceTypeStr("\u81ea\u5236");
            } else {
                vo.setSourceTypeStr("\u8ba2\u5355");
            }
            dataList.add(vo);
        });
        beans.put("records", dataList);
        ExcelExport.getInstance().export("statisics-inList-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6750\u6599\u51fa\u5e93\u7edf\u8ba1\u62a5\u8868\u5bfc\u51fa")
    @RequestMapping(value={"/outExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void outExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        Object inOutFlag = ((Parameter)param.getParams().get("inOutFlag")).getValue();
        if (inOutFlag != null) {
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.ONE) {
                fuzzyFields.add("purchaseContractName");
                fuzzyFields.add("supplierName");
            }
            if (Integer.parseInt(inOutFlag.toString()) == StoreCommonConsts.TWO) {
                fuzzyFields.add("pickContractName");
                fuzzyFields.add("pickUnitName");
            }
        }
        fuzzyFields.add("sourceBillCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().remove("parentOrgId");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Page page = new Page();
        if (param.getParams().containsKey("contractFlag")) {
            Object contractFlag = ((Parameter)param.getParams().get("contractFlag")).getValue();
            if (contractFlag.equals("0")) {
                param.getParams().put("purchaseContractId", new Parameter("eq", null));
            }
            if (contractFlag.equals("1")) {
                param.getParams().put("purchaseContractId", new Parameter("ne", null));
            }
            param.getParams().remove("contractFlag");
            page = this.service.queryPage(param, false);
            param.getParams().put("contractFlag", new Parameter("eq", contractFlag));
        } else {
            page = this.service.queryPage(param, false);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FlowVO.class));
        pageData.getRecords().forEach(item -> {
            if (item.getPurchaseContractId() != null && !"".equals(item.getPurchaseContractName())) {
                item.setContractFlagStr("\u6709");
            } else {
                item.setContractFlagStr("\u65e0");
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("statisics-outList-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/sendReceiveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> sendReceiveList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("pickContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("pickUnitName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("materialSpec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        Parameter materialCategoryId = (Parameter)param.getParams().get("materialCategoryId");
        if (null != materialCategoryId && null != materialCategoryId.getValue()) {
            param.getParams().remove("materialCategoryId");
            CommonResponse res = this.shareMaterialApi.queryCategoryAllListByPid(Long.valueOf(materialCategoryId.getValue().toString()));
            if (res.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)res.getData()))) {
                List MaterialCategoryIds = ((List)res.getData()).stream().map(MaterialCategoryVO::getId).collect(Collectors.toList());
                param.getParams().put("materialCategoryId", new Parameter("in", MaterialCategoryIds));
            } else {
                param.getParams().put("0", new Parameter("eq", (Object)1));
            }
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            param.getParams().remove("parentOrgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"store_id", "material_id", "brand_id"});
        wrapper.eq((Object)"dr", (Object)StoreCommonConsts.NO);
        List<FlowVO> list = this.service.getSendReceiveList((Page<FlowVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/sendReceiveDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<FlowVO>> sendReceiveDetailList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        Object inOutFlagVal = ((Parameter)param.getParams().get("inOutFlag")).getValue();
        Integer inOutFlag = Integer.valueOf(inOutFlagVal.toString());
        param.getParams().put("inOutFlag", new Parameter("eq", (Object)inOutFlag));
        if (!StoreCommonConsts.IN_OUT_TYPE_IN.equals(inOutFlag)) {
            param.getParams().put("effectiveState", new Parameter("eq", (Object)StoreCommonConsts.YES));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object)"source_bill_date");
        List list = this.service.list((Wrapper)wrapper);
        List flowVOS = BeanMapper.mapList((Iterable)list, FlowVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)flowVOS);
    }

    @ApiOperation(value="\u4ed3\u5e93\u6536\u53d1\u5bfc\u51fa")
    @RequestMapping(value={"/sendReceiveExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void sendReceiveExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        param.setPageIndex(1);
        param.setPageSize(10000);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            param.getParams().remove("parentOrgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"store_id", "material_id", "brand_id"});
        List<FlowVO> list = this.service.getSendReceiveList((Page<FlowVO>)page, wrapper);
        HashMap<String, List<FlowVO>> beans = new HashMap<String, List<FlowVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("statisics-sendReceiveList-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6309\u65e5\u671f\u5206\u7ec4\u67e5\u8be2\u91d1\u989d")
    @RequestMapping(value={"/queryStoreMnyGroupByDate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreMnyGroupByDateVO>> queryStoreMnyGroupByDate(@RequestBody QueryParam param) {
        this.logger.info("\u4f20\u5165\u53c2\u6570param:{}", (Object)JSONObject.toJSONString((Object)param));
        if (null == param.getParams().get("turnFlag")) {
            param.getParams().put("turnFlag", new Parameter("eq", (Object)StoreCommonConsts.NO));
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else if (param.getParams().containsKey("parentOrgId")) {
            Object parentOrgId = ((Parameter)param.getParams().get("parentOrgId")).getValue();
            String parentOrgIdStr = String.valueOf(parentOrgId);
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(parentOrgIdStr))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().remove("parentOrgId");
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Page page = new Page();
        this.logger.info("\u7ec4\u88c5\u540eparam\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreMnyGroupByDateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

