/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bank"})
public class BankController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankService service;
    private final String BANK_ERP_REQ_URL = "/cefoc/yql/get_FP_BRDINList";
    @Autowired
    private IAdministrativeAreaService areaService;
    @Autowired
    private IBankCategoryService bankCategoryService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankVO> queryDetail(Long id) {
        BankEntity entity = (BankEntity)((Object)this.service.selectById(id));
        BankVO vo = (BankVO)BeanMapper.map((Object)((Object)entity), BankVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BankVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refBankData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BankVO>> refBankData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject, @RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("cityName");
        param.getFuzzyFields().add("provinceName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long categoryId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            categoryId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("categoryId", new Parameter("eq", (Object)categoryId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/zdsBankSync"})
    public CommonResponse<String> zdsBankSync(@RequestBody JSONObject reqParam) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u94f6\u884c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = null != reqParam.get((Object)"pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get((Object)"pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/get_FP_BRDINList";
        boolean hasNext = true;
        Map<String, String> headers = null;
        Integer reqErrorTimes = null != reqParam.get((Object)"reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove((Object)"reqErrorTimes");
        try {
            param.put("PageSize", (Object)pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            while (hasNext) {
                headers = ZdsReqUtil.getErpHeaders();
                pageNum = pageNum + 1;
                param.put("PageNum", (Object)pageNum);
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)10000, (Integer)10000);
                reqJson = JSONObject.parseObject((String)reqResp);
                reqErrorTimes = 0;
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        this.logger.info("\u4e2d\u7535\u56db\u94f6\u884c\u540c\u6b65,\u8bf7\u6c42\u6210\u529f\uff0c\u5171{}\u6761\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c{}\u9875-{}\u6761\u6570\u636e", new Object[]{reqJson.getString("allCount"), pageNum, pageData.size()});
                        this.handleErpPageData(pageData);
                        continue;
                    }
                    this.logger.info("\u4e2d\u7535\u56db\u94f6\u884c\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                    hasNext = false;
                    continue;
                }
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u94f6\u884c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
                hasNext = false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u94f6\u884c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            Integer pageData = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 2) {
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u652f\u884c\u5f02\u5e38\uff0c1.5s\u540e\u91cd\u8bd5.........,\u5f53\u524d\u5df2\u540c\u6b65{}\u6570\u636e", (Object)(param.getInteger("PageNum") - 1));
                Thread.sleep(5000L);
                param.put("pageSize", (Object)param.getInteger("PageSize"));
                param.put("pageNum", (Object)(param.getInteger("PageNum") - 1));
                param.put("reqErrorTimes", (Object)reqErrorTimes);
                return this.zdsBankSync(param);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u4e2d\u7535\u56db\u94f6\u884c\u652f\u884c\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u94f6\u884c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u94f6\u884c\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleErpPageData(JSONArray pageData) {
        List<BankEntity> dbListBySourceId;
        List<AdministrativeAreaEntity> areaList;
        JSONObject tmp = null;
        BankEntity tmpEntity = null;
        HashMap<String, BankEntity> dataMap = new HashMap<String, BankEntity>();
        ArrayList<BankEntity> saveList = new ArrayList<BankEntity>();
        Map<Object, Object> areasSourceMap = new HashMap();
        Map<Object, Object> bankSubCodeMap = new HashMap();
        HashSet<String> subBankCodes = new HashSet<String>();
        HashSet<String> areaSids = new HashSet<String>();
        List<BankCategoryEntity> bankCategoryList = null;
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            this.logger.info("\u5f53\u524d\u94f6\u884c\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)tmp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            tmpEntity = new BankEntity();
            tmpEntity.setName(tmp.getString("WHLNAM"));
            tmpEntity.setSourceId(tmp.getString("C_FP_BRDINFOOID"));
            tmpEntity.setEnabled("0".equals(tmp.getString("RCDSTS")) ? "1" : "0");
            tmpEntity.setSequence(null != tmp.get((Object)"Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpEntity.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            tmpEntity.setSubBankCode(tmp.getString("BNKNBR"));
            tmpEntity.setCityCode(tmp.getString("CTYCOD"));
            tmpEntity.setCityName(tmp.getString("city"));
            tmpEntity.setProvinceName(tmp.getString("province"));
            tmpEntity.setCitySid(tmp.getString("cityoid"));
            tmpEntity.setProvinceSid(tmp.getString("provinceoid"));
            tmpEntity.setCode(tmp.getString("BRDNBR"));
            tmpEntity.setBankSeq(tmp.getString("SEQNBR"));
            if (StringUtils.isNotBlank((CharSequence)tmpEntity.getCitySid())) {
                areaSids.add(tmpEntity.getCitySid());
            }
            if (StringUtils.isNotBlank((CharSequence)tmpEntity.getProvinceSid())) {
                areaSids.add(tmpEntity.getProvinceSid());
            }
            subBankCodes.add(tmpEntity.getSubBankCode());
            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        if (CollectionUtils.isNotEmpty(areaSids) && CollectionUtils.isEmpty(areaList = this.areaService.getAllBySourceIds(new ArrayList<String>(areaSids)))) {
            areasSourceMap = areaList.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }
        if (CollectionUtils.isNotEmpty(subBankCodes)) {
            bankCategoryList = this.bankCategoryService.getAllBySubBankCodes(new ArrayList<String>(subBankCodes));
        }
        if (CollectionUtils.isNotEmpty(bankCategoryList)) {
            bankSubCodeMap = bankCategoryList.stream().collect(Collectors.toMap(item -> item.getSubBankCode(), item -> item));
        }
        if (CollectionUtils.isNotEmpty(dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(dataMap.keySet())))) {
            for (BankEntity dbEntity : dbListBySourceId) {
                tmpEntity = (BankEntity)((Object)dataMap.get(dbEntity.getSourceId()));
                dbEntity.setName(tmpEntity.getName());
                dbEntity.setEnabled(tmpEntity.getEnabled());
                dbEntity.setSequence(tmpEntity.getSequence());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setCode(tmpEntity.getCode());
                dbEntity.setSubBankCode(tmpEntity.getSubBankCode());
                dbEntity.setProvinceSid(tmpEntity.getProvinceSid());
                dbEntity.setProvinceCode(tmpEntity.getProvinceCode());
                dbEntity.setProvinceName(tmpEntity.getProvinceName());
                dbEntity.setProvinceId(tmpEntity.getProvinceId());
                dbEntity.setCitySid(tmpEntity.getCitySid());
                dbEntity.setCityId(tmpEntity.getCityId());
                dbEntity.setCityCode(tmpEntity.getCityCode());
                dbEntity.setCityName(tmpEntity.getCityName());
                dbEntity.setBankSeq(tmpEntity.getBankSeq());
                saveList.add(dbEntity);
                dataMap.remove(dbEntity.getSourceId());
            }
        }
        if (!dataMap.isEmpty()) {
            saveList.addAll(dataMap.values());
        }
        AdministrativeAreaEntity city = null;
        AdministrativeAreaEntity province = null;
        BankCategoryEntity bankCategory = null;
        for (BankEntity item2 : saveList) {
            if (StringUtils.isNotBlank((CharSequence)item2.getCitySid()) && areasSourceMap.containsKey(item2.getCitySid())) {
                city = (AdministrativeAreaEntity)((Object)areasSourceMap.get(item2.getCitySid()));
            }
            if (null != city) {
                item2.setCityCode(city.getCode());
                item2.setCityName(city.getName());
                item2.setCityId(city.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)item2.getProvinceSid()) && areasSourceMap.containsKey(item2.getProvinceSid())) {
                province = (AdministrativeAreaEntity)((Object)areasSourceMap.get(item2.getProvinceSid()));
            }
            if (null != province) {
                item2.setProvinceCode(province.getCode());
                item2.setCityName(province.getName());
                item2.setCityId(province.getId());
            }
            if (null == (bankCategory = (BankCategoryEntity)((Object)bankSubCodeMap.get(item2.getSubBankCode())))) continue;
            item2.setCategoryId(bankCategory.getId());
            item2.setCategoryName(bankCategory.getName());
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }
}

