/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zds.archive.constants.EvaPendingStatusEnums;
import com.ejianc.business.zds.archive.constants.SubEvaLevelEnums;
import com.ejianc.business.zds.archive.constants.SubEvaResultEnums;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.SubEvaluationVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.google.common.base.Stopwatch;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subEvaluation"})
public class SubEvaluationController {
    private final String REQ_URL = "/cefoc/yql/getEvaluationLaunchList";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierService matSupplierService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IMatLinkerService matLinkerService;
    @Autowired
    private ILinkerService linkerService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @GetMapping(value={"getList"})
    public CommonResponse<JSONObject> getInquiryList(@RequestParam Long supplierTenant, @RequestParam Long linkerSupUserId, @RequestParam String supplierType) {
        MatLinkerVO linker;
        MatSupplierVO supplier;
        JSONObject resp = new JSONObject();
        String supplierSID = null;
        String idCardId = null;
        String linkerSid = null;
        if ("material".equals(supplierType)) {
            supplier = this.matSupplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.matLinkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            idCardId = linker.getIdCardId();
            linkerSid = linker.getThirdSourceId();
        } else {
            supplier = this.supplierService.getByTenantId(supplierTenant);
            if (null == supplier) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u4f9b\u5e94\u5546\u4fe1\u606f");
            }
            linker = this.linkerService.getBySupUserId(linkerSupUserId, supplier.getId());
            if (null == linker) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u8054\u7cfb\u4eba\u4fe1\u606f");
            }
            supplierSID = supplier.getThirdSourceId();
            idCardId = linker.getIdCardId();
            linkerSid = linker.getThirdSourceId();
        }
        Map<String, String> headers = null;
        Integer pageNum = 1;
        Integer pageSize = 60;
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/getEvaluationLaunchList";
        try {
            if (StringUtils.isNotBlank((String)supplierSID)) {
                reqUrl = reqUrl + "?CompanyOID=" + supplierSID;
            }
            if (StringUtils.isNotBlank((String)idCardId)) {
                reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?") + "IdCard=" + idCardId;
            }
            if (StringUtils.isNotBlank((String)linkerSid)) {
                reqUrl = reqUrl + (reqUrl.indexOf("?") > 0 ? "&" : "?") + "ContactsOID=" + linkerSid;
            }
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", (Object)pageSize);
            param.put("pageNum", (Object)pageNum);
            param.put("CompanyOID", (Object)supplierSID);
            param.put("IdCard", (Object)idCardId);
            param.put("ContactsOID", (Object)linkerSid);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            Stopwatch start = Stopwatch.createStarted();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT, (Integer)ZdsReqUtil.DEFAULT_TIME_OUT);
            Stopwatch end = start.stop();
            this.logger.info("\u8bf7\u6c42ERP\u5206\u5305\u8bc4\u4ef7\u5217\u8868\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u675f\u3002\u5171\u8ba1\u8017\u65f6\uff1a\u300c{}\u300d\u79d2", (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty}), (Object)end.elapsed(TimeUnit.SECONDS));
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                this.logger.info("\u8bf7\u6c42ERP\u5206\u5305\u8bc4\u4ef7\u5217\u8868\u8fd4\u56de\u6570\u636e\uff1a{} \u6761", (Object)(null != pageData ? pageData.size() : 0));
                resp = this.handlePageData(pageData);
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
            }
            this.logger.error("\u8bf7\u6c42ERP\u5206\u5305\u8bc4\u4ef7\u5217\u8868\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)param), (Object)reqResp);
            return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u5206\u5305\u8bc4\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546SID-{}\uff0c\u8054\u7cfb\u4ebaSID-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u5206\u5305\u8bc4\u4ef7\u5217\u8868\u5f02\u5e38\uff0c", new Object[]{supplierTenant.toString(), linkerSupUserId.toString(), e});
            return CommonResponse.error((String)"\u8bf7\u6c42ERP\u83b7\u53d6\u5206\u5305\u8bc4\u4ef7\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private JSONObject handlePageData(JSONArray pageData) {
        JSONObject resp = new JSONObject();
        resp.put("total", (Object)0);
        resp.put("records", new ArrayList());
        ArrayList<SubEvaluationVO> list = new ArrayList<SubEvaluationVO>();
        HashSet<String> projectCodes = new HashSet<String>();
        if (null != pageData && pageData.size() > 0) {
            JSONObject tmp = null;
            SubEvaluationVO tmpSubEva = null;
            for (Object obj : pageData) {
                tmp = (JSONObject)obj;
                tmpSubEva = new SubEvaluationVO();
                tmpSubEva.setSupplierName(tmp.getString("Contract_PartyB"));
                tmpSubEva.setSupplierLinkerName(tmp.getString("PartBContacts"));
                tmpSubEva.setProjectCode(tmp.getString("Account_Project_id"));
                tmpSubEva.setEvaLevel(tmp.getString("EvaLevel"));
                tmpSubEva.setResult(tmp.getString("PEResult"));
                tmpSubEva.setPendingStatus(tmp.getString("pendingStatus"));
                tmpSubEva.setEvaDate(DateUtil.parseDate(tmp.getString("EvaInitiationDate"), "yyyy/MM/dd HH:mm:ss"));
                tmpSubEva.setId(tmp.getString("C_PS_EvaluationLaunchOID"));
                tmpSubEva.setUnQualifiedItem(tmp.getString("PESIUnqualifiedItem"));
                if (!"1".equals(tmpSubEva.getPendingStatus())) continue;
                tmpSubEva.setEvaLevelName(SubEvaLevelEnums.getNameByCode((String)tmpSubEva.getEvaLevel()));
                tmpSubEva.setResultName(SubEvaResultEnums.getNameByCode((String)tmpSubEva.getResult()));
                tmpSubEva.setPendingStatusName(EvaPendingStatusEnums.getNameByCode((String)tmpSubEva.getPendingStatus()));
                if (null != tmpSubEva.getProjectCode()) {
                    projectCodes.add(tmpSubEva.getProjectCode());
                }
                list.add(tmpSubEva);
            }
            if (CollectionUtils.isNotEmpty(projectCodes)) {
                CommonResponse prjResp = this.projectPoolApi.getAllByCodes(new ArrayList(projectCodes));
                HashMap prjCodeNameMap = new HashMap();
                if (prjResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)prjResp.getData()))) {
                    ((List)prjResp.getData()).stream().forEach(item -> prjCodeNameMap.put(item.getCode(), item.getName()));
                }
                list.stream().filter(item -> prjCodeNameMap.containsKey(item.getProjectCode())).forEach(item -> item.setProjectName((String)prjCodeNameMap.get(item.getProjectCode())));
            }
            resp.put("total", (Object)list.size());
            resp.put("records", list);
        }
        return resp;
    }
}

