/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zds.archive.bean.SubTypeManagerEntity;
import com.ejianc.business.zds.archive.service.ISubTypeManagerService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.SubTypeManagerVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subTypeManager/"})
public class SubTypeManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubTypeManagerService service;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IZDSSubTypeApi izdsSubTypeApi;
    private final String SUB_TYPE_MANAGER_ERP_REQ_URL = "/cefoc/yql/getGoodTypeListMainPeople";

    @PostMapping(value={"/zdsSubTypeManagerSync"})
    public CommonResponse<String> zdsSubTypeManagerSync(@RequestBody JSONObject reqParam) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = null != reqParam.get((Object)"pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get((Object)"pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZdsReqUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZdsReqUtil.getErpReqHost() + "/cefoc/yql/getGoodTypeListMainPeople";
        boolean hasNext = true;
        Map<String, String> headers = null;
        Integer reqErrorTimes = null != reqParam.get((Object)"reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove((Object)"reqErrorTimes");
        try {
            headers = ZdsReqUtil.getErpHeaders();
            param.put("PageSize", (Object)pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", (Object)pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)10000, (Integer)10000);
            reqJson = JSONObject.parseObject((String)reqResp);
            reqErrorTimes = 0;
            if ("ok".equals(reqJson.getString("status"))) {
                this.service.disEnableAll();
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65,\u8bf7\u6c42\u6210\u529f\uff0c\u5171{}\u6761\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c{}\u9875-{}\u6761\u6570\u636e", new Object[]{reqJson.getString("allCount"), pageNum, pageData.size()});
                    int step = 100;
                    int total = pageData.size();
                    for (int startLine = 0; startLine < pageData.size(); startLine += step) {
                        this.handleErpPageData(pageData.subList(startLine, startLine + step < total ? startLine + step : total));
                    }
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            Integer pageData = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 2) {
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38\uff0c1.5s\u540e\u91cd\u8bd5.........,\u5f53\u524d\u5df2\u540c\u6b65{}\u6570\u636e", (Object)(param.getInteger("PageNum") - 1));
                Thread.sleep(5000L);
                param.put("pageSize", (Object)param.getInteger("PageSize"));
                param.put("pageNum", (Object)(param.getInteger("PageNum") - 1));
                param.put("reqErrorTimes", (Object)reqErrorTimes);
                return this.zdsSubTypeManagerSync(param);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u5206\u5305\u7c7b\u578b\u8d1f\u8d23\u4eba\u4fe1\u606f\u540c\u6b65\u5b8c\u6210\uff01");
    }

    private void handleErpPageData(List<Object> pageData) {
        JSONObject tmp = null;
        SubTypeManagerEntity tmpEntity = null;
        HashMap<String, SubTypeManagerEntity> dataMap = new HashMap<String, SubTypeManagerEntity>();
        ArrayList<SubTypeManagerEntity> saveList = new ArrayList<SubTypeManagerEntity>();
        HashSet<String> subTypeSids = new HashSet<String>();
        HashSet<String> empSid = new HashSet<String>();
        HashSet<String> sourceIds = new HashSet<String>();
        HashMap<String, SubTypeVO> subTypeMap = new HashMap<String, SubTypeVO>();
        HashMap<String, EmployeeVO> employeeMap = new HashMap<String, EmployeeVO>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = new SubTypeManagerEntity();
            tmpEntity.setManagerSid(tmp.getString("Title_Sid"));
            tmpEntity.setSubTypeSid(tmp.getString("GoodsType_FK"));
            tmpEntity.setEnabled(PlanConstant.INTEGER_YES);
            tmpEntity.setManagerName(tmp.getString("Title"));
            tmpEntity.setSourceId(tmp.getString("C_SD_GoodsTypeSubBOID"));
            empSid.add(tmpEntity.getManagerSid());
            subTypeSids.add(tmpEntity.getSubTypeSid());
            sourceIds.add(tmpEntity.getSourceId());
            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        if (CollectionUtils.isNotEmpty(subTypeSids)) {
            CommonResponse subTypeResp = this.izdsSubTypeApi.getAllBySourceIds(new ArrayList(subTypeSids));
            if (!subTypeResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5206\u5305\u7c7b\u578bSID\u5217\u8868-{}\u83b7\u53d6\u5bf9\u5e94\u5206\u5305\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff0c{}", subTypeSids, (Object)JSONObject.toJSONString(empSid, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)subTypeResp.getData()))) {
                subTypeMap.putAll(((List)subTypeResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
        }
        if (CollectionUtils.isNotEmpty(empSid)) {
            CommonResponse empResp = this.employeeApi.getAllBySourceIds(new ArrayList(empSid));
            if (!empResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u4eba\u5458SID\u5217\u8868-{}\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", empSid, (Object)JSONObject.toJSONString(empSid, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)empResp.getData()))) {
                employeeMap.putAll(((List)empResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
        }
        EmployeeVO tmpEmp = null;
        SubTypeVO tmpSubType = null;
        List<SubTypeManagerEntity> dbList = this.service.getAllBySourceIds(new ArrayList<String>(sourceIds));
        if (CollectionUtils.isNotEmpty(dbList)) {
            for (SubTypeManagerEntity dbEntity : dbList) {
                tmpEntity = (SubTypeManagerEntity)((Object)dataMap.get(dbEntity.getSourceId()));
                dbEntity.setEnabled(tmpEntity.getEnabled());
                tmpEmp = (EmployeeVO)employeeMap.get(tmpEntity.getManagerSid());
                if (null != tmpEmp) {
                    dbEntity.setManagerName(tmpEmp.getName());
                    dbEntity.setManagerCode(tmpEmp.getCode());
                    dbEntity.setManagerId(tmpEmp.getId());
                }
                if (null != (tmpSubType = (SubTypeVO)subTypeMap.get(tmpEntity.getSubTypeSid()))) {
                    dbEntity.setSubTypeId(tmpSubType.getId());
                    dbEntity.setSubTypeName(tmpSubType.getName());
                }
                saveList.add(dbEntity);
                dataMap.remove(dbEntity.getSourceId());
            }
        }
        if (!dataMap.isEmpty()) {
            for (SubTypeManagerEntity newRecord : dataMap.values()) {
                tmpEmp = (EmployeeVO)employeeMap.get(newRecord.getManagerSid());
                if (null != tmpEmp) {
                    newRecord.setManagerName(tmpEmp.getName());
                    newRecord.setManagerCode(tmpEmp.getCode());
                    newRecord.setManagerId(tmpEmp.getId());
                }
                if (null != (tmpSubType = (SubTypeVO)subTypeMap.get(newRecord.getSubTypeSid()))) {
                    newRecord.setSubTypeId(tmpSubType.getId());
                    newRecord.setSubTypeName(tmpSubType.getName());
                }
                saveList.add(newRecord);
            }
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<IPage<SubTypeManagerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("managerName");
        fuzzyFields.add("managerCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubTypeManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

