/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zds.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.mapper.BankMapper;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="bankService")
public class BankServiceImpl
extends BaseServiceImpl<BankMapper, BankEntity>
implements IBankService {
    @Override
    public List<BankEntity> getAllBySourceIds(List<String> sourceIds) {
        ArrayList<BankEntity> resp = new ArrayList<BankEntity>();
        if (CollectionUtils.isNotEmpty(sourceIds)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"source_id", sourceIds);
            query.in((Object)"tenant_id", new Object[]{InvocationInfoProxy.getTenantid()});
            return super.list((Wrapper)query);
        }
        return resp;
    }

    @Override
    public List<BankVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<BankVO>();
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"id", ids);
            query.in((Object)"tenant_id", new Object[]{InvocationInfoProxy.getTenantid()});
            List bankList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)bankList)) {
                resp = BeanMapper.mapList((Iterable)bankList, BankVO.class);
            }
        }
        return resp;
    }

    @Override
    public Map<String, BankEntity> getAllMapByNames(List<String> bankName) {
        HashMap<String, BankEntity> resp = new HashMap<String, BankEntity>();
        if (CollectionUtils.isNotEmpty(bankName)) {
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"name", bankName);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List bankList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)bankList)) {
                for (BankEntity bank : bankList) {
                    resp.put(bank.getName(), bank);
                }
            }
        }
        return resp;
    }
}

