/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdssupplier.sub.bean.SupplierEntity;
import com.ejianc.business.zdssupplier.sub.bean.SupplierManagerEntity;
import com.ejianc.business.zdssupplier.sub.service.ISupplierManagerService;
import com.ejianc.business.zdssupplier.sub.service.ISupplierService;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ProjectManagerCooListener
extends BaseConsumer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private ISupplierManagerService supplierManagerService;
    @Autowired
    private ISupplierService supplierService;

    protected void doConsumeMsg(MqMessage mqMessage) {
        this.logger.info("\u63a5\u6536\u5230\u5f85\u534f\u540c\u9879\u76ee\u7ecf\u7406\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)mqMessage.getBody()));
        try {
            SupplierManagerVO managerVO = (SupplierManagerVO)JSONObject.parseObject((String)JSON.toJSONString((Object)mqMessage.getBody()), SupplierManagerVO.class);
            SupplierManagerEntity managerEntity = (SupplierManagerEntity)((Object)this.supplierManagerService.selectById(managerVO.getId()));
            if (null == managerEntity) {
                this.logger.info("\u4f9b\u5e94\u5546id-{}\u9879\u76ee\u7ecf\u7406-{}\uff0c\u751f\u6210\u534f\u540c\u8d26\u53f7\u5931\u8d25\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u5339\u914d\u7684\u9879\u76ee\u7ecf\u7406\u4fe1\u606f\uff01", (Object)managerVO.getSupplierId(), (Object)JSONObject.toJSONString((Object)managerVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return;
            }
            if ("1".equals(managerEntity.getCoordination())) {
                this.logger.info("\u4f9b\u5e94\u5546\u9879\u76ee\u7ecf\u7406-{},\u5df2\u751f\u6210\u534f\u540c\u8d26\u53f7\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002");
                return;
            }
            SupplierEntity supplier = (SupplierEntity)((Object)this.supplierService.selectById(managerVO.getSupplierId()));
            this.supplierManagerService.createSupAccount(managerEntity, supplier.getTenant());
        }
        catch (Exception e) {
            this.logger.error("\u76d1\u542c\u6d88\u606f\u5f02\u5e38: ", (Throwable)e);
        }
    }

    protected String[] getQueueNames() {
        return new String[]{"project_manager_coordination_queue_" + this.profile};
    }
}

