/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.common.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.SupplierSyncFactory;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SupplierUpdListener
extends BaseConsumer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${spring.cloud.config.profile}")
    private String profile;

    protected void doConsumeMsg(MqMessage mqMessage) {
        this.logger.info("\u63a5\u6536\u5230\u5f85\u540c\u6b65ERP\u4f9b\u5e94\u5546\u4fe1\u606f\u4fe1\u606f\uff1a{}", mqMessage.getBody());
        try {
            SupplierSyncParam param = (SupplierSyncParam)JSONObject.parseObject((String)mqMessage.getBody().toString(), SupplierSyncParam.class);
            if (StringUtils.isBlank((CharSequence)param.getHandleServiceName())) {
                this.logger.error("\u4f9b\u5e94\u5546id-{},syncType-{}\u540c\u6b65\u5931\u8d25\uff0c\u5904\u7406\u670d\u52a1\u540d\u79f0\u4e3a\u7a7a\uff01", (Object)param.getSupplierId(), (Object)param.getSyncType());
                return;
            }
            SupplierSyncFactory.getInstance(param.getHandleServiceName()).supplierSync(param);
        }
        catch (Exception e) {
            this.logger.error("\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5f02\u5e38: ", (Throwable)e);
        }
    }

    protected String[] getQueueNames() {
        return new String[]{"erp_sup_upd_" + this.profile};
    }
}

