/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.common.utils;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.business.zdssupplier.common.consumer.TransferVO;
import com.ejianc.business.zdssupplier.common.utils.BillLockUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PushSupUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    private static final String UPLOAD_FILE_QUEUE = "upload_file_queue";
    public static final String SSO = "portal";
    @Value(value="${eachLink.host}")
    private String host;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISmsMessageApi smsMessageApi;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> exchangeDataWithUniversal(String url, String postData) {
        CommonResponse<String> resp = this.exchangeDataWithUniversal(url, RequestMethod.POST, postData);
        return resp;
    }

    public CommonResponse<String> exchangeDataWithUniversal(String url, Map<String, String> params) {
        CommonResponse<String> resp = this.exchangeDataWithUniversal(url, JSONObject.toJSONString(params));
        return resp;
    }

    public CommonResponse<String> exchangeDataWithUniversal(String url, RequestMethod method, String postData) {
        CommonResponse resp = this.systemDataPushService.exchangeDataWithUniversal(url, method, postData, this.appId, this.secret, this.host);
        return resp;
    }

    public CommonResponse<String> exchangeDataAndFilesWithUniversal(String url, Map<String, String> params) {
        CommonResponse<String> resp = this.exchangeDataAndFilesWithUniversal(url, params, null);
        return resp;
    }

    public CommonResponse<String> exchangeDataAndFilesWithUniversal(String url, Map<String, String> params, Map<String, Map<String, InputStream>> files) {
        CommonResponse resp = this.systemDataPushService.exchangeDataAndFilesWithUniversal(url, params, files, this.appId, this.secret, this.host);
        return resp;
    }

    public CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(String url, Map<String, String> params, String supplierId) {
        CommonResponse<String> resp = null;
        resp = StringUtils.isEmpty((CharSequence)supplierId) ? this.exchangeDataAndFilesWithUniversal(url, params) : this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId, null);
        return resp;
    }

    public CommonResponse<String> exchangeDataAndFilesWithEachLinkSystem(String url, Map<String, String> params, String supplierId, Map<String, Map<String, InputStream>> files) {
        CommonResponse resp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId, files);
        return resp;
    }

    public Long pushBillToSupCenter(JSONObject entity, String systemIdName, String billType, String name, String url) {
        Long sourceId;
        block12: {
            sourceId = null;
            String id = entity.getString("id");
            String supplierId = entity.getString("supplierId");
            CommonResponse systemCodeResp = this.proSupplierApi.getEjcCloudSystemCode();
            if (!systemCodeResp.isSuccess()) {
                this.logger.error("\u63a8\u9001\u5355\u636e-{}-id{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", new Object[]{name, id, systemCodeResp.getMsg()});
                return sourceId;
            }
            entity.put(systemIdName, systemCodeResp.getData());
            if (entity.containsKey((Object)"tenantId")) {
                entity.remove((Object)"tenantId");
            }
            if (entity.containsKey((Object)"version")) {
                entity.remove((Object)"version");
            }
            try {
                CommonResponse resp;
                BillLockUtil.getLock(billType, Long.valueOf(id));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("transData", JSONObject.toJSONString((Object)entity));
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(Long.valueOf(id), null, null, null);
                if (!fileResp.isSuccess()) {
                    this.logger.error("\u83b7\u53d6\u5355\u636e-{}id-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", new Object[]{name, id, fileResp.getMsg()});
                }
                List fileList = (List)fileResp.getData();
                params.put("fileList", JSONObject.toJSONString((Object)fileList));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u5355\u636e-{}\u53c2\u6570-{}", new Object[]{supplierId, name, JSONObject.toJSONString(params)});
                CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
                this.logger.error("\u5355\u636e-{}\u56de\u5199\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)name, (Object)JSONObject.toJSONString(syncResp));
                if (!syncResp.isSuccess()) {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u5355\u636e-{}id-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{name, id, supplierId, syncResp.getMsg()});
                }
                if (noPower.equals(syncResp.getData())) {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{url, supplierId, syncResp.getData()});
                }
                if ((resp = (CommonResponse)JSONObject.parseObject((String)((String)syncResp.getData()), CommonResponse.class)).isSuccess()) {
                    sourceId = Long.valueOf((String)resp.getData());
                    break block12;
                }
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636e-{}id-{}\u5931\u8d25, {}", new Object[]{supplierId, name, id, resp.getMsg()});
                throw new BusinessException(resp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u63a8\u9001\u5355\u636e-{}id-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{name, id, supplierId, e});
                throw new BusinessException(e.getMessage());
            }
            finally {
                BillLockUtil.releaseLock(billType, Long.valueOf(id));
            }
        }
        return sourceId;
    }

    public String syncBillStatus(HttpServletRequest request, JSONObject entity, Class<?> mainClass, String statusName, String billType, String name) {
        if (entity == null) {
            this.logger.error("\u5355\u636eid-{}\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01", (Object)entity.getString("id"));
            return "\u672a\u67e5\u8be2\u5230\u5355\u636e";
        }
        this.logger.info("\u5355\u636e-{}\u63a5\u6536\u5230\u6570\u636eparameters\uff1a{}", (Object)name, (Object)JSONObject.toJSONString((Object)request.getParameterMap()));
        String authority = request.getHeader("authority");
        String billId = request.getParameter("billId");
        String status = request.getParameter(statusName);
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Long time = Long.valueOf(request.getParameter("supOperateTime"));
        Date supOperateTime = time != null ? new Date(time) : null;
        String fileListStr = request.getParameter("fileList");
        List fileList = (List)JSONObject.parseObject((String)fileListStr, (TypeReference)new TypeReference<List<AttachmentVO>>(){}, (Feature[])new Feature[0]);
        entity.put("supOperateTime", (Object)supOperateTime);
        entity.put("supOperatorName", (Object)supOperatorName);
        entity.put("supOperatorPhone", (Object)supOperatorPhone);
        entity.put("supOperatorUserCode", (Object)supOperatorUserCode);
        entity.put(statusName, (Object)status);
        try {
            BillLockUtil.getLock(billType, Long.valueOf(billId));
            List<Long> attachIds = this.uploadFileFormNet(fileList, billType);
            entity.put("attachIds", attachIds);
            EntityUtil.saveOrUpdate(BeanMapper.map((Object)entity, mainClass));
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u72b6\u6001\u56de\u5199\u5f02\u5e38\uff0c", new Object[]{name, billId, e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            BillLockUtil.releaseLock(billType, Long.valueOf(billId));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delPushBill(JSONObject entity, String systemIdName, String billType, String name, String url) {
        String id = entity.getString("id");
        String supplierId = entity.getString("supplierId");
        boolean delSuc = false;
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}id-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", new Object[]{name, id, ejcCloudSystemCode.getMsg()});
        }
        String systemId = (String)ejcCloudSystemCode.getData();
        entity.put(systemIdName, (Object)systemId);
        try {
            BillLockUtil.getLock(billType, Long.valueOf(id));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceId", id);
            params.put("systemId", systemId);
            this.logger.info("\u5355\u636e-{}id-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", new Object[]{name, id, supplierId});
            CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
            if (!syncResp.isSuccess()) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{supplierId, id, syncResp.getMsg()});
                boolean bl = delSuc;
                return bl;
            }
            CommonResponse supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                delSuc = true;
            } else {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636e-{}id-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{supplierId, name, id, supHandleResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)id, (Object)e);
        }
        finally {
            BillLockUtil.releaseLock(billType, Long.valueOf(id));
        }
        return delSuc;
    }

    public Long saveSyncBill(HttpServletRequest request, Class<?> mainClass, String billType, String name) {
        return this.saveSyncBill(request, mainClass, billType, name, true);
    }

    public Long saveSyncBill(HttpServletRequest request, Class<?> mainClass, String billType, String name, boolean sourceFlag) {
        Field[] fields;
        this.logger.info("\u5355\u636e-{}\u8fdb\u5165\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>", (Object)name);
        String transData = request.getParameter("transData");
        String fileListStr = request.getParameter("fileList");
        List fileList = (List)JSONObject.parseObject((String)fileListStr, (TypeReference)new TypeReference<List<AttachmentVO>>(){}, (Feature[])new Feature[0]);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cfileList\uff1a{}", (Object)transData, (Object)fileList);
        if (StringUtils.isBlank((CharSequence)transData)) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        JSONObject saveEntity = JSONObject.parseObject((String)transData);
        saveEntity.put("sourceId", (Object)saveEntity.getLong("id"));
        EntityUtil.clearInvalidData(saveEntity);
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class) || !saveEntity.containsKey((Object)field.getName())) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            for (Object obj : saveEntity.getJSONArray(field.getName())) {
                JSONObject detail = (JSONObject)obj;
                if (sourceFlag) {
                    detail.put("sourceId", (Object)detail.getLong(subEntity.pidName()));
                    detail.put("sourceDetailId", (Object)detail.getLong("id"));
                }
                EntityUtil.clearInvalidData(detail);
            }
        }
        List<Long> attachIds = this.uploadFileFormNet(fileList, billType);
        saveEntity.put("attachIds", attachIds);
        Long id = EntityUtil.saveOrUpdate(BeanMapper.map((Object)saveEntity, mainClass));
        this.logger.info("\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return id;
    }

    public String updateBillStatus(JSONObject entity, String statusName, String systemIdName, String billType, String name, String url, String sourceType) {
        String id = entity.getString("id");
        this.logger.info("\u5355\u636e-{}id-{}\u8fdb\u884c\u66f4\u65b0\u72b6\u6001\u64cd\u4f5c\uff01", (Object)name, (Object)id);
        String sourceId = entity.getString("sourceId");
        String status = entity.getString(statusName);
        String systemId = entity.getString(systemIdName);
        String supplierId = entity.getString("supplierId");
        try {
            CommonResponse operateResp;
            BillLockUtil.getLock(billType, Long.valueOf(id));
            AttachmentVO file = null;
            if (StringUtils.isNotEmpty((CharSequence)sourceType)) {
                CommonResponse attachsResp = this.attachmentApi.queryListBySourceId(Long.valueOf(id), null, sourceType, null);
                if (attachsResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)attachsResp.getData()))) {
                    file = ((List)attachsResp.getData()).stream().findFirst().orElse(new AttachmentVO());
                } else {
                    this.logger.error("\u67e5\u8be2id-{}\u5f53\u524d\u7b7e\u5b57\u6587\u4ef6-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", new Object[]{id, sourceType, attachsResp.getMsg()});
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fileList", JSONObject.toJSONString(Collections.singletonList(file)));
            params.put("billId", PushSupUtil.createString(sourceId));
            UserContext user = this.sessionManager.getUserContext();
            params.put("supOperatorName", user.getUserName());
            params.put("supOperatorPhone", user.getUserMobile());
            params.put("supOperatorUserCode", user.getUserCode());
            params.put("supOperateTime", String.valueOf(new Date().getTime()));
            params.put(statusName, status);
            params.put("transData", JSONObject.toJSONString((Object)entity));
            this.logger.info("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{name, id, systemId, JSONObject.toJSONString(params)});
            CommonResponse<String> syncResp = this.exchangeDataAndFilesWithEachLinkSystem(url, params, supplierId);
            this.logger.error("\u5355\u636e-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)name, (Object)JSONObject.toJSONString(syncResp));
            if (!syncResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{name, id, syncResp.getMsg()});
            }
            if (noPower.equals(syncResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{url, systemId, syncResp.getData()});
            }
            if (!(operateResp = (CommonResponse)JSONObject.parseObject((String)((String)syncResp.getData()), CommonResponse.class)).isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{name, id, operateResp.getMsg()});
                throw new BusinessException(operateResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff0c", new Object[]{name, id, e});
            throw new BusinessException(e.getMessage());
        }
        finally {
            BillLockUtil.releaseLock(billType, Long.valueOf(id));
        }
        return null;
    }

    public String sendMsg(String[] channel, String[] receivers, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        ArrayList<String> user = new ArrayList<String>(Arrays.asList(receivers));
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        receivers = user.toArray(new String[user.size()]);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setContent(content);
        parameter.setSubject(subject);
        parameter.setMsgType(msgType);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        parameter.setChannel(channel);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params) {
        return this.sendEmail(receivers, msgType, subject, content, params, null, null);
    }

    public String sendEmail(String[] receivers, String msgType, String subject, String content, JSONObject params, String pcUrl, String mobileUrl) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        if (receivers != null) {
            ArrayList<String> user = new ArrayList<String>(Arrays.asList(receivers));
            Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
            receivers = user.toArray(new String[user.size()]);
        }
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setZdsExtEmailParams(params);
        parameter.setContent(content);
        parameter.setSubject(subject);
        parameter.setMsgType(msgType);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        parameter.setChannel(new String[]{"email"});
        if (StringUtils.isNotBlank((CharSequence)pcUrl)) {
            parameter.setPcUrl(pcUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)mobileUrl)) {
            parameter.setMobileUrl(mobileUrl);
        }
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendSms(String phone, String templateCode, String signName, Map<String, String> params) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        SmsMsgSendParam parameter = new SmsMsgSendParam();
        parameter.setPhone(phone);
        parameter.setTemplateCode(templateCode);
        parameter.setSignName(signName);
        parameter.setParams(params);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.smsMessageApi.sendMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public String sendSmsNoAuth(String phone, String templateCode, String signName, Map<String, String> params) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        SmsMsgSendParam messageParam = new SmsMsgSendParam();
        messageParam.setPhone(phone);
        messageParam.setTemplateCode(templateCode);
        messageParam.setSignName(signName);
        messageParam.setParams(params);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)messageParam));
        String messageUrl = this.environmentTools.getBaseHost() + "ejc-message-web/no_auth/sms/sendMessage";
        try {
            String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
            CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (response.isSuccess()) {
                this.logger.info("\u9080\u8bf7\u7801\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u6210\u529f\uff01{}", (Object)phone);
            } else {
                this.logger.info("\u9080\u8bf7\u7801\u77ed\u4fe1\u901a\u77e5\u53d1\u9001\u6210\u529f \u53d1\u9001\u5931\u8d25\uff01{}----{}", (Object)phone, (Object)responseStr);
            }
            this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->{}" + responseStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u77ed\u4fe1\u53d1\u9001\u6210\u529f \u53d1\u9001\u5931\u8d25\uff01{}----{}", (Object)phone, (Object)e.getMessage());
        }
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public static String getCreateUserId(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = PushSupUtil.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader((String)(urlconstants.getMetaDataBaseUrl() + referCode), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException((String)("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!"));
        }
        return data;
    }

    public String sendMq(TransferVO body) {
        MqMessage mqMessage = new MqMessage();
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        body.setAuthority(request.getHeader("authority"));
        if (StringUtils.isEmpty((CharSequence)body.getUrl()) && null != body.getFileId()) {
            body.setUrl(this.host + "/ejc-file-web/attachment/no_auth/download?fileId=" + body.getFileId());
        }
        mqMessage.setBody((Object)body);
        this.rabbitTemplate.convertAndSend("upload_file_queue_" + this.profile, (Object)mqMessage);
        this.logger.info("MQ\u961f\u5217\u6807\u8bc6\uff1a{}", (Object)("upload_file_queue_" + this.profile));
        return "\u6d88\u606f\u53d1\u9001MQ\u961f\u5217\u6210\u529f\uff01";
    }

    public String uploadFileByUrl(String url, String sourceId, String billType, String sourceType, String authority) {
        Object downloadFileStr = null;
        try {
            this.logger.info("\u6839\u636e\u9644\u4ef6\u5730\u5740:{}", (Object)url);
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.logger.error("sourceId-{}\u7684url\u4e3a\u7a7a\uff01", (Object)sourceId);
                return null;
            }
            HttpResponse response = HttpUtil.createGet((String)url).executeAsync();
            HashMap<String, ByteArrayInputStream> resp = new HashMap<String, ByteArrayInputStream>();
            String fileName = response.header("Content-Disposition").split(";")[1].split("=")[1];
            fileName = URLDecoder.decode(fileName, "UTF-8");
            resp.put(fileName, new ByteArrayInputStream(response.bodyBytes()));
            this.logger.info("\u6839\u636e\u9644\u4ef6\u5730\u5740\uff1a{} \u4e0b\u8f7d\u9644\u4ef6\u6210\u529f:{}", (Object)url, (Object)fileName);
            HashMap files = new HashMap();
            resp.keySet().stream().forEach(fileKey -> {
                HashMap file = new HashMap(1);
                file.put((String)fileKey, resp.get(fileKey));
                files.put(fileKey, file);
            });
            List attachmentVOS = FileUtil.getInstance().upFile(sourceType, sourceId, billType, files, authority);
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOS)) {
                AttachmentVO vo = (AttachmentVO)attachmentVOS.get(0);
                return vo.getFilePath();
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u9644\u4ef6\u5730\u5740\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType) {
        return this.uploadFileFormNet(fileList, billType, IdWorker.getId(), null);
    }

    public List<Long> uploadFileFormNet(List<AttachmentVO> fileList, String billType, Long sourceId, String sourceType) {
        fileList.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(fileList)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> attachIds = new ArrayList<Long>();
        for (AttachmentVO file : fileList) {
            UploadFileForNetParam param = new UploadFileForNetParam();
            param.setTenantId(InvocationInfoProxy.getTenantid());
            param.setBillType(billType);
            param.setSourceId(sourceId);
            param.setSourceType(StringUtils.isNotBlank((CharSequence)sourceType) ? sourceType : file.getSourceType());
            String url = this.host + "/filepreview/" + file.getFilePath();
            param.setFilePathList(Collections.singletonList(url));
            Long id = IdWorker.getId();
            CommonResponse fileResp = this.attachmentApi.queryDetail(file.getId().toString());
            if (fileResp.isSuccess() && null == fileResp.getData()) {
                id = file.getId();
            }
            param.setNewFileIds(Collections.singletonList(id));
            CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
            if (!resp.isSuccess()) {
                this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
            }
            attachIds.add(id);
        }
        return attachIds;
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId) {
        if (null == sourceId) {
            sourceId = IdWorker.getId();
        }
        String filePath = this.getFilePath(fileId);
        return this.uploadFileFormNet(billType, sourceId, sourceType, filePath);
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, Long fileId, String fileHost) {
        if (null == sourceId) {
            sourceId = IdWorker.getId();
        }
        String filePath = this.getFilePath(fileId, fileHost);
        return this.uploadFileFormNet(billType, sourceId, sourceType, filePath, fileHost);
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath, String fileHost) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = fileHost + (fileHost.endsWith("/") ? "" : "/") + "filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
        if (!resp.isSuccess()) {
            this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
        }
        this.logger.info("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)param), resp.getData());
        return id;
    }

    public Long uploadFileFormNet(String billType, Long sourceId, String sourceType, String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        String url = this.host + "/filepreview/" + filePath;
        param.setFilePathList(Collections.singletonList(url));
        Long id = IdWorker.getId();
        param.setNewFileIds(Collections.singletonList(id));
        CommonResponse resp = this.attachmentApi.uploadFileFormNet(param);
        if (!resp.isSuccess()) {
            this.logger.error("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38-{}", (Object)JSONObject.toJSONString((Object)param), (Object)resp.getMsg());
        }
        this.logger.info("\u53c2\u6570-{},\u9644\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)param), resp.getData());
        return id;
    }

    public String getFilePath(Long attachid) {
        AttachmentVO result = this.getattachById(attachid);
        return result.getFilePath();
    }

    public String getFilePath(Long attachid, String fileHost) {
        AttachmentVO result = this.getattachById(attachid, fileHost);
        return result.getFilePath();
    }

    public AttachmentVO getattachById(Long attachid) {
        String url = this.host + "/ejc-file-web/attachment/no_auth/getattachById";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader((String)url, params);
            this.logger.info("attachid-{},\u9644\u4ef6\u67e5\u8be2\u7ed3\u679c-{}", (Object)attachid, (Object)responseStr);
            CommonResponse resp = (CommonResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<CommonResponse<AttachmentVO>>(){}, (Feature[])new Feature[0]);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            if (null == resp.getData()) {
                return new AttachmentVO();
            }
            return (AttachmentVO)resp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("attachid-{},\u9644\u4ef6\u67e5\u8be2\u5f02\u5e38-{}", (Object)attachid, (Object)e.getMessage());
            return new AttachmentVO();
        }
    }

    public AttachmentVO getattachById(Long attachid, String fileHost) {
        String url = fileHost + (fileHost.endsWith("/") ? "" : "/") + "ejc-file-web/attachment/no_auth/getattachById";
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("attachid", attachid);
        try {
            String responseStr = HttpTookit.getAndHeader((String)url, params);
            this.logger.info("attachid-{},\u9644\u4ef6\u67e5\u8be2\u7ed3\u679c-{}", (Object)attachid, (Object)responseStr);
            CommonResponse resp = (CommonResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<CommonResponse<AttachmentVO>>(){}, (Feature[])new Feature[0]);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            if (null == resp.getData()) {
                return new AttachmentVO();
            }
            return (AttachmentVO)resp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("attachid-{},\u9644\u4ef6\u67e5\u8be2\u5f02\u5e38-{}", (Object)attachid, (Object)e.getMessage());
            return new AttachmentVO();
        }
    }

    public List<AttachmentVO> queryListBySourceId(Long sourceId, String sourceType) {
        String url = this.host + "/ejc-file-web/no_auth/api/attachref/queryListBySourceId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sourceId", sourceId);
        params.put("sourceType", sourceType);
        try {
            String responseStr = HttpTookit.getAndHeader((String)url, params);
            this.logger.info("sourceId-{},sourceType-{},\u9644\u4ef6\u67e5\u8be2\u7ed3\u679c-{}", new Object[]{sourceId, sourceType, responseStr});
            CommonResponse resp = (CommonResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<CommonResponse<List<AttachmentVO>>>(){}, (Feature[])new Feature[0]);
            if (!resp.isSuccess()) {
                throw new BusinessException(resp.getMsg());
            }
            return (List)resp.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("sourceId-{},sourceType-{},\u9644\u4ef6\u67e5\u8be2\u5f02\u5e38-{}", new Object[]{sourceId, sourceType, e.getMessage()});
            return new ArrayList<AttachmentVO>();
        }
    }

    public Long getFileId(Long sourceId, String billType, String sourceType, Long fileId) {
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
        if (!fileResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.error("\u83b7\u53d6billType-{},sourceId-{},sourceType-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", new Object[]{billType, sourceId, sourceType, fileResp.getMsg()});
            Long newId = this.uploadFileFormNet(billType, sourceId, sourceType, fileId);
            return newId;
        }
        List fileList = (List)fileResp.getData();
        return ((AttachmentVO)fileList.get(0)).getId();
    }

    public UserContext getUser() {
        UserContext user = this.sessionManager.getUserContext();
        return user;
    }

    public String getLoginUrl() {
        return this.host + "/" + SSO;
    }

    public void validateStatus(String voStatus, String entityStatus) {
        if ("4".equals(voStatus) && !"2".equals(entityStatus)) {
            this.logger.error("\u9080\u8bf7\u72b6\u6001-{}-{}\uff0c\u4e0d\u5141\u8bb8\u9a73\u56de\uff01", (Object)entityStatus, PlanConstant.INVITE_STATUS.get(entityStatus));
            throw new BusinessException("\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\uff01");
        }
        if ("5".equals(voStatus) && !"1".equals(entityStatus) && !"4".equals(entityStatus)) {
            this.logger.error("\u9080\u8bf7\u72b6\u6001-{}-{}\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\uff01", (Object)entityStatus, PlanConstant.INVITE_STATUS.get(entityStatus));
            throw new BusinessException("\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c\uff01");
        }
    }

    public static String createString(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public static String clearBracket(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        String pattern = "\\([^)]*\\)";
        content = content.replaceAll(pattern, "");
        return content;
    }

    public static void main(String[] args) {
        String content = "\u6709\u9650\u8d23\u4efb\u516c\u53f8(\u81ea\u7136\u4eba\u6295\u8d44\u6216\u63a7\u80a1\u7684\u6cd5\u4eba\u72ec\u8d44)";
        String pattern = "\\([^)]*\\)";
        System.out.println(PushSupUtil.clearBracket(content));
    }
}

