/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.cons.enums.SupLinkerEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerChangeEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matLinkerChange"})
public class MatLinkerChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_MAT_LINKER_CHANGE";
    @Autowired
    private IMatLinkerChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMatLinkerService linkerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> saveOrUpdate(@RequestBody MatLinkerChangeVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> queryDetail(Long id) {
        MatLinkerChangeVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatLinkerChangeVO> vos) {
        ArrayList<Long> linkerId = new ArrayList<Long>();
        if (ListUtil.isNotEmpty(vos)) {
            for (MatLinkerChangeVO vo : vos) {
                MatLinkerChangeEntity linkerChangeEntity = (MatLinkerChangeEntity)((Object)this.service.selectById(vo.getId()));
                if (linkerChangeEntity.getSourceType().equals("1") || SupLinkerEnum.\u5df2\u9a73\u56de\u4f9b\u65b9.getCode().equals(linkerChangeEntity.getReceiveStatus())) {
                    linkerId.add(linkerChangeEntity.getLinkerId());
                    continue;
                }
                throw new BusinessException("\u53ea\u6709\u5df2\u9a73\u56de\u4f9b\u65b9\u7684\u53d8\u66f4\u5355\u624d\u53ef\u4ee5\u5220\u9664\uff01");
            }
        }
        if (CollectionUtil.isNotEmpty(linkerId)) {
            this.linkerService.deleteChange(linkerId);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("name");
        fuzzyFields.add("userName");
        fuzzyFields.add("linkPhone");
        fuzzyFields.add("idCardId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List linkerChangeVOS = BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerChangeVO.class);
        linkerChangeVOS.stream().forEach(vo -> {
            if (vo.getReceiveStatus() != null) {
                switch (vo.getReceiveStatus()) {
                    case 0: {
                        vo.setReceiveStatusStr("\u5f85\u63d0\u4ea4");
                        break;
                    }
                    case 1: {
                        vo.setReceiveStatusStr("\u5f85\u5ba1\u6838");
                        break;
                    }
                    case 2: {
                        vo.setReceiveStatusStr("\u5df2\u5ba1\u6838");
                        break;
                    }
                    case 3: {
                        vo.setReceiveStatusStr("\u5df2\u9a73\u56de");
                        break;
                    }
                    case 4: {
                        vo.setReceiveStatusStr("\u5ba1\u6838\u4e2d");
                    }
                }
            } else {
                vo.setReceiveStatusStr("\u5f85\u63d0\u4ea4");
            }
            vo.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        pageData.setRecords(linkerChangeVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<MatLinkerChangeVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (iPageCommonResponse.isSuccess()) {
            IPage pageData = (IPage)iPageCommonResponse.getData();
            records = pageData.getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("MatLinkerChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/addConvertById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> addConvertById(Long linkerId) {
        MatLinkerChangeVO vo = this.service.addConvertById(linkerId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/contrast"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contrast(Long linkerId) {
        JSONObject contrast = this.service.contrast(linkerId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)contrast);
    }

    @PostMapping(value={"syncBill"})
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        return this.service.syncBill(request);
    }

    @RequestMapping(value={"/pushStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatLinkerChangeVO> pushStatus(Long id) {
        return this.service.pushStatus(id);
    }
}

