/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerAccessEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerInviteEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matLinkerInvite"})
public class MatLinkerInviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS_MAT_LINKER_INVITE";
    @Autowired
    private IMatLinkerInviteService service;
    @Autowired
    private IMatLinkerAccessService accessService;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatLinkerInviteVO> saveOrUpdate(@RequestBody MatLinkerInviteVO saveOrUpdateVO) {
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(saveOrUpdateVO.getSupplierId()));
        if (!"1".equals(supplier.getCoordination())) {
            this.supplierService.createSupTenant(supplier);
        }
        MatLinkerInviteVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatLinkerInviteVO> queryDetail(Long id) {
        MatLinkerInviteEntity entity = (MatLinkerInviteEntity)((Object)this.service.selectById(id));
        MatLinkerInviteVO vo = (MatLinkerInviteVO)BeanMapper.map((Object)((Object)entity), MatLinkerInviteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatLinkerInviteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatLinkerInviteVO matLinkerInviteVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerInviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("linkerName");
        fuzzyFields.add("inviterName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("inviterId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        if (!param.getParams().containsKey("status")) {
            param.getParams().put("status", new Parameter("ne", (Object)"6"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerInviteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            List ids = records.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter("in", ids));
            List list = this.accessService.queryList(queryParam);
            Map<Long, MatLinkerAccessEntity> map = list.stream().collect(Collectors.toMap(x -> x.getInviteId(), x -> x, (v1, v2) -> v2));
            for (MatLinkerInviteVO vo : records) {
                if (!map.containsKey(vo.getId())) continue;
                MatLinkerAccessEntity access = map.get(vo.getId());
                vo.setAccessId(access.getId());
                vo.setUserType(access.getUserType());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerInviteVO>> queryApproveList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("linkerName");
        fuzzyFields.add("inviterName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("inviterId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        param.getParams().put("status", new Parameter("eq", (Object)"6"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerInviteVO.class);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            List ids = records.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inviteId", new Parameter("in", ids));
            List list = this.accessService.queryList(queryParam);
            Map<Long, MatLinkerAccessEntity> map = list.stream().collect(Collectors.toMap(x -> x.getInviteId(), x -> x, (v1, v2) -> v2));
            for (MatLinkerInviteVO vo : records) {
                if (!map.containsKey(vo.getId())) continue;
                MatLinkerAccessEntity access = map.get(vo.getId());
                vo.setAccessId(access.getId());
                vo.setUserType(access.getUserType());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MatLinkerInvite-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatLinkerInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatLinkerInviteVO>> refMatLinkerInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatLinkerInviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/updateBillStatus"})
    @ResponseBody
    public CommonResponse<String> updateBillStatus(@RequestBody MatLinkerInviteVO vo) {
        String msg = this.service.updateBillStatus(vo);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

