/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"matSupplier"})
public class MatSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatSupplierVO> saveOrUpdate(@RequestBody MatSupplierVO saveOrUpdateVO) {
        MatSupplierVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MatSupplierVO> queryDetail(Long id) {
        MatSupplierEntity entity = (MatSupplierEntity)((Object)this.service.selectById(id));
        MatSupplierVO vo = (MatSupplierVO)BeanMapper.map((Object)((Object)entity), MatSupplierVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MatSupplierVO matSupplierVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List rerords = BeanMapper.mapList((Iterable)list, MatSupplierVO.class);
        rerords.forEach(vo -> vo.setType((String)PlanConstant.SUPPLIER_TYPE.get(vo.getType())));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", rerords);
        ExcelExport.getInstance().export("MatSupplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMatSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierVO>> refMatSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("legalPerson");
        fuzzyFields.add("companyGrade");
        fuzzyFields.add("corpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)) && _con.containsKey((Object)"projectId")) {
            List<Long> supplierIds = this.service.getSignConSupplierIds(_con.getLong("projectId"));
            this.logger.info("\u67e5\u8be2\u9879\u76eeid-{}\u4e0b\u7b7e\u8ba2\u5408\u540c\u4f9b\u5e94\u5546\u5217\u8868\uff1a{}", (Object)_con.getLong("projectId"), (Object)JSONObject.toJSONString(supplierIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            if (CollectionUtils.isNotEmpty(supplierIds)) {
                param.getParams().put("id", new Parameter("in", supplierIds));
            } else {
                Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
                pageData.setRecords(new ArrayList());
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
            }
        }
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/syncToErp"})
    @ResponseBody
    public CommonResponse<String> syncToErp(@RequestBody SupplierSyncErpParamVO paramVO) {
        UserContext user = this.sessionManager.getUserContext();
        paramVO.setOperatorId(user.getUserId());
        paramVO.setOperatorName(user.getUserName());
        String msg = this.service.syncSupplierChangeToErp(paramVO);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetailBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MatSupplierEntity> queryDetailBill(HttpServletRequest request) {
        return this.service.queryDetailBill(request);
    }

    @PostMapping(value={"/syncSupplierErpSid"})
    @ResponseBody
    public CommonResponse<String> syncSupplierErpSid(@RequestBody Long supplierId) {
        this.service.syncSupplierErpSid(supplierId);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getSupErpInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getSupErpInfo(@RequestParam Long supplierId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getSupErpInfo(supplierId));
    }
}

