/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zds.archive.bean.AdministrativeAreaEntity;
import com.ejianc.business.zds.archive.bean.BankCategoryEntity;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.service.IAdministrativeAreaService;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAttachesService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierBankService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zdsMatSupSync"})
public class ZdsMatSupSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierService service;
    @Autowired
    private IMatLinkerService matLinkerService;
    @Autowired
    private IMatSupplierAttachesService attachesService;
    @Autowired
    private IMatSupplierBankService supplierBankService;
    @Autowired
    private IBankService bankService;
    private static final String ERP_MAT_SUPPLIER_UPDATE_URL = "/cefoc/yql/MESupplierList";
    @Autowired
    private IAdministrativeAreaService areaService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMatSupplierMaterialInfoService materialInfoService;
    @Autowired
    private IBankCategoryService bankCategoryService;
    @Autowired
    IZDSBrandApi brandApi;

    @PostMapping(value={"/syncZdsMatSupplier"})
    @ResponseBody
    public CommonResponse<String> syncZdsMatSupplier(@RequestBody JSONObject params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        HashMap<String, Object> param = new HashMap<String, Object>();
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL;
        JSONObject reqJson = null;
        Object pageData = null;
        String reqDateStr = null;
        if (null == params.get((Object)"beginDate") || null == params.get((Object)"endDate")) {
            if (!"all".equals(params.getString("range"))) {
                reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays((Date)new Date(), (int)-1));
                param.put("BeginDateTime", reqDateStr + " 00:00:00");
                param.put("EndDateTime", reqDateStr + " 23:59:59");
            }
        } else {
            param.put("BeginDateTime", params.getString("beginDate"));
            param.put("EndDateTime", params.getString("endDate"));
        }
        param.put("PageSize", 100);
        param.put("PageNum", 1);
        if (null != params.get((Object)"supplierSid")) {
            reqUrl = reqUrl + "?OID=" + params.getString("supplierSid");
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }
        try {
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers)});
                this.handleErpPage(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleErpPage(JSONObject dataJson) {
        List<MatSupplierEntity> dbList;
        List<AdministrativeAreaEntity> dbAreas;
        ArrayList<MatSupplierEntity> supList = new ArrayList<MatSupplierEntity>();
        ArrayList<MatLinkerEntity> linkerList = new ArrayList<MatLinkerEntity>();
        ArrayList<MatSupplierMaterialInfoEntity> materialList = new ArrayList<MatSupplierMaterialInfoEntity>();
        ArrayList<MatSupplierBankEntity> bankList = new ArrayList<MatSupplierBankEntity>();
        ArrayList<MatSupplierAttachesEntity> attachList = new ArrayList<MatSupplierAttachesEntity>();
        HashSet<String> areaNames = new HashSet<String>();
        HashSet<String> copSIds = new HashSet<String>();
        MatSupplierEntity tmpSupEntity = null;
        Object tmpLinkerEntity = null;
        JSONObject tmpSupJson = null;
        ArrayList tmpIds = new ArrayList();
        ArrayList tmpSIds = new ArrayList();
        ArrayList names = new ArrayList();
        HashMap<String, MatSupplierEntity> mapSourceMap = new HashMap<String, MatSupplierEntity>();
        HashMap<String, List<MatLinkerEntity>> linkerMap = new HashMap<String, List<MatLinkerEntity>>();
        HashMap<String, List<MatSupplierMaterialInfoEntity>> materialInfoMap = new HashMap<String, List<MatSupplierMaterialInfoEntity>>();
        HashMap<Long, List<MatLinkerEntity>> dbLinkerMap = new HashMap<Long, List<MatLinkerEntity>>();
        HashMap<Long, List<MatSupplierBankEntity>> dbBankMap = new HashMap<Long, List<MatSupplierBankEntity>>();
        HashMap<Long, List<MatSupplierAttachesEntity>> dbAttachMap = new HashMap<Long, List<MatSupplierAttachesEntity>>();
        HashMap<Long, List<MatSupplierMaterialInfoEntity>> dbMaterialMap = new HashMap<Long, List<MatSupplierMaterialInfoEntity>>();
        HashMap<String, List<MatSupplierBankEntity>> bankMap = new HashMap<String, List<MatSupplierBankEntity>>();
        HashMap<String, List<MatSupplierAttachesEntity>> attachMap = new HashMap<String, List<MatSupplierAttachesEntity>>();
        HashMap<String, AdministrativeAreaEntity> areaMap = new HashMap<String, AdministrativeAreaEntity>();
        HashMap orgMap = new HashMap();
        JSONArray supplierArr = dataJson.getJSONArray("MESupplierList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546\u6570\u636e\uff1a{}\u6761", (Object)supplierArr.size());
        if (supplierArr.size() == 0) {
            this.logger.info("\u5f85\u5904\u7406\u4f9b\u5e94\u5546\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        for (Object obj : supplierArr) {
            tmpSupJson = (JSONObject)obj;
            tmpSupEntity = new MatSupplierEntity();
            tmpSupEntity.setThirdSourceId(tmpSupJson.getString("C_PS_MESupplierInfoOID"));
            if (null != tmpSupJson.get((Object)"YQL_SID") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("YQL_SID"))) {
                tmpSupEntity.setId(Long.valueOf(tmpSupJson.getString("YQL_SID")));
            }
            tmpSupEntity.setMemo(tmpSupJson.getString("Memo"));
            tmpSupEntity.setName(tmpSupJson.getString("Company_Name"));
            tmpSupEntity.setLegalPerson(tmpSupJson.getString("Company_LegalPerson"));
            tmpSupEntity.setCompanyType(ErpCompanyTypeEnums.getByCode((String)tmpSupJson.getString("CompanyStyle")));
            tmpSupEntity.setRegisteredCapitalStr(tmpSupJson.getString("RegistrationCapital"));
            tmpSupEntity.setPaidCapitalStr(tmpSupJson.getString("Paidincapital"));
            tmpSupEntity.setBusinessStatus(tmpSupJson.getString("regStatus"));
            try {
                if (null != tmpSupJson.get((Object)"OperatingPeriodStart") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodStart"))) {
                    tmpSupEntity.setBusinessStartDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodStart").split("T")[0]));
                }
                if (null != tmpSupJson.get((Object)"OperatingPeriodStartEnd") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OperatingPeriodStartEnd"))) {
                    tmpSupEntity.setBusinessEndDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("OperatingPeriodStartEnd").split("T")[0]));
                }
                if (null != tmpSupJson.get((Object)"Restricteddate") && StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("Restricteddate"))) {
                    tmpSupEntity.setRestrictDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpSupJson.getString("Restricteddate").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a{}, ", (Object)tmpSupJson.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)e);
            }
            tmpSupEntity.setRegisteredAddress(tmpSupJson.getString("Company_Address"));
            tmpSupEntity.setSocialCreditCode(tmpSupJson.getString("RegistrationCode"));
            tmpSupEntity.setBusinessScope(tmpSupJson.getString("OperatingRange"));
            tmpSupEntity.setCode(tmpSupJson.getString("Ma_id"));
            tmpSupEntity.setTaxCreditLevel(ErpTaxCreditLevelEnum.getByCode((String)tmpSupJson.getString("Taxcreditrating")));
            tmpSupEntity.setDisposableState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsitaOneTimeUse")) ? Integer.valueOf("true".equals(tmpSupJson.getString("IsitaOneTimeUse").toLowerCase()) ? 1 : 0) : null);
            tmpSupEntity.setDisposableReason(tmpSupJson.getString("ReasonforOneTimeUse"));
            tmpSupEntity.setSealState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsSupportES")) ? ("true".equals(tmpSupJson.getString("IsSupportES").toLowerCase()) ? "1" : "0") : null);
            tmpSupEntity.setPoState(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("IsPoSupplier")) ? Integer.valueOf("true".equals(tmpSupJson.getString("IsPoSupplier").toLowerCase()) ? 1 : 0) : null);
            tmpSupEntity.setCompanyGrade(tmpSupJson.getString("Company_Level"));
            tmpSupEntity.setCompanyState(tmpSupJson.getString("CompanyStatus"));
            tmpSupEntity.setSysLastUpd(tmpSupJson.getString("SYS_LAST_UPD"));
            tmpSupEntity.setErpCreatorSid(tmpSupJson.getString("SYS_CreatedBy"));
            tmpSupEntity.setErpRegisterName(tmpSupJson.getString("Register_Name"));
            tmpSupEntity.setCoordination("0");
            tmpSupEntity.setCorpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpErpName(tmpSupJson.getString("OwnerDept"));
            tmpSupEntity.setCorpSid(StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("OwnerDeptSid")) ? tmpSupJson.getString("OwnerDeptSid").toLowerCase() : null);
            tmpSupEntity.setType(PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.containsKey(tmpSupJson.getString("EntryDept")) ? (String)PlanConstant.ERP_MAT_INFO_TYPE_TO_EL_MAPPING.get(tmpSupJson.getString("EntryDept")) : "");
            tmpSupEntity.setErpType(tmpSupJson.getString("EntryDept"));
            tmpSupEntity.setIntentId(null);
            tmpSupEntity.setIntentName(null);
            if (StringUtils.isNotBlank((CharSequence)tmpSupJson.getString("SupplyArea"))) {
                if (tmpSupJson.getString("SupplyArea").indexOf(",") > 0) {
                    this.logger.info("\u4f9b\u5e94\u5546-[name-{},code-{},sid-{}]\u4e1a\u52a1\u533a\u57df[{}]\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u505a\u540c\u6b65\uff01", new Object[]{tmpSupEntity.getName(), tmpSupEntity.getCode(), tmpSupEntity.getThirdSourceId(), tmpSupJson.getString("SupplyArea")});
                }
                tmpSupEntity.setIntentName(tmpSupJson.getString("SupplyArea").replaceAll("\\|", ","));
                if (tmpSupEntity.getIntentName().endsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(0, tmpSupEntity.getIntentName().length() - 1));
                }
                if (tmpSupEntity.getIntentName().startsWith(",")) {
                    tmpSupEntity.setIntentName(tmpSupEntity.getIntentName().substring(1));
                }
                areaNames.addAll(Arrays.asList(tmpSupEntity.getIntentName().split(",")));
            }
            tmpSupEntity.setCompanyCharacter(PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.containsKey(tmpSupJson.getString("TypeLabel")) ? (String)PlanConstant.ERP_MAT_TYPE_LABEL_TO_EL_MAPPING.get(tmpSupJson.getString("TypeLabel")) : null);
            if (null == tmpSupEntity.getId()) {
                tmpSupEntity.setId(IdWorker.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getCorpSid())) {
                copSIds.add(tmpSupEntity.getCorpSid());
            }
            mapSourceMap.put(tmpSupEntity.getThirdSourceId(), tmpSupEntity);
        }
        if (CollectionUtils.isNotEmpty(areaNames) && CollectionUtils.isNotEmpty(dbAreas = this.areaService.getAllByNames(new ArrayList<String>(areaNames)))) {
            for (AdministrativeAreaEntity area : dbAreas) {
                areaMap.put(area.getName(), area);
            }
        }
        if (CollectionUtils.isNotEmpty(copSIds)) {
            CommonResponse orgResp = this.orgApi.findAllBySourceIds(new ArrayList(copSIds));
            if (!orgResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7SId-{}\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(copSIds), (Object)JSONObject.toJSONString((Object)orgResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)orgResp.getData()))) {
                orgMap.putAll(((List)orgResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), Function.identity())));
            }
        }
        if (null != dataJson.get((Object)"ContactList") && dataJson.getJSONArray("ContactList").size() > 0) {
            this.handleLinker(linkerMap, dataJson.getJSONArray("ContactList"));
        }
        if (null != dataJson.get((Object)"ArchivesList") && dataJson.getJSONArray("ArchivesList").size() > 0) {
            this.handleArchive(attachMap, dataJson.getJSONArray("ArchivesList"));
        }
        if (null != dataJson.get((Object)"BankList") && dataJson.getJSONArray("BankList").size() > 0) {
            this.handleBank(bankMap, dataJson.getJSONArray("BankList"));
        }
        if (null != dataJson.get((Object)"SupplyList") && dataJson.getJSONArray("SupplyList").size() > 0) {
            this.handleMaterialInfo(materialInfoMap, dataJson.getJSONArray("SupplyList"));
        }
        if (CollectionUtils.isNotEmpty(dbList = this.service.getAllByThirdSourceIds(new ArrayList<String>(mapSourceMap.keySet())))) {
            List<Long> supplierIds = dbList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MatLinkerEntity> linkers = this.matLinkerService.getAllBySupplierIds(supplierIds, null);
            dbLinkerMap.putAll(linkers.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(MatLinkerEntity::getSupplierId)));
            List<MatSupplierMaterialInfoEntity> materials = this.materialInfoService.getAllBySupplierIds(supplierIds);
            dbMaterialMap.putAll(materials.stream().filter(item -> null != item.getInfoThirdSourceId()).collect(Collectors.groupingBy(MatSupplierMaterialInfoEntity::getSupplierId)));
            List<MatSupplierBankEntity> dbBankList = this.supplierBankService.getAllBySupplierIds(supplierIds);
            dbBankMap.putAll(dbBankList.stream().filter(item -> null != item.getBankThirdSourceId()).collect(Collectors.groupingBy(MatSupplierBankEntity::getSupplierId)));
            List<MatSupplierAttachesEntity> dbAttachList = this.attachesService.getAllBySupplierIds(supplierIds);
            dbAttachMap.putAll(dbAttachList.stream().filter(item -> null != item.getThirdSourceId()).collect(Collectors.groupingBy(MatSupplierAttachesEntity::getSupplierId)));
            for (MatSupplierEntity dbSupplier : dbList) {
                List<Object> saveAttaches;
                tmpSupEntity = (MatSupplierEntity)((Object)mapSourceMap.get(dbSupplier.getThirdSourceId()));
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    names.clear();
                    Arrays.asList(tmpSupEntity.getIntentName().split(",")).stream().forEach(item -> {
                        if (areaMap.containsKey(item)) {
                            tmpIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getId().toString());
                            tmpSIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getSourceId());
                            names.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getName());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(tmpIds)) {
                        tmpSupEntity.setIntentId(StringUtils.join(tmpIds, (String)","));
                        tmpSupEntity.setIntentSid(StringUtils.join(tmpSIds, (String)","));
                        tmpSupEntity.setIntentName(StringUtils.join(names, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getCorpSid()) && orgMap.containsKey(tmpSupEntity.getCorpSid())) {
                    tmpSupEntity.setCorpId(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getId());
                    tmpSupEntity.setCorpName(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getName());
                    tmpSupEntity.setCorpCode(((OrgVO)orgMap.get(tmpSupEntity.getCorpSid())).getCode());
                }
                if (StringUtils.isNotBlank((CharSequence)tmpSupEntity.getErpRegisterName()) && StringUtils.isBlank((CharSequence)dbSupplier.getErpRegisterName())) {
                    dbSupplier.setErpRegisterName(tmpSupEntity.getErpRegisterName());
                }
                if (null == dbSupplier.getBusinessEndDate() && null != tmpSupEntity.getBusinessEndDate()) {
                    dbSupplier.setBusinessEndDate(tmpSupEntity.getBusinessEndDate());
                }
                if (null == dbSupplier.getBusinessStartDate() && null != tmpSupEntity.getBusinessStartDate()) {
                    dbSupplier.setBusinessStartDate(tmpSupEntity.getBusinessStartDate());
                }
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getDisposableReason());
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade());
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState());
                dbSupplier.setIntentId(tmpSupEntity.getIntentId());
                dbSupplier.setIntentName(tmpSupEntity.getIntentName());
                dbSupplier.setIntentSid(tmpSupEntity.getIntentSid());
                dbSupplier.setCompanyCharacter(tmpSupEntity.getCompanyCharacter());
                dbSupplier.setCorpSid(tmpSupEntity.getCorpSid());
                dbSupplier.setCorpName(tmpSupEntity.getCorpName());
                dbSupplier.setCorpId(tmpSupEntity.getCorpId());
                dbSupplier.setCorpCode(tmpSupEntity.getCorpCode());
                dbSupplier.setCorpErpName(tmpSupEntity.getCorpErpName());
                dbSupplier.setType(tmpSupEntity.getType());
                dbSupplier.setSysLastUpd(tmpSupEntity.getSysLastUpd());
                dbSupplier.setErpType(tmpSupEntity.getErpType());
                dbSupplier.setErpCreatorSid(tmpSupEntity.getErpCreatorSid());
                dbSupplier.setDisposableState(tmpSupEntity.getDisposableState());
                dbSupplier.setDisposableReason(tmpSupEntity.getCompanyGrade());
                dbSupplier.setSealState(tmpSupEntity.getSealState());
                dbSupplier.setPoState(tmpSupEntity.getPoState());
                dbSupplier.setCompanyGrade(tmpSupEntity.getCompanyGrade());
                dbSupplier.setCompanyState(tmpSupEntity.getCompanyState());
                supList.add(dbSupplier);
                ArrayList saveLinkers = linkerMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)linkerMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                ArrayList saveMaterials = materialInfoMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)materialInfoMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                ArrayList saveBanks = bankMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)bankMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                List<Object> list = saveAttaches = attachMap.containsKey(dbSupplier.getThirdSourceId()) ? ((List)attachMap.get(dbSupplier.getThirdSourceId())).stream().collect(Collectors.toList()) : new ArrayList();
                if (CollectionUtils.isNotEmpty(saveLinkers)) {
                    HashMap sourceLinkers = dbLinkerMap.containsKey(dbSupplier.getId()) ? ((List)dbLinkerMap.get(dbSupplier.getId())).stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item)) : new HashMap();
                    MatLinkerEntity tmpLink = null;
                    for (MatLinkerEntity link2 : saveLinkers) {
                        if (sourceLinkers.containsKey(link2.getThirdSourceId())) {
                            tmpLink = (MatLinkerEntity)((Object)sourceLinkers.get(link2.getThirdSourceId()));
                            tmpLink.setIdCardType(link2.getIdCardType());
                            tmpLink.setIdCardId(link2.getIdCardId());
                            tmpLink.setName(link2.getName());
                            tmpLink.setMobileLinkPhone(link2.getMobileLinkPhone());
                            tmpLink.setLinkPhone(link2.getLinkPhone());
                            tmpLink.setElectronicMail(link2.getElectronicMail());
                            tmpLink.setAddress(link2.getAddress());
                            tmpLink.setLinkerStatus(link2.getLinkerStatus());
                            if (null != link2.getUserType()) {
                                tmpLink.setUserType(link2.getUserType());
                            }
                            linkerList.add(tmpLink);
                            continue;
                        }
                        link2.setSupplierName(dbSupplier.getName());
                        link2.setSupplierCode(dbSupplier.getCode());
                        link2.setSupplierId(dbSupplier.getId());
                        link2.setDateType(0);
                        link2.setChangeVersion(0);
                        if (null == link2.getId()) {
                            link2.setId(IdWorker.getId());
                            link2.setSourceId(dbSupplier.getId());
                            link2.setSourceDetailId(link2.getId());
                        }
                        linkerList.add(link2);
                    }
                }
                if (CollectionUtils.isNotEmpty(saveMaterials)) {
                    HashMap sourceMaterials = dbMaterialMap.containsKey(dbSupplier.getId()) ? ((List)dbMaterialMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInfoThirdSourceId())).collect(Collectors.toMap(item -> item.getInfoThirdSourceId(), item -> item)) : new HashMap();
                    MatSupplierMaterialInfoEntity tmpMaterial = null;
                    for (MatSupplierMaterialInfoEntity material2 : saveMaterials) {
                        if (sourceMaterials.containsKey(material2.getInfoThirdSourceId())) {
                            tmpMaterial = (MatSupplierMaterialInfoEntity)((Object)sourceMaterials.get(material2.getInfoThirdSourceId()));
                            tmpMaterial.setMaterialName(material2.getMaterialName());
                            tmpMaterial.setMaterialSid(material2.getMaterialSid());
                            tmpMaterial.setBrandName(material2.getBrandName());
                            tmpMaterial.setBrandSid(material2.getBrandSid());
                            if (null == tmpMaterial.getBrandId() && null != material2.getBrandId()) {
                                tmpMaterial.setBrandId(material2.getBrandId());
                            }
                            tmpMaterial.setPropertyValue(material2.getPropertyValue());
                            tmpMaterial.setCertification(material2.getCertification());
                            tmpMaterial.setStartTime(material2.getStartTime());
                            tmpMaterial.setTerminalTime(material2.getTerminalTime());
                            tmpMaterial.setAffiliatedManufacturer(material2.getAffiliatedManufacturer());
                            tmpMaterial.setAffiliatedProjectName(material2.getAffiliatedProjectName());
                            tmpMaterial.setAffiliatedProjectSid(material2.getAffiliatedProjectSid());
                            materialList.add(tmpMaterial);
                            continue;
                        }
                        if (null == material2.getId()) {
                            material2.setId(IdWorker.getId());
                            material2.setSourceId(dbSupplier.getId());
                            material2.setSourceDetailId(material2.getId());
                        }
                        material2.setEnableStatus(PlanConstant.INTEGER_YES);
                        material2.setSupplierId(dbSupplier.getId());
                        materialList.add(material2);
                    }
                }
                if (CollectionUtils.isNotEmpty(saveBanks)) {
                    HashMap sourceBank = dbBankMap.containsKey(dbSupplier.getId()) ? ((List)dbBankMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBankThirdSourceId())).collect(Collectors.toMap(item -> item.getBankThirdSourceId(), item -> item)) : new HashMap();
                    MatSupplierBankEntity tmpBank = null;
                    for (MatSupplierBankEntity bank2 : saveBanks) {
                        if (sourceBank.containsKey(bank2.getBankThirdSourceId())) {
                            tmpBank = (MatSupplierBankEntity)((Object)sourceBank.get(bank2.getBankThirdSourceId()));
                            tmpBank.setBankNumber(bank2.getBankNumber());
                            tmpBank.setNumberType(bank2.getNumberType());
                            tmpBank.setBankName(bank2.getBankName());
                            tmpBank.setBankType(bank2.getBankType());
                            tmpBank.setProvince(bank2.getProvince());
                            tmpBank.setCity(bank2.getCity());
                            tmpBank.setOpenBank(bank2.getOpenBank());
                            tmpBank.setBankLineNumber(bank2.getBankLineNumber());
                            if (StringUtils.isBlank((CharSequence)tmpBank.getBankSid()) && StringUtils.isNotBlank((CharSequence)bank2.getBankSid())) {
                                tmpBank.setBankSid(bank2.getBankSid());
                            }
                            if (StringUtils.isBlank((CharSequence)tmpBank.getBankCategorySid()) && StringUtils.isNotBlank((CharSequence)bank2.getBankCategorySid())) {
                                tmpBank.setBankCategorySid(bank2.getBankCategorySid());
                            }
                            bankList.add(tmpBank);
                            continue;
                        }
                        bank2.setSupplierId(dbSupplier.getId());
                        if (null == bank2.getId()) {
                            bank2.setId(IdWorker.getId());
                            bank2.setSourceId(dbSupplier.getId());
                            bank2.setSourceDetailId(bank2.getId());
                        }
                        bankList.add(bank2);
                    }
                }
                if (dbAttachMap.containsKey(dbSupplier.getId())) {
                    Map<String, MatSupplierAttachesEntity> sourceAttach = ((List)dbAttachMap.get(dbSupplier.getId())).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getThirdSourceId())).collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
                    saveAttaches = saveAttaches.stream().filter(item -> !sourceAttach.containsKey(item.getThirdSourceId())).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty(saveAttaches)) {
                    for (MatSupplierAttachesEntity attach2 : saveAttaches) {
                        attach2.setSupplierId(dbSupplier.getId());
                        if (null == attach2.getId()) {
                            attach2.setId(IdWorker.getId());
                            attach2.setSourceId(dbSupplier.getId());
                            attach2.setSourceDetailId(attach2.getId());
                        }
                        attachList.add(attach2);
                    }
                }
                linkerMap.remove(dbSupplier.getThirdSourceId());
                materialInfoMap.remove(dbSupplier.getThirdSourceId());
                mapSourceMap.remove(dbSupplier.getThirdSourceId());
                attachMap.remove(dbSupplier.getThirdSourceId());
                bankMap.remove(dbSupplier.getThirdSourceId());
            }
        }
        if (!mapSourceMap.isEmpty()) {
            for (MatSupplierEntity erpSupplier : mapSourceMap.values()) {
                if (StringUtils.isNotBlank((CharSequence)erpSupplier.getIntentName())) {
                    tmpIds.clear();
                    tmpSIds.clear();
                    Arrays.asList(erpSupplier.getIntentName().split(",")).stream().forEach(item -> {
                        if (areaMap.containsKey(item)) {
                            tmpIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getId().toString());
                            tmpSIds.add(((AdministrativeAreaEntity)((Object)((Object)areaMap.get(item)))).getSourceId());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(tmpIds)) {
                        erpSupplier.setIntentId(StringUtils.join(tmpIds, (String)","));
                        erpSupplier.setIntentSid(StringUtils.join(tmpSIds, (String)","));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)erpSupplier.getCorpSid()) && orgMap.containsKey(erpSupplier.getCorpSid())) {
                    erpSupplier.setCorpId(((OrgVO)orgMap.get(erpSupplier.getCorpSid())).getId());
                    erpSupplier.setCorpName(((OrgVO)orgMap.get(erpSupplier.getCorpSid())).getName());
                }
                supList.add(erpSupplier);
                if (linkerMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)linkerMap.get(erpSupplier.getThirdSourceId())).forEach(link -> {
                        link.setSupplierName(erpSupplier.getName());
                        link.setSupplierCode(erpSupplier.getCode());
                        link.setSupplierId(erpSupplier.getId());
                        link.setDateType(0);
                        link.setChangeVersion(0);
                        linkerList.add((MatLinkerEntity)((Object)link));
                    });
                }
                if (bankMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)bankMap.get(erpSupplier.getThirdSourceId())).forEach(bank -> {
                        bank.setSupplierId(erpSupplier.getId());
                        bankList.add((MatSupplierBankEntity)((Object)bank));
                    });
                }
                if (attachMap.containsKey(erpSupplier.getThirdSourceId())) {
                    ((List)attachMap.get(erpSupplier.getThirdSourceId())).forEach(attach -> {
                        attach.setSupplierId(erpSupplier.getId());
                        attachList.add((MatSupplierAttachesEntity)((Object)attach));
                    });
                }
                if (!materialInfoMap.containsKey(erpSupplier.getThirdSourceId())) continue;
                ((List)materialInfoMap.get(erpSupplier.getThirdSourceId())).forEach(material -> {
                    material.setSupplierId(erpSupplier.getId());
                    materialList.add((MatSupplierMaterialInfoEntity)((Object)material));
                });
            }
        }
        if (CollectionUtils.isNotEmpty(supList)) {
            this.logger.info("\u672c\u6b21\u66f4\u65b0\u4f9b\u5e94\u5546\u6570\u91cf\uff1a{}", (Object)supList.size());
            this.service.saveOrUpdateBatch(supList, supList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(linkerList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u6570\u91cf\uff1a{}", (Object)linkerList.size());
            this.matLinkerService.saveOrUpdateBatch(linkerList, linkerList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(bankList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u4f9b\u5e94\u5546\u94f6\u884c\u6570\u91cf\uff1a{}", (Object)bankList.size());
            this.supplierBankService.saveOrUpdateBatch(bankList, bankList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(attachList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u4f9b\u5e94\u5546\u9644\u4ef6\u6570\u91cf\uff1a{}", (Object)attachList.size());
            this.attachesService.saveOrUpdateBatch(attachList, attachList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(materialList)) {
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u4f9b\u5e94\u5546\u4f9b\u8d27\u5185\u5bb9\u6570\u91cf\uff1a{}", (Object)materialList.size());
            this.materialInfoService.saveOrUpdateBatch(materialList, materialList.size(), false);
        }
    }

    private void handleMaterialInfo(Map<String, List<MatSupplierMaterialInfoEntity>> materialInfoMap, JSONArray supplyList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u4f9b\u8d27\u5185\u5bb9\u6570\u636e:{}\u6761", (Object)supplyList.size());
        JSONObject tmpJson = null;
        MatSupplierMaterialInfoEntity materialInfoEntity = null;
        HashSet<String> brandSid = new HashSet<String>();
        ArrayList<MatSupplierMaterialInfoEntity> allInfo = new ArrayList<MatSupplierMaterialInfoEntity>();
        for (Object obj : supplyList) {
            tmpJson = (JSONObject)obj;
            materialInfoEntity = new MatSupplierMaterialInfoEntity();
            materialInfoEntity.setInfoThirdSourceId(tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
            materialInfoEntity.setMaterialName(tmpJson.getString("CompanyType"));
            materialInfoEntity.setMaterialSid(tmpJson.getString("CompanyType_Sid"));
            materialInfoEntity.setBrandName(tmpJson.getString("MainBrands"));
            materialInfoEntity.setBrandSid(tmpJson.getString("MainBrands_Sid"));
            materialInfoEntity.setPropertyValue(PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.containsKey(tmpJson.getString("PropertyCode")) ? (String)PlanConstant.ERP_TO_EL_MAT_MATERIAL_PROPERTY.get(tmpJson.getString("PropertyCode")) : tmpJson.getString("PropertyCode"));
            materialInfoEntity.setCertification("1".equals(tmpJson.getString("CertificationCode")) ? 2 : 1);
            if (StringUtils.isNotBlank((CharSequence)materialInfoEntity.getBrandSid())) {
                brandSid.add(materialInfoEntity.getBrandSid());
            }
            try {
                if (null != tmpJson.get((Object)"BeginTime") && StringUtils.isNotBlank((CharSequence)tmpJson.getString("BeginTime"))) {
                    materialInfoEntity.setStartTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpJson.getString("BeginTime").split("T")[0]));
                }
                if (null != tmpJson.get((Object)"EndTime") && StringUtils.isNotBlank((CharSequence)tmpJson.getString("EndTime"))) {
                    materialInfoEntity.setTerminalTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)tmpJson.getString("EndTime").split("T")[0]));
                }
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u8d27\u5185\u5bb9\u8d77\u6b62\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1astart-{},end-{}", (Object)tmpJson.getString("BeginTime"), (Object)tmpJson.getString("EndTime"));
            }
            materialInfoEntity.setAffiliatedManufacturer(StringUtils.isNotBlank((CharSequence)tmpJson.getString("AffiliatedCompany")) ? tmpJson.getString("AffiliatedCompany") : null);
            materialInfoEntity.setAffiliatedProjectName(tmpJson.getString("AffiliatedProject"));
            materialInfoEntity.setAffiliatedProjectSid(StringUtils.isNotBlank((CharSequence)tmpJson.getString("AccountingProjectSet_FK")) ? tmpJson.getString("AccountingProjectSet_FK") : null);
            materialInfoEntity.setSupplierSid(tmpJson.getString("MESupplierInfo_FK"));
            if (!materialInfoMap.containsKey(materialInfoEntity.getSupplierSid())) {
                materialInfoMap.put(materialInfoEntity.getSupplierSid(), new ArrayList());
            }
            materialInfoMap.get(materialInfoEntity.getSupplierSid()).add(materialInfoEntity);
            allInfo.add(materialInfoEntity);
        }
        if (CollectionUtils.isNotEmpty(brandSid)) {
            CommonResponse brandSourceResp = this.brandApi.getAllMapBySourceIds(new ArrayList(brandSid));
            if (!brandSourceResp.isSuccess() || MapUtils.isEmpty((Map)((Map)brandSourceResp.getData()))) {
                this.logger.error("\u6839\u636e\u54c1\u724csid-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25: {}", (Object)JSONObject.toJSONString(brandSid), (Object)JSONObject.toJSONString((Object)brandSourceResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                Map brandSourceMap = (Map)brandSourceResp.getData();
                for (MatSupplierMaterialInfoEntity info : allInfo) {
                    if (!StringUtils.isNotBlank((CharSequence)info.getBrandSid()) || !brandSourceMap.containsKey(info.getBrandSid())) continue;
                    info.setBrandId(((BrandVO)brandSourceMap.get(info.getBrandSid())).getId().toString());
                }
            }
        }
    }

    private void handleBank(Map<String, List<MatSupplierBankEntity>> bankMap, JSONArray bankList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u94f6\u884c\u6570\u636e\uff1a{}\u6761", (Object)bankList.size());
        JSONObject tmpBankJson = null;
        MatSupplierBankEntity bankEntity = null;
        HashSet<String> bankName = new HashSet<String>();
        HashSet<String> bankCategoryName = new HashSet<String>();
        HashSet<String> bankCategoryCode = new HashSet<String>();
        ArrayList<MatSupplierBankEntity> allBank = new ArrayList<MatSupplierBankEntity>();
        for (Object obj : bankList) {
            tmpBankJson = (JSONObject)obj;
            bankEntity = new MatSupplierBankEntity();
            bankEntity.setBankThirdSourceId(tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
            bankEntity.setBankNumber(tmpBankJson.getString("Contact_BankAccount"));
            bankEntity.setNumberType(null != tmpBankJson.getInteger("AccountType") ? Integer.valueOf(tmpBankJson.getInteger("AccountType") + 1) : null);
            bankEntity.setBankName(tmpBankJson.getString("SubBankName"));
            bankEntity.setBankType(tmpBankJson.getString("BankType"));
            bankEntity.setProvince(tmpBankJson.getString("Province"));
            bankEntity.setCity(tmpBankJson.getString("City"));
            bankEntity.setOpenBank(tmpBankJson.getString("Contact_Bank"));
            bankEntity.setBankLineNumber(tmpBankJson.getString("Contact_BankNumber"));
            bankEntity.setSupplierSid(tmpBankJson.getString("C_PS_MESupplierInfo_FK"));
            if (!bankMap.containsKey(bankEntity.getSupplierSid())) {
                bankMap.put(bankEntity.getSupplierSid(), new ArrayList());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getOpenBank())) {
                bankName.add(bankEntity.getOpenBank());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankName())) {
                bankCategoryName.add(bankEntity.getBankName());
            }
            if (StringUtils.isNotBlank((CharSequence)bankEntity.getBankType())) {
                bankCategoryCode.add(bankEntity.getBankType());
            }
            bankMap.get(bankEntity.getSupplierSid()).add(bankEntity);
            allBank.add(bankEntity);
        }
        Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(new ArrayList<String>(bankName));
        Map<String, BankCategoryEntity> bankCategoryNameMap = this.bankCategoryService.getAllMapByNames(new ArrayList<String>(bankCategoryName));
        Map<String, BankCategoryEntity> bankCategoryCodeMap = this.bankCategoryService.getAllMapByCodes(new ArrayList<String>(bankCategoryCode));
        for (MatSupplierBankEntity bankSub : allBank) {
            if (StringUtils.isNotBlank((CharSequence)bankSub.getOpenBank()) && bankNameMap.containsKey(bankSub.getOpenBank())) {
                bankSub.setBankId(bankNameMap.get(bankSub.getOpenBank()).getId());
                bankSub.setBankSid(bankNameMap.get(bankSub.getOpenBank()).getSourceId());
            }
            if (StringUtils.isNotBlank((CharSequence)bankSub.getBankName()) && bankCategoryNameMap.containsKey(bankSub.getBankName())) {
                bankSub.setBankCategorySid(bankCategoryNameMap.get(bankSub.getBankName()).getSourceId());
                if (StringUtils.isNotBlank((CharSequence)bankSub.getBankType())) {
                    bankSub.setBankType(bankCategoryNameMap.get(bankSub.getBankName()).getCode());
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankType()) || !bankCategoryCodeMap.containsKey(bankSub.getBankType()) || !StringUtils.isBlank((CharSequence)bankSub.getBankCategorySid())) continue;
            bankSub.setBankCategorySid(bankCategoryCodeMap.get(bankSub.getBankType()).getSourceId());
            if (!StringUtils.isNotBlank((CharSequence)bankSub.getBankName())) continue;
            bankSub.setBankName(bankCategoryCodeMap.get(bankSub.getBankType()).getName());
        }
    }

    private void handleArchive(Map<String, List<MatSupplierAttachesEntity>> attachMap, JSONArray archiveList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u9644\u4ef6\u6570\u636e\uff1a{}\u6761", (Object)archiveList.size());
        JSONObject tmpAttachJson = null;
        MatSupplierAttachesEntity attach = null;
        for (Object obj : archiveList) {
            tmpAttachJson = (JSONObject)obj;
            attach = new MatSupplierAttachesEntity();
            attach.setThirdSourceId(tmpAttachJson.getString("C_PS_ArchivesOID"));
            attach.setFileName(tmpAttachJson.getString("Attach_Name"));
            attach.setFileType(tmpAttachJson.getString("Attach_Extension"));
            attach.setType(tmpAttachJson.getString("Attach_Type"));
            attach.setFileUrl(tmpAttachJson.getString("AttachBase64"));
            attach.setSourceType(3);
            attach.setSupplierSid(tmpAttachJson.getString("C_PS_MESupplierInfo_FK"));
            if (!attachMap.containsKey(attach.getSupplierSid())) {
                attachMap.put(attach.getSupplierSid(), new ArrayList());
            }
            attachMap.get(attach.getSupplierSid()).add(attach);
        }
    }

    private void handleLinker(Map<String, List<MatLinkerEntity>> linkerMap, JSONArray contactList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)contactList.size());
        MatLinkerEntity tmpLinkerEntity = null;
        JSONObject tmpLinkerJson = null;
        for (Object obj : contactList) {
            tmpLinkerJson = (JSONObject)obj;
            tmpLinkerEntity = new MatLinkerEntity();
            tmpLinkerEntity.setIdCardType(ErpLinkerCardTypeEnum.getElCodeByCode((String)tmpLinkerJson.getString("IDType")));
            tmpLinkerEntity.setIdCardId(tmpLinkerJson.getString("IDCard"));
            tmpLinkerEntity.setName(tmpLinkerJson.getString("Company_Contact"));
            tmpLinkerEntity.setSupplierSid(tmpLinkerJson.getString("C_PS_MESupplierInfo_FK"));
            tmpLinkerEntity.setMobileLinkPhone(tmpLinkerJson.getString("Contact_Mobile"));
            tmpLinkerEntity.setLinkPhone(tmpLinkerJson.getString("Contact_Telephone"));
            tmpLinkerEntity.setElectronicMail(tmpLinkerJson.getString("Contact_Email"));
            tmpLinkerEntity.setAddress(tmpLinkerJson.getString("Contact_Address"));
            try {
                tmpLinkerEntity.setUserType(null != tmpLinkerJson.getInteger("ContactType") ? tmpLinkerJson.getInteger("ContactType") : null);
            }
            catch (Exception e) {
                tmpLinkerEntity.setUserType(null);
                this.logger.error("\u7269\u8d44\u8054\u7cfb\u4ebasid-{} \u8054\u7cfb\u4eba\u7c7b\u578b\u683c\u5f0f\u5316\u9519\u8bef\uff1a{}", (Object)tmpLinkerJson.getString("subA_oid"), (Object)tmpLinkerJson.getString("ContactType"));
            }
            tmpLinkerEntity.setThirdSourceId(tmpLinkerJson.getString("subA_oid"));
            tmpLinkerEntity.setCoordination("0");
            tmpLinkerEntity.setLinkerStatus(StringUtils.isNotBlank((CharSequence)tmpLinkerJson.getString("ContactState")) ? Integer.valueOf(tmpLinkerJson.getString("ContactState")) : null);
            tmpLinkerEntity.setEnableStatus(2);
            if (!linkerMap.containsKey(tmpLinkerEntity.getSupplierSid())) {
                linkerMap.put(tmpLinkerEntity.getSupplierSid(), new ArrayList());
            }
            linkerMap.get(tmpLinkerEntity.getSupplierSid()).add(tmpLinkerEntity);
        }
    }

    private String getDatePattern(String operatingPeriodStartEnd) {
        StringBuilder sp = new StringBuilder();
        String[] dateArr = operatingPeriodStartEnd.split(" ");
        String[] yearDateArr = dateArr[0].split("/");
        sp.append("yyyy/M");
        if (yearDateArr[1].length() > 1) {
            sp.append("M");
        }
        sp.append("/d");
        if (yearDateArr[1].length() > 1) {
            sp.append("d");
        }
        return sp.toString();
    }
}

