/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/matSupplierApi/"})
public class MatSupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierService supplierService;

    @GetMapping(value={"getOneBySourceId"})
    CommonResponse<MatSupplierVO> getOneBySourceId(@RequestParam(value="sourceId") String sourceId, @RequestParam(required=false) String supplierType) {
        MatSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"third_source_id", (Object)sourceId);
        MatSupplierEntity e = (MatSupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (MatSupplierVO)BeanMapper.map((Object)((Object)e), MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllBySourceIds"})
    CommonResponse<List<MatSupplierVO>> getAllBySourceIds(@RequestBody JSONObject params) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"third_source_id", (Collection)params.getJSONArray("sourceIds"));
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneByCode"})
    CommonResponse<MatSupplierVO> getOneByCode(@RequestParam(value="code") String code) {
        MatSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"code", (Object)code);
        MatSupplierEntity e = (MatSupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (MatSupplierVO)BeanMapper.map((Object)((Object)e), MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllByCodes"})
    CommonResponse<List<MatSupplierVO>> getAllByCodes(@RequestBody List<String> code) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"code", code);
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getByTenantId"})
    CommonResponse<MatSupplierVO> getByTenantId(@RequestParam Long tenantId) {
        MatSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"tenant", (Object)tenantId);
        MatSupplierEntity e = (MatSupplierEntity)((Object)this.supplierService.getOne((Wrapper)query));
        if (null != e) {
            resp = (MatSupplierVO)BeanMapper.map((Object)((Object)e), MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getByTenantIds"})
    CommonResponse<List<MatSupplierVO>> getByTenantIds(@RequestParam List<Long> tenantIds) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"tenant", tenantIds);
        List eList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getOneById"})
    CommonResponse<MatSupplierVO> getOneById(@RequestParam(value="id") Long id) {
        MatSupplierVO resp = null;
        MatSupplierEntity e = (MatSupplierEntity)((Object)this.supplierService.selectById(id));
        if (null != e) {
            resp = (MatSupplierVO)BeanMapper.map((Object)((Object)e), MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }

    @PostMapping(value={"getAllByIds"})
    CommonResponse<List<MatSupplierVO>> getAllByIds(@RequestBody List<Long> ids) {
        List resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = this.supplierService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MatSupplierVO.class);
        }
        return CommonResponse.success(resp);
    }
}

