/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerInviteEntity;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerInviteFlowEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatLinkerInviteMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteFlowService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteFlowVO;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matLinkerInviteService")
public class MatLinkerInviteServiceImpl
extends BaseServiceImpl<MatLinkerInviteMapper, MatLinkerInviteEntity>
implements IMatLinkerInviteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MAT_LINKER_INVITE";
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u9080\u8bf7.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u9080\u8bf7.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matLinkerInvite/syncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matLinkerInvite/syncBill";
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMatLinkerInviteFlowService flowService;
    @Autowired
    private IMatLinkerAccessService accessService;
    @Autowired
    private IMatLinkerService linkerService;

    @Override
    public MatLinkerInviteVO saveOrUpdate(MatLinkerInviteVO saveOrUpdateVO) {
        MatLinkerInviteEntity entity = (MatLinkerInviteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatLinkerInviteEntity.class));
        this.validateMobile(entity.getSupplierId(), entity.getLinkPhone(), entity.getId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setInviterPhone(this.sessionManager.getUserContext().getUserMobile());
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushBillToSupCenter(entity);
        return (MatLinkerInviteVO)BeanMapper.map((Object)((Object)entity), MatLinkerInviteVO.class);
    }

    private Boolean validateMobile(Long supplierId, String linkPhone, Long id) {
        List inviteList;
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("linkPhone", new Parameter("eq", (Object)linkPhone));
        param.getParams().put("status", new Parameter("ne", (Object)"5"));
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(inviteList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u751f\u6210\u9080\u8bf7\u4e2d\u94fe\u63a5\u3010" + ((MatLinkerInviteEntity)((Object)inviteList.get(0))).getBillCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9080\u8bf7\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        queryParam.getParams().put("mobileLinkPhone", new Parameter("eq", (Object)linkPhone));
        List linkerList = this.linkerService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)linkerList)) {
            throw new BusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u751f\u6210\u6863\u6848\u3010" + ((MatLinkerEntity)((Object)linkerList.get(0))).getCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9080\u8bf7\uff01");
        }
        return true;
    }

    @Override
    public boolean pushBillToSupCenter(MatLinkerInviteEntity entity) {
        Long sourceId = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), SYSTEM_ID, BILL_TYPE, BILL_NAME, "/ejc-zdssupbusiness-web/openapi/matLinkerInvite/syncBill");
        if (sourceId != null) {
            entity.setSourceId(sourceId);
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.sendEmail(entity);
            this.sendSms(entity);
            MatLinkerInviteFlowVO flow = new MatLinkerInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType("1".toString());
            this.flowService.saveOrUpdate(flow);
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u65b9\u670d\u52a1\u5931\u8d25", (Object)BILL_NAME, (Object)entity.getId());
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.saveOrUpdate((Object)entity, false);
        return true;
    }

    @Override
    public String updateBillStatus(MatLinkerInviteVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(MatLinkerInviteVO vo, Boolean saveFlag) {
        MatLinkerInviteFlowEntity flow;
        if (vo.getId() == null) {
            return null;
        }
        MatLinkerInviteEntity entity = (MatLinkerInviteEntity)((Object)super.selectById((Serializable)vo.getId()));
        this.pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        if (!saveFlag.booleanValue()) {
            this.pushSupUtil.updateBillStatus((JSONObject)JSONObject.toJSON((Object)((Object)entity)), "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, "/ejc-zdssupbusiness-web/openapi/matLinkerInvite/syncBill", null);
        }
        if ("6".equals(vo.getStatus())) {
            this.sendApproveEmail(entity);
            this.sendApproveSms(entity);
        }
        if ("4".equals(vo.getStatus())) {
            this.sendBackEmail(entity);
        }
        super.saveOrUpdate((Object)entity);
        if (saveFlag.booleanValue()) {
            flow = new MatLinkerInviteFlowEntity();
            flow.setInviteId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getInviterId());
            flow.setOperatorName(vo.getInviterName());
            flow.setOperateTime(new Date());
            this.flowService.saveOrUpdate((Object)flow, false);
        } else {
            flow = new MatLinkerInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType(StringUtils.isNotEmpty((CharSequence)vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            this.flowService.saveOrUpdate((MatLinkerInviteFlowVO)flow);
        }
        if ("4".equals(vo.getStatus())) {
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter("eq", (Object)entity.getId()));
            List list = this.accessService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
                this.accessService.removeByIds(ids, true);
            }
        }
        return null;
    }

    private void sendSms(MatLinkerInviteEntity entity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", entity.getInviteCode());
        params.put("name", entity.getInviterName());
        params.put("phone", entity.getInviterPhone());
        this.pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), "SMS_465340426", "\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5e73\u53f0", params);
    }

    private void sendEmail(MatLinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("\u4e2d\u7535\u56db\u516c\u53f8\u63d0\u9192\u60a8\u529e\u7406\u8054\u7cfb\u4eba\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u5b8c\u6210\u6ce8\u518c");
        content.append(entity.getInviteUrl());
        content.append("\uff0c\u8be5\u94fe\u63a5\u8bf7\u52ff\u5916\u4f20\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb:");
        content.append(entity.getInviterName());
        content.append("\uff0c\u624b\u673a\u53f7:");
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getLinkerName());
        this.pushSupUtil.sendEmail(null, "notice", "\u8054\u7cfb\u4eba\u9080\u8bf7\u90ae\u4ef6", content.toString(), params, entity.getInviteUrl(), null);
    }

    private void sendApproveSms(MatLinkerInviteEntity entity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "portal");
        params.put("name", entity.getLinkerName());
        params.put("phone", entity.getLinkPhone());
        this.pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), "SMS_465330440", "\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5e73\u53f0", params);
    }

    private void sendApproveEmail(MatLinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append(entity.getLinkerName());
        content.append("\uff0c\u60a8\u597d\uff0c\u606d\u559c\u60a8\u5b8c\u6210\u8054\u7cfb\u4eba\u6ce8\u518c\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5");
        String url = this.pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("\uff0c\u8fdb\u884c\u767b\u5f55\uff0c\u767b\u5f55\u8d26\u53f7:");
        content.append(entity.getLinkPhone());
        content.append("\uff0c\u9996\u6b21\u767b\u5f55\u91c7\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8fdb\u884c\u9a8c\u8bc1");
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getSupplierName());
        this.pushSupUtil.sendEmail(null, "notice", "\u8054\u7cfb\u4eba\u6ce8\u518c\u6210\u529f\u90ae\u4ef6", content.toString(), params, url, null);
    }

    private void sendBackEmail(MatLinkerInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("\u4e2d\u7535\u56db\u516c\u53f8\u5df2\u9a73\u56de\u4e86\u60a8\u529e\u7406\u7684\u8054\u7cfb\u4eba\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u91cd\u65b0\u6ce8\u518c");
        content.append(entity.getInviteUrl());
        content.append("\uff0c\u8be5\u94fe\u63a5\u8bf7\u52ff\u5916\u4f20\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getSupplierName());
        this.pushSupUtil.sendEmail(null, "notice", "\u8054\u7cfb\u4eba\u6ce8\u518c\u9a73\u56de\u90ae\u4ef6", content.toString(), params, entity.getInviteUrl(), null);
    }
}

