/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdssupplier.common.utils.DateUtil;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeFlowEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierChangeMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierHistoryEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierChangeMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeFlowService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierHistoryService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeFlowVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierHistoryAttachesVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierHistoryVO;
import com.ejianc.business.zdssupplier.utils.enterprise.dispatch.CompanyCheckFactory;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matSupplierChangeService")
public class MatSupplierChangeServiceImpl
extends BaseServiceImpl<MatSupplierChangeMapper, MatSupplierChangeEntity>
implements IMatSupplierChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_CHANGE";
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u53d8\u66f4.getName();
    private static final String sourceBillType = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u6863\u6848.getCode();
    private static final String targetBillType = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u53d8\u66f4.getCode();
    private static final String historyBillType = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u5386\u53f2.getCode();
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierChange/syncBillStatus";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IMatSupplierService supplierService;
    @Autowired
    private IMatSupplierHistoryService historyService;
    @Autowired
    private IMatSupplierChangeFlowService flowService;
    @Autowired
    private IMatSupplierChangeMaterialInfoService matSupplierChangeMaterialInfoService;
    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    @Override
    public MatSupplierChangeVO saveOrUpdate(MatSupplierChangeVO saveOrUpdateVO) {
        MatSupplierChangeEntity data;
        MatSupplierEntity supplier;
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatSupplierChangeEntity.class));
        if (null == entity.getId() ? !(supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(saveOrUpdateVO.getSupplierId()))).getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), supplier.getInvokeDate()) == 0 : !(data = (MatSupplierChangeEntity)((Object)super.selectById((Serializable)entity.getId()))).getName().equals(entity.getName()) && DateUtil.compareDate(entity.getInvokeDate(), data.getInvokeDate()) == 0) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u70b9\u51fb\u5929\u773c\u67e5\u540c\u6b65\u4f01\u4e1a\u4fe1\u606f\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        }
        super.saveOrUpdate((Object)entity, false);
        MatSupplierChangeVO vo = (MatSupplierChangeVO)BeanMapper.map((Object)((Object)entity), MatSupplierChangeVO.class);
        return vo;
    }

    @Override
    public MatSupplierChangeVO saveChangeBySupplierId(Long id) {
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(id));
        MatSupplierChangeEntity entity = EntityUtil.clearInvalidEntity(supplier, MatSupplierChangeEntity.class);
        entity.setSupplierId(id);
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        UserContext user = this.pushSupUtil.getUser();
        entity.setEmployeeId(user.getEmployeeId());
        entity.setEmployeeName(user.getEmployeeName());
        entity.setBillDate(new Date());
        super.saveOrUpdate((Object)entity, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplier.getId()), sourceBillType, "attachMgr", String.valueOf(entity.getId()), targetBillType, "attachMgr");
        Map<Long, MatSupplierChangeAttachesEntity> attachMap = entity.getAttachesList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        for (MatSupplierAttachesEntity source : supplier.getAttachesList()) {
            if (!attachMap.containsKey(source.getId())) continue;
            MatSupplierChangeAttachesEntity target = attachMap.get(source.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(source.getId()), sourceBillType, "file", String.valueOf(target.getId()), targetBillType, "file");
        }
        this.pushToHistory(entity.getSupplierId(), entity.getId());
        MatSupplierChangeVO resp = (MatSupplierChangeVO)BeanMapper.map((Object)((Object)entity), MatSupplierChangeVO.class);
        resp.setCorpSid(supplier.getCorpSid());
        resp.setCorpErpName(supplier.getCorpErpName());
        resp.setErpType(supplier.getErpType());
        return resp;
    }

    @Override
    public MatSupplierChangeVO TYCDetail(String supplierName, Long supplierId, Long id) {
        if (StringUtils.isEmpty((CharSequence)supplierName)) {
            throw new BusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BaseCompanyInfoVO company = CompanyCheckFactory.getInstance("TYCProcessor").getCompanyInfo(supplierName, null);
        if (null == company) {
            return new MatSupplierChangeVO();
        }
        MatSupplierChangeEntity entity = null;
        if (id != null) {
            entity = (MatSupplierChangeEntity)((Object)super.selectById((Serializable)id));
        }
        if (entity == null) {
            MatSupplierChangeVO vo = this.saveChangeBySupplierId(supplierId);
            entity = (MatSupplierChangeEntity)((Object)BeanMapper.map((Object)vo, MatSupplierChangeEntity.class));
        }
        entity.setName(supplierName);
        entity.setInvokeDate(new Date());
        entity.setSocialCreditCode(company.getSocialCreditCode());
        entity.setBusinessStatus(company.getBusinessStatus());
        entity.setRegisteredCapitalStr(company.getRegisteredCapitalStr());
        entity.setPaidCapitalStr(company.getPaidCapitalStr());
        entity.setBusinessScope(company.getBusinessScope());
        entity.setLegalPerson(company.getLegalPerson());
        entity.setRegisteredAddress(company.getRegisteredAddress());
        entity.setCompanyType(PushSupUtil.clearBracket(company.getCompanyType()));
        entity.setBusinessStartDate(company.getBusinessStartDate());
        entity.setBusinessEndDate(company.getBusinessEndDate());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
        List certList = company.getCertiList();
        super.saveOrUpdate((Object)entity, false);
        MatSupplierChangeVO vo = (MatSupplierChangeVO)BeanMapper.map((Object)((Object)entity), MatSupplierChangeVO.class);
        return vo;
    }

    @Override
    public Boolean validateRunning(Long supplierId, Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("id", new Parameter("ne", (Object)id));
        param.getParams().put("status", new Parameter("in", (Object)"2,3"));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set billCodes = list.stream().map(MatSupplierChangeEntity::getCode).collect(Collectors.toSet());
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u8fdb\u884c\u4e2d\u53d8\u66f4\u5355\u3010" + StringUtils.join(billCodes, (String)",") + "\u3011\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77\u53d8\u66f4!");
        }
        return true;
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        MatSupplierChangeEntity saveEntity = (MatSupplierChangeEntity)((Object)JSONObject.parseObject((String)transData, MatSupplierChangeEntity.class));
        this.validateRunning(saveEntity.getSupplierId(), saveEntity.getId());
        Long id = this.pushSupUtil.saveSyncBill(request, MatSupplierChangeEntity.class, BILL_TYPE, BILL_NAME, false);
        if (null == id) {
            throw new BusinessException("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01");
        }
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)super.selectById((Serializable)id));
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER.toString());
        List<MatSupplierChangeAttachesEntity> attachList = entity.getAttachesList();
        for (MatSupplierChangeAttachesEntity attach : attachList) {
            Long fileId = this.pushSupUtil.uploadFileFormNet(BILL_TYPE, attach.getId(), "file", attach.getFileId());
            attach.setFileId(fileId);
            attach.setAttachIds(Collections.singletonList(fileId));
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushToHistory(entity.getSupplierId(), entity.getId());
        MatSupplierChangeVO vo = new MatSupplierChangeVO();
        vo.setId(entity.getId());
        vo.setSourceType(entity.getSourceType());
        vo.setStatus("2");
        vo.setEmployeeId(entity.getEmployeeId());
        vo.setEmployeeName(entity.getEmployeeName());
        vo.setBillDate(entity.getBillDate());
        this.updateBillStatus(vo, true);
        return id;
    }

    @Override
    public String updateBillStatus(MatSupplierChangeVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(MatSupplierChangeVO vo, Boolean saveFlag) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (PlanConstant.SOURCE_TYPE_EL.equals(Integer.valueOf(entity.getSourceType()))) {
            return null;
        }
        this.pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        if (!saveFlag.booleanValue()) {
            this.pushSupUtil.updateBillStatus((JSONObject)JSONObject.toJSON((Object)((Object)entity)), "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, BILL_WITER_BACK_SERVER_URL, null);
        }
        super.saveOrUpdate((Object)entity);
        if (saveFlag.booleanValue()) {
            MatSupplierChangeFlowEntity flow = new MatSupplierChangeFlowEntity();
            flow.setChangeId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getEmployeeId());
            flow.setOperatorName(vo.getEmployeeName());
            flow.setOperateTime(vo.getBillDate());
            this.flowService.saveOrUpdate((Object)flow, false);
        } else {
            MatSupplierChangeFlowVO flow = new MatSupplierChangeFlowVO();
            flow.setChangeId(entity.getId());
            flow.setFlowType(StringUtils.isNotEmpty((CharSequence)vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            this.flowService.saveOrUpdate(flow);
        }
        return null;
    }

    @Override
    public JSONObject contrast(Long changeId) {
        MatSupplierChangeEntity entity = (MatSupplierChangeEntity)((Object)super.selectById((Serializable)changeId));
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter("eq", (Object)changeId));
        List list = this.historyService.queryList(param);
        MatSupplierHistoryEntity history = (MatSupplierHistoryEntity)((Object)this.historyService.selectById(((MatSupplierHistoryEntity)((Object)list.get(0))).getId()));
        JSONObject json = new JSONObject();
        json.put("change", BeanMapper.map((Object)((Object)entity), MatSupplierChangeVO.class));
        json.put("source", BeanMapper.map((Object)((Object)history), MatSupplierHistoryVO.class));
        return json;
    }

    @Override
    public Boolean pushToHistory(Long supplierId, Long changeId) {
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)this.supplierService.selectById(supplierId));
        MatSupplierHistoryVO save = EntityUtil.clearInvalidEntity(supplier, MatSupplierHistoryVO.class);
        save.setSupplierId(supplier.getId());
        save.setChangeId(changeId);
        MatSupplierHistoryVO history = this.historyService.saveOrUpdate(save);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplier.getId()), sourceBillType, "attachMgr", String.valueOf(history.getId()), historyBillType, "attachMgr");
        Map<Long, MatSupplierHistoryAttachesVO> attachMap = history.getAttachesList().stream().collect(Collectors.toMap(x -> x.getSourceDetailId(), x -> x));
        for (MatSupplierAttachesEntity source : supplier.getAttachesList()) {
            if (!attachMap.containsKey(source.getId())) continue;
            MatSupplierHistoryAttachesVO target = attachMap.get(source.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(source.getId()), sourceBillType, "file", String.valueOf(target.getId()), historyBillType, "file");
        }
        return true;
    }

    @Override
    public JSONArray getApprUserList(Long changeId) {
        JSONArray resp = new JSONArray();
        List<MatSupplierChangeMaterialInfoEntity> msList = this.matSupplierChangeMaterialInfoService.getAllByChangeId(changeId);
        List categoryIds = msList.stream().map(MatSupplierChangeMaterialInfoEntity::getMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(categoryIds)) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        CommonResponse settingResp = this.izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
        if (!settingResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7269\u6599\u5206\u7c7bids-{}\u83b7\u53d6\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff0c{}", categoryIds, (Object)JSONObject.toJSONString((Object)settingResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List settingList = (List)settingResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)settingList)) {
            for (MatSupplierManagerVO m : settingList) {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)m.getManagerId());
                obj.put("userName", (Object)m.getManagerName());
                resp.add((Object)obj);
            }
        }
        return resp;
    }
}

