/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierInviteEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierInviteFlowEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierInviteMapper;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierAccessService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierInviteFlowService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierInviteService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteFlowVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matSupplierInviteService")
public class MatSupplierInviteServiceImpl
extends BaseServiceImpl<MatSupplierInviteMapper, MatSupplierInviteEntity>
implements IMatSupplierInviteService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER_INVITE";
    private static final String SYSTEM_ID = "systemId";
    private static final String BILL_TYPE = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u9080\u8bf7.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u9080\u8bf7.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierInvite/syncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matSupplierInvite/syncBill";
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMatSupplierInviteFlowService flowService;
    @Autowired
    private IMatSupplierAccessService accessService;
    @Autowired
    private IMatSupplierService supplierService;

    @Override
    public MatSupplierInviteVO saveOrUpdate(MatSupplierInviteVO saveOrUpdateVO) {
        MatSupplierInviteEntity entity = (MatSupplierInviteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatSupplierInviteEntity.class));
        this.validateName(entity.getSupplierName(), entity.getId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setInviterPhone(this.sessionManager.getUserContext().getUserMobile());
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushBillToSupCenter(entity);
        return (MatSupplierInviteVO)BeanMapper.map((Object)((Object)entity), MatSupplierInviteVO.class);
    }

    private Boolean validateName(String supplierName, Long id) {
        List inviteList;
        QueryParam param = new QueryParam();
        param.getParams().put("supplierName", new Parameter("eq", (Object)supplierName));
        param.getParams().put("status", new Parameter("ne", (Object)"5"));
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(inviteList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u751f\u6210\u9080\u8bf7\u4e2d\u94fe\u63a5\u3010" + ((MatSupplierInviteEntity)((Object)inviteList.get(0))).getBillCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9080\u8bf7\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)supplierName));
        List supplierList = this.supplierService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u5df2\u7ecf\u5165\u5e93\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01\uff01");
        }
        return true;
    }

    @Override
    public boolean pushBillToSupCenter(MatSupplierInviteEntity entity) {
        Long sourceId = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), SYSTEM_ID, BILL_TYPE, BILL_NAME, "/ejc-zdssupbusiness-web/openapi/matSupplierInvite/syncBill");
        if (sourceId != null) {
            entity.setSourceId(sourceId);
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.sendEmail(entity);
            this.sendSms(entity);
            MatSupplierInviteFlowVO flow = new MatSupplierInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType("1".toString());
            this.flowService.saveOrUpdate(flow);
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u65b9\u670d\u52a1\u5931\u8d25", (Object)BILL_NAME, (Object)entity.getId());
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.saveOrUpdate((Object)entity, false);
        return true;
    }

    @Override
    public String updateBillStatus(MatSupplierInviteVO vo) {
        return this.updateBillStatus(vo, false);
    }

    @Override
    public String updateBillStatus(MatSupplierInviteVO vo, Boolean saveFlag) {
        MatSupplierInviteFlowEntity flow;
        if (vo.getId() == null) {
            return null;
        }
        MatSupplierInviteEntity entity = (MatSupplierInviteEntity)((Object)super.selectById((Serializable)vo.getId()));
        this.pushSupUtil.validateStatus(vo.getStatus(), entity.getStatus());
        entity.setStatus(vo.getStatus());
        if (StringUtils.isNotEmpty((CharSequence)vo.getBackReason())) {
            entity.setBackReason(vo.getBackReason());
        }
        if (!saveFlag.booleanValue()) {
            this.pushSupUtil.updateBillStatus((JSONObject)JSONObject.toJSON((Object)((Object)entity)), "status", SYSTEM_ID, BILL_TYPE, BILL_NAME, "/ejc-zdssupbusiness-web/openapi/matSupplierInvite/syncBill", null);
        }
        if ("6".equals(vo.getStatus())) {
            this.sendApproveEmail(entity);
            this.sendApproveSms(entity);
        }
        if ("4".equals(vo.getStatus())) {
            this.sendBackEmail(entity);
        }
        super.saveOrUpdate((Object)entity);
        if (saveFlag.booleanValue()) {
            flow = new MatSupplierInviteFlowEntity();
            flow.setInviteId(entity.getId());
            flow.setFlowType(vo.getStatus());
            flow.setOperatorId(vo.getInviterId());
            flow.setOperatorName(vo.getInviterName());
            flow.setOperateTime(new Date());
            this.flowService.saveOrUpdate((Object)flow, false);
        } else {
            flow = new MatSupplierInviteFlowVO();
            flow.setInviteId(entity.getId());
            flow.setFlowType(StringUtils.isNotEmpty((CharSequence)vo.getFlowType()) ? vo.getFlowType() : vo.getStatus());
            this.flowService.saveOrUpdate((MatSupplierInviteFlowVO)flow);
        }
        if ("4".equals(vo.getStatus())) {
            QueryParam param = new QueryParam();
            param.getParams().put("inviteId", new Parameter("eq", (Object)entity.getId()));
            List list = this.accessService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
                this.accessService.removeByIds(ids, true);
            }
        }
        return null;
    }

    private void sendSms(MatSupplierInviteEntity entity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", entity.getInviteCode());
        params.put("name", entity.getInviterName());
        params.put("phone", entity.getInviterPhone());
        this.pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), "SMS_465350426", "\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5e73\u53f0", params);
    }

    private void sendEmail(MatSupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("\u4e2d\u7535\u56db\u516c\u53f8\u9080\u8bf7\u60a8\u529e\u7406\u4f01\u4e1a\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u5b8c\u6210\u6ce8\u518c");
        content.append(entity.getInviteUrl());
        content.append("\uff0c\u8be5\u94fe\u63a5\u8bf7\u52ff\u5916\u4f20\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getSupplierName());
        this.pushSupUtil.sendEmail(null, "notice", "\u4f9b\u5e94\u5546\u9080\u8bf7\u90ae\u4ef6", content.toString(), params, entity.getInviteUrl(), null);
    }

    private void sendApproveSms(MatSupplierInviteEntity entity) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", "portal");
        params.put("name", entity.getSupplierName());
        params.put("phone", entity.getLinkPhone());
        this.pushSupUtil.sendSmsNoAuth(entity.getLinkPhone(), "SMS_465330440", "\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5e73\u53f0", params);
    }

    private void sendApproveEmail(MatSupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("\u3010");
        content.append(entity.getSupplierName());
        content.append("\u3011\u516c\u53f8\uff0c\u606d\u559c\u8d35\u53f8\u901a\u8fc7\u4e2d\u7535\u56db\u5206\u4f9b\u65b9\u5165\u5e93\u5ba1\u6838\uff0c\u5df2\u4e3a\u60a8\u5f00\u901a\u5206\u4f9b\u65b9\u534f\u540c\u8d26\u53f7\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5");
        String url = this.pushSupUtil.getLoginUrl();
        content.append(url);
        content.append("\uff0c\u8fdb\u884c\u767b\u5f55\uff0c\u767b\u5f55\u8d26\u53f7:");
        content.append(entity.getLinkPhone());
        content.append("\uff0c\u9996\u6b21\u767b\u5f55\u91c7\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8fdb\u884c\u9a8c\u8bc1");
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getSupplierName());
        this.pushSupUtil.sendEmail(null, "notice", "\u4f9b\u5e94\u5546\u6ce8\u518c\u6210\u529f\u90ae\u4ef6", content.toString(), params, url, null);
    }

    private void sendBackEmail(MatSupplierInviteEntity entity) {
        StringBuilder content = new StringBuilder();
        content.append("\u4e2d\u7535\u56db\u516c\u53f8\u5df2\u9a73\u56de\u4e86\u60a8\u529e\u7406\u7684\u4f01\u4e1a\u5165\u5e93\uff0c\u8bf7\u70b9\u51fb\u4e0b\u65b9\u94fe\u63a5\u91cd\u65b0\u6ce8\u518c");
        content.append(entity.getInviteUrl());
        content.append("\uff0c\u8be5\u94fe\u63a5\u8bf7\u52ff\u5916\u4f20\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb:");
        content.append(entity.getInviterName());
        content.append(entity.getInviterPhone());
        JSONObject params = new JSONObject();
        params.put("userEmails", (Object)entity.getLinkEmail());
        params.put("userNames", (Object)entity.getSupplierName());
        this.pushSupUtil.sendEmail(null, "notice", "\u4f9b\u5e94\u5546\u6ce8\u518c\u9a73\u56de\u90ae\u4ef6", content.toString(), params, entity.getInviteUrl(), null);
    }
}

