/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zds.archive.bean.BankEntity;
import com.ejianc.business.zds.archive.bean.PushErpRecordsEntity;
import com.ejianc.business.zds.archive.service.IBankCategoryService;
import com.ejianc.business.zds.archive.service.IBankService;
import com.ejianc.business.zds.archive.utils.ZdsReqUtil;
import com.ejianc.business.zds.archive.vo.BankCategoryVO;
import com.ejianc.business.zds.archive.vo.BankVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSBrandApi;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.material.api.IZDSMatSupManagerApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdssupplier.common.service.ISupplierSyncErpService;
import com.ejianc.business.zdssupplier.common.utils.CoordinationUtil;
import com.ejianc.business.zdssupplier.common.utils.ParamUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpCompanyTypeEnums;
import com.ejianc.business.zdssupplier.cons.enums.ErpLinkerCardTypeEnum;
import com.ejianc.business.zdssupplier.cons.enums.ErpTaxCreditLevelEnum;
import com.ejianc.business.zdssupplier.material.bean.MatLinkerEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierAttachesEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierBankEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierEntity;
import com.ejianc.business.zdssupplier.material.bean.MatSupplierMaterialInfoEntity;
import com.ejianc.business.zdssupplier.material.mapper.MatSupplierMapper;
import com.ejianc.business.zdssupplier.material.service.IMatLinkerService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeAttachesService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeBankService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierChangeMaterialInfoService;
import com.ejianc.business.zdssupplier.material.service.IMatSupplierService;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeBankVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierChangeMaterialInfoVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.material.vo.SupplierSyncParam;
import com.ejianc.business.zdssupplier.sub.vo.SupSubDelParamVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierSyncErpParamVO;
import com.ejianc.business.zdssupplier.utils.ZDSReqUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IDeptApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IPostApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matSupplierService")
public class MatSupplierServiceImpl
extends BaseServiceImpl<MatSupplierMapper, MatSupplierEntity>
implements IMatSupplierService,
ISupplierSyncErpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MAT_SUPPLIER";
    @Autowired
    private CoordinationUtil coordinationUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMatLinkerService linkerService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBankService bankService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPostApi postApi;
    @Autowired
    private IDeptApi deptApi;
    @Autowired
    private IMatSupplierChangeMaterialInfoService changeMaterialInfoService;
    @Autowired
    private IMatSupplierChangeAttachesService changeAttachesService;
    @Autowired
    private IMatSupplierChangeBankService changeBankService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IZDSBrandApi brandApi;
    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBankCategoryService bankCategoryService;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    private static final String ERP_MAT_SUPPLIER_UPDATE_URL = "/cefoc/yql/MESupplierList?OID=";
    @Autowired
    private MatSupplierMapper mapper;
    @Autowired
    private IZDSMatSupManagerApi izdsMatSupManagerApi;

    @Override
    public MatSupplierVO saveOrUpdate(MatSupplierVO saveOrUpdateVO) {
        return this.saveOrUpdateSupInfo(saveOrUpdateVO, true);
    }

    @Override
    public MatSupplierVO saveOrUpdateSupInfo(MatSupplierVO saveOrUpdateVO, boolean linkerGenerateAccFlag) {
        MatSupplierEntity entity = (MatSupplierEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MatSupplierEntity.class));
        this.validateUnique(entity.getName(), entity.getSocialCreditCode(), entity.getId(), "\u751f\u6210");
        this.linkerService.validateUnique(entity.getLinkerList());
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getCode()) && (entity.getId() == null || entity.getId() == 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        if (linkerGenerateAccFlag) {
            if (!"1".equals(entity.getCoordination())) {
                this.createSupTenant(entity);
            }
            for (MatLinkerEntity linker : entity.getLinkerList()) {
                if ("1".equals(linker.getCoordination())) continue;
                this.linkerService.createSupAccount(linker, entity.getTenant());
            }
        }
        return (MatSupplierVO)BeanMapper.map((Object)((Object)entity), MatSupplierVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateLinkerAcc(Long supplierId) {
        MatSupplierEntity entity = (MatSupplierEntity)((Object)super.selectById((Serializable)supplierId));
        if (!"1".equals(entity.getCoordination())) {
            this.createSupTenant(entity);
        }
        for (MatLinkerEntity linker : entity.getLinkerList()) {
            if ("1".equals(linker.getCoordination())) continue;
            this.linkerService.createSupAccount(linker, entity.getTenant());
        }
    }

    @Override
    public List<Long> getSignConSupplierIds(Long projectId) {
        return this.mapper.getSignConSupplierIds(projectId);
    }

    @Override
    public JSONArray getApprUserList(Long supplierId) {
        JSONArray resp = new JSONArray();
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)super.selectById((Serializable)supplierId));
        List<MatSupplierMaterialInfoEntity> msList = supplier.getMaterialInfoList();
        List categoryIds = msList.stream().filter(item -> null != item.getMaterialId()).map(MatSupplierMaterialInfoEntity::getMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msList) || CollectionUtils.isEmpty(categoryIds)) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u4e0b\u4f9b\u8d27\u5185\u5bb9\u7684\u7269\u8d44\u5206\u7c7b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\uff01");
        }
        CommonResponse settingResp = this.izdsMatSupManagerApi.getAllByCategoryIds(categoryIds);
        if (!settingResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7269\u6599\u5206\u7c7bids-{}\u83b7\u53d6\u5bf9\u5e94\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff0c{}", categoryIds, (Object)JSONObject.toJSONString((Object)settingResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List settingList = (List)settingResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)settingList)) {
            for (MatSupplierManagerVO m : settingList) {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)m.getManagerId());
                obj.put("userName", (Object)m.getManagerName());
                resp.add((Object)obj);
            }
        }
        return resp;
    }

    @Override
    public CommonResponse<MatSupplierEntity> queryDetailBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava((String)request.getParameter("transData"));
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)transData, JSONObject.class);
        String tenant = jsonObject.getString("tenant");
        Long id = jsonObject.getLong("id");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != id) {
            queryWrapper.eq((Object)"id", (Object)id);
        } else {
            queryWrapper.eq((Object)"tenant", (Object)tenant);
        }
        List list = super.list((Wrapper)queryWrapper);
        if (list.size() == 0) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01");
        }
        MatSupplierEntity supplierEntity = (MatSupplierEntity)((Object)list.get(0));
        MatSupplierEntity entity = (MatSupplierEntity)((Object)super.selectById((Serializable)supplierEntity.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @Override
    public TenantVO createSupTenant(MatSupplierEntity supplier) {
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("socialCreditCode", supplier.getSocialCreditCode());
        reqParam.put("supplierType", "material");
        reqParam.put("supplierName", supplier.getName() + "-\u7269\u8d44");
        reqParam.put("supplierId", supplier.getId().toString());
        TenantVO vo = this.coordinationUtil.createSupTenant(reqParam);
        supplier.setCoordination("1");
        supplier.setTenant(vo.getId());
        supplier.setTenantName(vo.getName());
        supplier.setSystemId(vo.getEnterpriseId().toString());
        super.saveOrUpdate((Object)supplier, false);
        return vo;
    }

    @Override
    public MatSupplierVO getByTenantId(Long supplierTenant) {
        MatSupplierVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant", (Object)supplierTenant);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MatSupplierEntity e = (MatSupplierEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (MatSupplierVO)BeanMapper.map((Object)((Object)e), MatSupplierVO.class);
        }
        return resp;
    }

    @Override
    public List<MatSupplierEntity> getAllByThirdSourceIds(List<String> thirdSourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"third_source_id", thirdSourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List resp = super.list((Wrapper)query);
        return resp;
    }

    @Override
    public Boolean validateUnique(String name, String socialCreditCode, Long id, String operate) {
        List supplierList;
        QueryParam param = new QueryParam();
        ComplexParam complexParam = ParamUtil.getOrParam("name", "socialCreditCode", name, socialCreditCode);
        param.getComplexParams().add(complexParam);
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(supplierList = super.queryList(param)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u751f\u6210\u6863\u6848\u3010" + ((MatSupplierEntity)((Object)supplierList.get(0))).getCode() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d" + operate + "\uff01");
        }
        return true;
    }

    @Override
    public String syncSupplierChangeToErp(SupplierSyncErpParamVO syncParam) {
        String pushResult = null;
        this.logger.info("\u63a8\u9001\u7269\u8d44\u4f9b\u5e94\u5546-{}\u81f3ERP   start*********", (Object)JSONObject.toJSONString((Object)syncParam));
        Map<String, String> headers = null;
        PushErpRecordsEntity pushEntity = new PushErpRecordsEntity();
        pushEntity.setBillType("supAdd".equals(syncParam.getSyncType()) ? BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u51c6\u5165.getCode() : ("supChange".equals(syncParam.getSyncType()) ? BillTypeEnum.\u7269\u8d44\u4f9b\u5e94\u5546\u53d8\u66f4.getCode() : ("linkerAdd".equals(syncParam.getSyncType()) ? BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u51c6\u5165.getCode() : BillTypeEnum.\u7269\u8d44\u8054\u7cfb\u4eba\u53d8\u66f4.getCode())));
        pushEntity.setPushTypeName(syncParam.getSyncType());
        pushEntity.setOperatorId(syncParam.getOperatorId());
        pushEntity.setOperatorName(syncParam.getOperatorName());
        pushEntity.setPushDate(new Date());
        SupplierSyncParam syncSupParam = new SupplierSyncParam();
        try {
            String syncUrl = "supAdd".equals(syncParam.getSyncType()) ? "/cefoc/yql/AddMESupplierList" : "/cefoc/yql/EditMESupplierList";
            MatSupplierEntity entity = (MatSupplierEntity)((Object)super.selectById((Serializable)syncParam.getSupplierId()));
            syncSupParam.setSupplierId(entity.getId());
            pushEntity.setUrl(ZdsReqUtil.getErpReqHost() + syncUrl);
            JSONObject supJson = null;
            if (!"supAdd".equals(syncParam.getSyncType())) {
                supJson = this.getSupErpInfo(syncParam.getSupplierId());
                if (null == supJson && !"ok".equals(supJson.get((Object)"status"))) {
                    this.logger.error("\u4e2d\u7535\u56db \u4f9b\u5e94\u5546id-{}\u63a8\u9001ERP\u5931\u8d25, \u4eceERP\u63a5\u53e3\u83b7\u53d6\u8be5\u4f9b\u5e94\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25!", (Object)syncParam.getSupplierId());
                    pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4eceERP\u63a5\u53e3\u83b7\u53d6\u5f53\u524d\u4f9b\u5e94\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25\uff01";
                    pushEntity.setSucFlag("0");
                    pushEntity.setPushResult("\u4f9b\u5e94\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001,\u4eceERP\u63a5\u53e3\u83b7\u53d6\u4f9b\u5e94\u5546\u6700\u65b0\u4fe1\u606f\u5931\u8d25\uff01");
                    this.sendMq("push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)pushEntity)));
                    return pushResult;
                }
                pushEntity.setBeforePushSupInfo(supJson.toJSONString());
            }
            ArrayList<SupSubDelParamVO> delList = new ArrayList<SupSubDelParamVO>();
            JSONArray syncData = this.transferToErpParam(entity, syncParam, delList, supJson);
            pushEntity.setData(JSONObject.toJSONString((Object)syncData));
            headers = ZdsReqUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)(ZdsReqUtil.getErpReqHost() + syncUrl), (String)JSONObject.toJSONString((Object)syncData), headers, (Integer)60000, (Integer)60000);
            this.logger.info("\u7269\u8d44\u4f9b\u5e94\u5546\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{ZdsReqUtil.getErpReqHost() + syncUrl, JSONObject.toJSONString((Object)syncData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            pushEntity.setErpResult(reqJson.toJSONString());
            if ("true".equals(reqJson.getString("status"))) {
                this.logger.info("\u4e2d\u7535\u56db \u7269\u8d44\u4f9b\u5e94\u5546\u767b\u8bb0id-{}\u63a8\u9001ERP\u6210\u529f!", (Object)syncParam.getSupplierId());
                pushEntity.setSucFlag("1");
                pushEntity.setPushResult("\u4f9b\u5e94\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001ERP\u6210\u529f\uff01");
                if (CollectionUtils.isNotEmpty(delList)) {
                    // empty if block
                }
            } else {
                this.logger.error("\u4e2d\u7535\u56db \u7269\u8d44\u4f9b\u5e94\u5546\u767b\u8bb0id-{}\u63a8\u9001ERP\u5931\u8d25!", (Object)syncParam.getSupplierId());
                pushEntity.setSucFlag("0");
                pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u6570\u636e\u63a8\u9001ERP\u5904\u7406\u5931\u8d25\uff01";
                pushEntity.setPushResult("\u4f9b\u5e94\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001,ERP\u5904\u7406\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u7269\u8d44\u4f9b\u5e94\u5546id-{}\u5f02\u5e38\uff0c", (Object)syncParam.getSupplierId(), (Object)e);
            pushEntity.setErpResult("\u63a8\u9001\u5f02\u5e38");
            pushEntity.setSucFlag("0");
            pushResult = "\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u63a8\u9001ERP\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01";
            pushEntity.setPushResult("\u4f9b\u5e94\u5546\u3010id-" + syncParam.getSupplierId().toString() + "\u3011\u63a8\u9001\uff0c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01");
        }
        syncSupParam.setHandleServiceName("matSupplierService");
        this.sendMq("push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)pushEntity)));
        if ("1".equals(pushEntity.getSucFlag())) {
            this.sendMq("erp_sup_upd_" + this.profile, JSONObject.toJSONString((Object)syncSupParam));
        }
        this.logger.info("\u63a8\u9001\u7269\u8d44\u4f9b\u5e94\u5546id-{}\u81f3ERP   end*********", (Object)syncParam.getSupplierId());
        return pushResult;
    }

    @Override
    public String sendMq(String queueName, String body) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)body);
        this.rabbitTemplate.convertAndSend(queueName, (Object)mqMessage);
        this.logger.info("MQ\u961f\u5217\u6807\u8bc6\uff1a{}", (Object)queueName);
        return "\u6d88\u606f\u53d1\u9001MQ\u961f\u5217\u6210\u529f\uff01";
    }

    private JSONArray transferToErpParam(MatSupplierEntity entity, SupplierSyncErpParamVO syncParam, List<SupSubDelParamVO> delList, JSONObject supErpJson) {
        String corpSid;
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add((Object)data);
        JSONObject supplierJson = new JSONObject();
        if (null != supErpJson && supErpJson.getJSONArray("MESupplierList").size() > 0) {
            supplierJson = (JSONObject)supErpJson.getJSONArray("MESupplierList").get(0);
        }
        if (StringUtils.isBlank((CharSequence)(corpSid = entity.getCorpSid())) && null != entity.getCorpId()) {
            CommonResponse orgResp = this.orgApi.getOneById(entity.getCorpId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f52\u5c5e\u90e8\u95e8id-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)entity.getCorpId(), (Object)JSONObject.toJSONString((Object)orgResp));
            }
            if (null == orgResp.getData()) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f52\u5c5e\u90e8\u95e8id-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getCorpId(), (Object)JSONObject.toJSONString((Object)orgResp));
            } else {
                corpSid = ((OrgVO)orgResp.getData()).getSourceId();
            }
        }
        EmployeeVO creator = null;
        if (StringUtils.isNotBlank((CharSequence)entity.getErpCreatorSid())) {
            CommonResponse creatorRes = this.employeeApi.getOneBySourceId(entity.getErpCreatorSid());
            if (!creatorRes.isSuccess()) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f55\u5165\u4ebasid-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)entity.getErpCreatorSid()), (Object)JSONObject.toJSONString((Object)creatorRes));
            }
            if (null == (creator = (EmployeeVO)creatorRes.getData())) {
                this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546id-{}\u540c\u6b65ERP\u5931\u8d25,\u67e5\u8be2\u4f9b\u5e94\u5546\u5f55\u5165\u4ebasid-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getId(), (Object)entity.getErpCreatorSid());
            }
        }
        data.put("YQL_SID", StringUtils.isBlank((CharSequence)entity.getThirdSourceId()) ? entity.getId() : entity.getThirdSourceId());
        data.put("CON_EMP_NUM", (Object)(null != creator ? creator.getCode() : null));
        if (null != creator || StringUtils.isNotBlank((CharSequence)entity.getErpRegisterName())) {
            data.put("Register_Name", (Object)(null != creator ? creator.getName() : entity.getErpRegisterName()));
        }
        data.put("Company_Name", (Object)entity.getName());
        data.put("Taxcreditrating", (Object)(StringUtils.isNotBlank((CharSequence)ErpTaxCreditLevelEnum.getByName((String)entity.getTaxCreditLevel())) ? ErpTaxCreditLevelEnum.getByName((String)entity.getTaxCreditLevel()) : ""));
        data.put("OwnerDept", (Object)(StringUtils.isNotBlank((CharSequence)entity.getCorpErpName()) ? entity.getCorpErpName() : (StringUtils.isNotBlank((CharSequence)entity.getCorpName()) ? entity.getCorpName() : "")));
        data.put("OwnerDeptSid", (Object)(StringUtils.isBlank((CharSequence)corpSid) ? "00000000-0000-0000-0000-000000000000" : corpSid));
        data.put("CompanyStyle", (Object)ErpCompanyTypeEnums.fuzzyMatchByName((String)(entity.getCompanyType().contains("(") ? entity.getCompanyType().substring(0, entity.getCompanyType().indexOf("(")) : entity.getCompanyType())));
        data.put("Company_LegalPerson", (Object)entity.getLegalPerson());
        data.put("RegistrationCode", (Object)entity.getSocialCreditCode());
        data.put("IsPoSupplier", (Object)entity.getPoState());
        data.put("RegistrationCapital", (Object)this.handleMnyStr(entity.getRegisteredCapitalStr()));
        data.put("Company_Address", (Object)entity.getRegisteredAddress());
        data.put("EntryDept", StringUtils.isNotBlank((CharSequence)entity.getType()) ? PlanConstant.ERP_MAT_INFO_TYPE_MAPPING.get(entity.getType()) : (StringUtils.isNotBlank((CharSequence)entity.getErpType()) ? entity.getErpType() : null));
        data.put("ConpanyTypeDescription", (Object)entity.getCompanyCharacter());
        data.put("OperatingPeriodStart", (Object)(null != entity.getBusinessStartDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getBusinessStartDate()) : ""));
        data.put("OperatingPeriodStartEnd", (Object)(null != entity.getBusinessEndDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getBusinessEndDate()) : ""));
        data.put("OperatingRange", (Object)entity.getBusinessScope());
        data.put("MainBrands", (Object)(CollectionUtils.isNotEmpty(entity.getMaterialInfoList()) ? entity.getMaterialInfoList().stream().map(MatSupplierMaterialInfoEntity::getBrandName).collect(Collectors.joining(",")) : ""));
        data.put("SupplyArea", (Object)entity.getIntentName());
        data.put("CompanyType", (Object)entity.getProfessionName());
        data.put("CompanyType_Sid", (Object)entity.getProfessionName());
        data.put("IsSupportES", (Object)entity.getSealState());
        data.put("companyState", (Object)entity.getCompanyState());
        data.put("Restricteddate", (Object)(null != entity.getRestrictDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getRestrictDate()) : ""));
        data.put("IsitaOneTimeUse", (Object)entity.getDisposableState());
        data.put("ReasonforOneTimeUse", (Object)(StringUtils.isNotBlank((CharSequence)entity.getDisposableReason()) ? entity.getDisposableReason() : ""));
        data.put("TypeLabel", (Object)(Integer.valueOf(entity.getCompanyCharacter()) - 1));
        data.put("InStorageRemark", (Object)(StringUtils.isNotBlank((CharSequence)entity.getMemo()) ? entity.getMemo() : ""));
        data.put("Memo", (Object)entity.getMemo());
        data.put("Paidincapital", (Object)this.handleMnyStr(entity.getPaidCapitalStr()));
        data.put("regStatus", (Object)entity.getBusinessStatus());
        data.put("Ma_id", (Object)entity.getCode());
        this.supplierInfoBaseFill(data, supplierJson);
        JSONArray linkerArr = new JSONArray();
        data.put("ContactList", (Object)linkerArr);
        this.handleSupLinker(linkerArr, entity.getLinkerList(), syncParam, creator, supplierJson.getJSONArray("ContactList"));
        JSONArray bankListArr = new JSONArray();
        data.put("BankList", (Object)bankListArr);
        this.handleSupBank(bankListArr, entity.getBankList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), entity, delList, supplierJson.getJSONArray("BankList"));
        JSONArray archiveArr = new JSONArray();
        data.put("ArchiveList", (Object)archiveArr);
        this.handleSupArchive(archiveArr, entity.getAttachesList(), syncParam, data.getString("C_PS_MESupplierInfoOID"), creator, delList);
        JSONArray materialArr = new JSONArray();
        data.put("MESupplierSubDList", (Object)materialArr);
        this.handleSupMaterial(materialArr, entity.getMaterialInfoList(), syncParam, entity, delList, supplierJson.getJSONArray("SupplyList"));
        if (materialArr.size() > 0) {
            data.put("CompanyType", (Object)materialArr.stream().map(item -> ((JSONObject)item).getString("CompanyType")).collect(Collectors.joining(",")));
            data.put("CompanyType_Sid", (Object)materialArr.stream().map(item -> ((JSONObject)item).getString("CompanyType_Sid")).collect(Collectors.joining(",")));
        }
        return resp;
    }

    private void supplierInfoBaseFill(JSONObject data, JSONObject supplierJson) {
        if (StringUtils.isBlank((CharSequence)data.getString("OwnerDept")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("OwnerDept"))) {
            data.put("OwnerDept", (Object)supplierJson.getString("OwnerDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("OwnerDeptSid")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("OwnerDeptSid"))) {
            data.put("OwnerDeptSid", (Object)supplierJson.getString("OwnerDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("MainBrands")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("MainBrands"))) {
            data.put("MainBrands", (Object)supplierJson.getString("MainBrands"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("CompanyStyle")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("CompanyStyle"))) {
            data.put("CompanyStyle", (Object)supplierJson.getString("CompanyStyle"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("Taxcreditrating")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("Taxcreditrating"))) {
            data.put("Taxcreditrating", (Object)supplierJson.getString("Taxcreditrating"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("EntryDept")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("EntryDept"))) {
            data.put("EntryDept", (Object)supplierJson.getString("EntryDept"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("SupplyArea")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("SupplyArea"))) {
            data.put("SupplyArea", (Object)supplierJson.getString("SupplyArea"));
        }
        if (StringUtils.isBlank((CharSequence)data.getString("TypeLabel")) && StringUtils.isNotBlank((CharSequence)supplierJson.getString("TypeLabel"))) {
            data.put("TypeLabel", (Object)supplierJson.getString("TypeLabel"));
        }
    }

    private String handleMnyStr(String mnyStr) {
        if (StringUtils.isBlank((CharSequence)mnyStr)) {
            return "-";
        }
        mnyStr = mnyStr.replaceAll("\u4ebf", "00000000");
        mnyStr = mnyStr.replaceAll("\u5343\u4e07", "0000000");
        mnyStr = mnyStr.replaceAll("\u4e07", "0000");
        mnyStr = mnyStr.replaceAll("\u5343", "000");
        mnyStr = mnyStr.replaceAll("\u767e", "00");
        mnyStr = mnyStr.replaceAll("\u5341", "0");
        mnyStr = mnyStr.replaceAll("\u4eba\u6c11\u5e01", "");
        return mnyStr;
    }

    private void handleSupMaterial(JSONArray materialArr, List<MatSupplierMaterialInfoEntity> materialInfoList, SupplierSyncErpParamVO syncParam, MatSupplierEntity supplier, List<SupSubDelParamVO> delList, JSONArray erpMaterialArr) {
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("supChange".equals(syncParam.getSyncType())) {
            List<MatSupplierChangeMaterialInfoVO> changeDelList = this.changeMaterialInfoService.getDeledRecord(syncParam.getChangeId());
            this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        }
        JSONObject materialJson = null;
        HashMap<String, JSONObject> erpMaterialMap = new HashMap<String, JSONObject>();
        if (null != erpMaterialArr && erpMaterialArr.size() > 0) {
            for (Object obj : erpMaterialArr) {
                materialJson = (JSONObject)obj;
                erpMaterialMap.put(materialJson.getString("C_PS_MESupplierInfo_SubDOID"), materialJson);
            }
        }
        if (CollectionUtils.isNotEmpty(materialInfoList)) {
            CommonResponse catetgoyResp;
            CommonResponse brandResp;
            HashMap<Long, BrandVO> brandMap = new HashMap<Long, BrandVO>();
            Map brandNameMap = new HashMap();
            List brandIds = materialInfoList.stream().flatMap(item -> Stream.of(item.getBrandId().split(","))).map(Long::parseLong).collect(Collectors.toList());
            List brandSids = materialInfoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBrandSid())).map(item -> item.getBrandSid()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(brandIds)) {
                brandResp = this.brandApi.getAllByIds(brandIds);
                if (!brandResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u54c1\u724cID-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25,{}", (Object)JSONObject.toJSONString(brandIds), (Object)JSONObject.toJSONString((Object)brandResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u8d27\u54c1\u724c\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)brandResp.getData()))) {
                    this.logger.error("\u6839\u636e\u54c1\u724cID-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(brandIds), (Object)JSONObject.toJSONString((Object)brandResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                } else {
                    brandMap.putAll(((List)brandResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
                }
            }
            if (CollectionUtils.isNotEmpty(brandSids)) {
                brandResp = this.brandApi.getAllMapBySourceIds(brandSids);
                if (!brandResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u54c1\u724cSID-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25,{}", (Object)JSONObject.toJSONString(brandSids), (Object)JSONObject.toJSONString((Object)brandResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u8d27\u54c1\u724c\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (MapUtils.isEmpty((Map)((Map)brandResp.getData()))) {
                    this.logger.error("\u6839\u636e\u54c1\u724cID-{}\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(brandIds), (Object)JSONObject.toJSONString((Object)brandResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                } else {
                    brandNameMap = (Map)brandResp.getData();
                }
            }
            Map<Object, Object> categoryMap = new HashMap();
            HashMap<String, MaterialCategoryVO> categorySourceMap = new HashMap<String, MaterialCategoryVO>();
            List categoryIds = materialInfoList.stream().filter(item -> null != item.getMaterialId()).map(item -> item.getMaterialId()).collect(Collectors.toList());
            List categorySid = materialInfoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMaterialSid())).map(item -> item.getMaterialSid()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                catetgoyResp = this.materialCategoryApi.getAllByIds(categoryIds);
                if (!catetgoyResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u54c1\u724cID-{}\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", brandIds, (Object)JSONObject.toJSONString((Object)catetgoyResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u8d27\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)catetgoyResp.getData()))) {
                    this.logger.error("\u6839\u636e\u54c1\u724cID-{}\u67e5\u8be2\u54c1\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(categoryIds), (Object)JSONObject.toJSONString((Object)catetgoyResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                categoryMap = ((List)catetgoyResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            }
            if (CollectionUtils.isNotEmpty(categorySid)) {
                catetgoyResp = this.materialCategoryApi.getAllBySourceIdsAndPropertyFlag(categorySid, PlanConstant.INTEGER_YES);
                if (!catetgoyResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u54c1\u724cSID-{}\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(categorySid), (Object)JSONObject.toJSONString((Object)catetgoyResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u8d27\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)catetgoyResp.getData()))) {
                    this.logger.error("\u6839\u636e\u54c1\u724cSID-{}\u67e5\u8be2\u54c1\u7269\u6599\u5206\u7c7b\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(categorySid), (Object)JSONObject.toJSONString((Object)catetgoyResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                categorySourceMap.putAll(((List)catetgoyResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
            HashMap<Long, String> projectSid = new HashMap<Long, String>();
            List projectIds = materialInfoList.stream().filter(item -> null != item.getAffiliatedProjectId()).map(item -> item.getAffiliatedProjectId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(projectIds)) {
                CommonResponse prjResp = this.projectPoolApi.queryProjectByIds(projectIds);
                if (!prjResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u5173\u8054\u9879\u76eeID-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25", projectIds, (Object)JSONObject.toJSONString((Object)prjResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    throw new BusinessException("\u7269\u8d44\u4f9b\u5e94\u5546\u540c\u6b65ERP\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u8d27\u5185\u5bb9\u5173\u8054\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)prjResp.getData()))) {
                    this.logger.error("\u6839\u636e\u5173\u8054\u9879\u76eeID-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a", brandIds, (Object)JSONObject.toJSONString((Object)prjResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                projectSid.putAll(((JSONArray)prjResp.getData()).stream().map(item -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)item))).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("sourceId"))));
            }
            MaterialCategoryVO tmpCategory = null;
            String projectSidStr = null;
            for (MatSupplierMaterialInfoEntity material : materialInfoList) {
                boolean pushFlag;
                this.logger.info("\u4f9b\u8d27\u5185\u5bb9\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)material), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                materialJson = new JSONObject();
                tmpCategory = (MaterialCategoryVO)categoryMap.get(material.getMaterialId());
                if (null == tmpCategory) {
                    this.logger.error("\u6839\u636e\u7269\u6599\u5206\u7c7bid-{}\u4fe1\u606f\u6ca1\u6709\u5339\u914d\u5230\u5206\u7c7b\u4fe1\u606f", brandIds);
                }
                if (null == tmpCategory) {
                    tmpCategory = (MaterialCategoryVO)categorySourceMap.get(material.getMaterialSid());
                }
                if (null != material.getAffiliatedProjectId() && !projectSid.containsKey(material.getAffiliatedProjectId())) {
                    this.logger.error("\u7269\u8d44\u4f9b\u5e94\u5546-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5173\u8054\u9879\u76ee-{}\u4fe1\u606f", (Object)material.getSupplierId(), (Object)material.getAffiliatedProjectId());
                }
                String string = projectSidStr = projectSid.containsKey(material.getAffiliatedProjectId()) ? (String)projectSid.get(material.getAffiliatedProjectId()) : null;
                if (null != tmpCategory) {
                    materialJson.put("CompanyType", (Object)tmpCategory.getName());
                    materialJson.put("CompanyType_Sid", (Object)tmpCategory.getSourceId());
                }
                materialJson.put("MainBrands", (Object)material.getBrandName());
                materialJson.put("MainBrands_Sid", (Object)(StringUtils.isNotBlank((CharSequence)material.getBrandId()) && brandMap.containsKey(Long.valueOf(material.getBrandId())) ? ((BrandVO)brandMap.get(Long.valueOf(material.getBrandId()))).getSourceId() : (StringUtils.isNotBlank((CharSequence)material.getBrandSid()) ? material.getBrandSid() : null)));
                materialJson.put("PropertyCode", (Object)material.getPropertyValue());
                materialJson.put("PropertyName", PlanConstant.MAT_MATERIAL_PROPERTY.get(material.getPropertyValue()));
                materialJson.put("CertificationCode", (Object)(Integer.valueOf(1).equals(material.getCertification()) ? "0" : "1"));
                materialJson.put("CertificationName", (Object)(Integer.valueOf(1).equals(material.getCertification()) ? "\u4ee3\u7406\u8bc1" : "\u9879\u76ee\u6388\u6743"));
                materialJson.put("BeginTime", (Object)(null != material.getStartTime() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)material.getStartTime()) : ""));
                materialJson.put("EndTime", (Object)(null != material.getTerminalTime() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)material.getTerminalTime()) : ""));
                materialJson.put("AffiliatedCompany", (Object)material.getAffiliatedManufacturer());
                materialJson.put("AffiliatedProject", (Object)material.getAffiliatedProjectName());
                materialJson.put("IsEnable", (Object)material.getEnableStatus());
                materialJson.put("AccountingProjectSet_FK", (Object)(StringUtils.isNotBlank((CharSequence)projectSidStr) ? projectSidStr : ""));
                materialJson.put("YQL_SID", StringUtils.isBlank((CharSequence)material.getInfoThirdSourceId()) ? material.getId() : material.getInfoThirdSourceId());
                materialJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(material.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != material.getSourceDetailId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                if (erpMaterialMap.containsKey(material.getInfoThirdSourceId()) && !(pushFlag = this.fillMaterialInfo(materialJson, (JSONObject)erpMaterialMap.get(material.getInfoThirdSourceId())))) continue;
                materialArr.add((Object)materialJson);
            }
        }
    }

    private boolean fillMaterialInfo(JSONObject materialJson, JSONObject erpMaterialJson) {
        boolean pushFlag = true;
        if (StringUtils.isBlank((CharSequence)materialJson.getString("MainBrands"))) {
            if (StringUtils.equals((CharSequence)materialJson.getString("MainBrands_Sid"), (CharSequence)erpMaterialJson.getString("MainBrands_Sid"))) {
                materialJson.put("MainBrands", (Object)erpMaterialJson.getString("MainBrands"));
            } else {
                pushFlag = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("MainBrands_Sid"))) {
            if (StringUtils.equals((CharSequence)materialJson.getString("MainBrands"), (CharSequence)erpMaterialJson.getString("MainBrands"))) {
                materialJson.put("MainBrands_Sid", (Object)erpMaterialJson.getString("MainBrands_Sid"));
            } else {
                pushFlag = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("CompanyType"))) {
            if (StringUtils.equals((CharSequence)materialJson.getString("CompanyType_Sid"), (CharSequence)erpMaterialJson.getString("CompanyType_Sid"))) {
                materialJson.put("CompanyType", (Object)erpMaterialJson.getString("CompanyType"));
            } else {
                pushFlag = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("CompanyType_Sid"))) {
            if (StringUtils.equals((CharSequence)materialJson.getString("CompanyType"), (CharSequence)erpMaterialJson.getString("CompanyType"))) {
                materialJson.put("CompanyType_Sid", (Object)erpMaterialJson.getString("CompanyType_Sid"));
            } else {
                pushFlag = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("CompanyType_Sid"))) {
            if (StringUtils.equals((CharSequence)materialJson.getString("CompanyType"), (CharSequence)erpMaterialJson.getString("CompanyType"))) {
                materialJson.put("CompanyType_Sid", (Object)erpMaterialJson.getString("CompanyType_Sid"));
            } else {
                pushFlag = false;
            }
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("AffiliatedCompany")) && StringUtils.equals((CharSequence)materialJson.getString("PropertyCode"), (CharSequence)erpMaterialJson.getString("PropertyCode"))) {
            materialJson.put("PropertyCode", (Object)erpMaterialJson.getString("PropertyCode"));
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("AffiliatedProject")) && StringUtils.equals((CharSequence)materialJson.getString("PropertyCode"), (CharSequence)erpMaterialJson.getString("PropertyCode"))) {
            materialJson.put("AffiliatedProject", (Object)erpMaterialJson.getString("AffiliatedProject"));
        }
        if (StringUtils.isBlank((CharSequence)materialJson.getString("AccountingProjectSet_FK")) && StringUtils.equals((CharSequence)materialJson.getString("PropertyCode"), (CharSequence)erpMaterialJson.getString("PropertyCode"))) {
            materialJson.put("AccountingProjectSet_FK", (Object)erpMaterialJson.getString("AccountingProjectSet_FK"));
        }
        return pushFlag;
    }

    private void handleSupArchive(JSONArray archiveArr, List<MatSupplierAttachesEntity> attachesList, SupplierSyncErpParamVO syncParam, String supplierSid, EmployeeVO creator, List<SupSubDelParamVO> delList) {
        if (!"supAdd".equals(syncParam.getSyncType())) {
            return;
        }
        if (CollectionUtils.isNotEmpty(attachesList)) {
            JSONObject params = new JSONObject();
            List sourceIds = attachesList.stream().map(MatSupplierAttachesEntity::getFileId).collect(Collectors.toList());
            CommonResponse attachResp = this.attachmentApi.queryAllByIds(sourceIds);
            HashMap<Long, AttachmentVO> attachMap = new HashMap<Long, AttachmentVO>();
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636eid\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
            AttachmentVO tmpAttach = null;
            for (MatSupplierAttachesEntity archive : attachesList) {
                JSONObject archiveJson = new JSONObject();
                this.logger.info("\u9644\u4ef6\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)archive), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                if (null != archive.getFileId()) {
                    tmpAttach = (AttachmentVO)attachMap.get(archive.getFileId());
                    archiveJson.put("Attach_Name", (Object)archive.getFileName());
                    archiveJson.put("Attach_Extension", (Object)(archive.getFileName().indexOf(".") > 0 ? archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) : tmpAttach.getFileName().substring(tmpAttach.getFileName().lastIndexOf("."))));
                    archiveJson.put("Attach_Type", (Object)archive.getFileType());
                    archiveJson.put("AttachBase64", (Object)(null != tmpAttach ? this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath() : ""));
                    archiveJson.put("YQL_SID", StringUtils.isBlank((CharSequence)archive.getThirdSourceId()) ? archive.getId() : archive.getThirdSourceId());
                    archiveJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(archive.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != archive.getThirdSourceId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
                    archiveJson.put("Main_FK", (Object)supplierSid);
                    archiveArr.add((Object)archiveJson);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)archive.getThirdSourceId())) continue;
                archiveJson.put("Attach_Name", (Object)archive.getFileName());
                archiveJson.put("Attach_Extension", (Object)(archive.getFileName().indexOf(".") > 0 ? archive.getFileName().substring(archive.getFileName().lastIndexOf(".")) : ""));
                archiveJson.put("Attach_Type", (Object)archive.getFileType());
                archiveJson.put("YQL_SID", StringUtils.isNotBlank((CharSequence)archive.getThirdSourceId()) ? archive.getThirdSourceId() : archive.getId());
                archiveJson.put("Is_Add_Del", (Object)PlanConstant.\u4fe1\u606f\u5220\u9664);
                archiveArr.add((Object)archiveJson);
            }
        }
    }

    private void handleSupBank(JSONArray bankListArr, List<MatSupplierBankEntity> bankList, SupplierSyncErpParamVO syncParam, String supplierSid, MatSupplierEntity supplier, List<SupSubDelParamVO> delList, JSONArray erpBankArr) {
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("supChange".equals(syncParam.getSyncType())) {
            List<MatSupplierChangeBankVO> changeDelList = this.changeBankService.getDeledRecord(syncParam.getChangeId());
            this.logger.info("\u5220\u9664\u9879\uff1a{}", changeDelList);
        }
        JSONObject bankJson = null;
        HashMap<String, JSONObject> erpBankMap = new HashMap<String, JSONObject>();
        if (null != erpBankArr && erpBankArr.size() > 0) {
            for (Object obj : erpBankArr) {
                bankJson = (JSONObject)obj;
                erpBankMap.put(bankJson.getString("C_PS_MESupplierInfo_SubBOID"), bankJson);
            }
        }
        List<BankVO> dbBankList = this.bankService.getAllByIds(bankList.stream().map(MatSupplierBankEntity::getBankId).collect(Collectors.toList()));
        Map<String, BankEntity> bankNameMap = this.bankService.getAllMapByNames(bankList.stream().map(MatSupplierBankEntity::getOpenBank).collect(Collectors.toList()));
        HashMap<Long, BankVO> bankMap = new HashMap<Long, BankVO>();
        HashMap<Long, BankCategoryVO> bankCategoryMap = new HashMap<Long, BankCategoryVO>();
        if (CollectionUtils.isNotEmpty(dbBankList)) {
            bankMap.putAll(dbBankList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            List<BankCategoryVO> bankCategory = this.bankCategoryService.getAllByIds(dbBankList.stream().map(BankVO::getCategoryId).collect(Collectors.toList()));
            bankCategoryMap.putAll(bankCategory.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        BankVO tmpBank = null;
        BankCategoryVO tmpBankCategory = null;
        for (MatSupplierBankEntity bank : bankList) {
            bankJson = new JSONObject();
            tmpBank = (BankVO)bankMap.get(bank.getBankId());
            if (null == tmpBank) {
                BankVO bankVO = tmpBank = bankNameMap.containsKey(bank.getOpenBank()) ? (BankVO)BeanMapper.map((Object)((Object)bankNameMap.get(bank.getOpenBank())), BankVO.class) : null;
            }
            if (null == tmpBank) {
                this.logger.error("\u4f9b\u5e94\u5546id-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\uff1a{}\u7684\u94f6\u884c\u4fe1\u606f", (Object)bank.getSupplierId(), (Object)bank.getBankId());
            } else {
                tmpBankCategory = (BankCategoryVO)bankCategoryMap.get(tmpBank.getCategoryId());
            }
            if (null == tmpBankCategory) {
                this.logger.error("\u4f9b\u5e94\u5546id-{}\u540c\u6b65ERP\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a\uff1a{}\u7684\u94f6\u884c\u5206\u7c7b\u4fe1\u606f", (Object)bank.getSupplierId(), (Object)JSONObject.toJSONString((Object)((Object)bank), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            this.logger.info("\u94f6\u884c\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)bank), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            bankJson.put("YQL_SID", StringUtils.isBlank((CharSequence)bank.getBankThirdSourceId()) ? bank.getId() : bank.getBankThirdSourceId());
            bankJson.put("AccountType", (Object)(null != bank.getNumberType() ? bank.getNumberType() - 1 + "" : ""));
            bankJson.put("Contact_BankAccount", (Object)bank.getBankNumber());
            if (null != tmpBank) {
                bankJson.put("SubBankName", (Object)tmpBank.getCategoryName());
                bankJson.put("SubBankCode", (Object)tmpBank.getSubBankCode());
                bankJson.put("Province", (Object)tmpBank.getProvinceName());
                bankJson.put("City", (Object)tmpBank.getCityName());
                bankJson.put("Contact_Bank", (Object)tmpBank.getName());
                bankJson.put("Contact_BankNumber", (Object)tmpBank.getCode());
                bankJson.put("BranchSqe", (Object)tmpBank.getCode());
                bankJson.put("Whlnam", (Object)tmpBank.getName());
                bankJson.put("BankInfoOID", (Object)tmpBank.getSourceId());
            }
            if (null != tmpBankCategory) {
                bankJson.put("BankType", (Object)tmpBankCategory.getCode());
            }
            bankJson.put("Memo", (Object)"");
            bankJson.put("C_PS_SubContractorInfo_FK", (Object)supplierSid);
            bankJson.put("Is_Add_Del", (Object)("supAdd".equals(syncParam.getSyncType()) ? PlanConstant.\u4fe1\u606f\u65b0\u589e : (BaseVO.DR_DELETED.equals(bank.getDr()) ? PlanConstant.\u4fe1\u606f\u5220\u9664 : (null != bank.getSourceDetailId() ? PlanConstant.\u4fe1\u606f\u4fee\u8ba2 : PlanConstant.\u4fe1\u606f\u65b0\u589e))));
            if (null != tmpBank || !erpBankMap.containsKey(bank.getBankThirdSourceId())) {
                this.logger.info("\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f[{}]\u4e0d\u5408\u6cd5\uff0c\u8df3\u8fc7\u63a8\u9001ERP", (Object)JSONObject.toJSONString((Object)((Object)bank)));
                continue;
            }
            this.fillBankInfo(bankJson, (JSONObject)erpBankMap.get(bank.getBankThirdSourceId()));
            bankListArr.add((Object)bankJson);
        }
    }

    private void fillBankInfo(JSONObject bankJson, JSONObject erpBank) {
        if (StringUtils.isBlank((CharSequence)bankJson.getString("SubBankName")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("SubBankName"))) {
            bankJson.put("SubBankName", (Object)erpBank.getString("SubBankName"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("SubBankCode")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("SubBankCode"))) {
            bankJson.put("SubBankCode", (Object)erpBank.getString("SubBankCode"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Province")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Province"))) {
            bankJson.put("Province", (Object)erpBank.getString("Province"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("City")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("City"))) {
            bankJson.put("City", (Object)erpBank.getString("City"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Contact_Bank")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Contact_Bank"))) {
            bankJson.put("Contact_Bank", (Object)erpBank.getString("Contact_Bank"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Contact_BankNumber")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Contact_BankNumber"))) {
            bankJson.put("Contact_BankNumber", (Object)erpBank.getString("Contact_BankNumber"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("BranchSqe")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("BranchSqe"))) {
            bankJson.put("BranchSqe", (Object)erpBank.getString("BranchSqe"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("Whlnam")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("Whlnam"))) {
            bankJson.put("Whlnam", (Object)erpBank.getString("Whlnam"));
        }
        if (StringUtils.isNotBlank((CharSequence)erpBank.getString("BankInfoOID"))) {
            bankJson.put("BankInfoOID", (Object)erpBank.getString("BankInfoOID"));
        }
        if (StringUtils.isBlank((CharSequence)bankJson.getString("BankType")) && StringUtils.isNotBlank((CharSequence)erpBank.getString("BankType"))) {
            bankJson.put("BankType", (Object)erpBank.getString("BankType"));
        }
    }

    private void handleSupLinker(JSONArray linkerArr, List<MatLinkerEntity> linkerList, SupplierSyncErpParamVO syncParam, EmployeeVO curUser, JSONArray erpLinkerArr) {
        List<MatLinkerEntity> handleData = linkerList;
        if ("supChange".equals(syncParam.getSyncType())) {
            return;
        }
        if ("linkerAdd".equals(syncParam.getSyncType()) || "linkerChange".equals(syncParam.getSyncType())) {
            handleData = handleData.stream().filter(item -> item.getId().equals(syncParam.getLinkerId())).collect(Collectors.toList());
        }
        JSONObject linkerJson = null;
        HashMap<String, JSONObject> erpLinkerSourceMap = new HashMap<String, JSONObject>();
        if (null != erpLinkerArr && erpLinkerArr.size() > 0) {
            for (MatLinkerEntity obj : erpLinkerArr) {
                linkerJson = (JSONObject)obj;
                erpLinkerSourceMap.put(linkerJson.getString("subA_oid"), linkerJson);
            }
        }
        if (CollectionUtils.isNotEmpty(handleData)) {
            for (MatLinkerEntity link : handleData) {
                linkerJson = new JSONObject();
                this.logger.info("\u8054\u7cfb\u4eba\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)link), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                linkerJson.put("YQL_SID", StringUtils.isBlank((CharSequence)link.getThirdSourceId()) ? link.getId() : link.getThirdSourceId());
                linkerJson.put("IDType", (Object)ErpLinkerCardTypeEnum.getCodeByElCode((Integer)link.getIdCardType()));
                linkerJson.put("IDCard", (Object)link.getIdCardId());
                linkerJson.put("Company_Contact", (Object)link.getName());
                linkerJson.put("ContactType", (Object)(null != link.getUserType() ? link.getUserType() : null));
                linkerJson.put("Contact_Mobile", (Object)link.getMobileLinkPhone());
                linkerJson.put("Contact_Telephone", (Object)link.getLinkPhone());
                linkerJson.put("Contact_Email", (Object)link.getElectronicMail());
                linkerJson.put("Contact_Address", (Object)link.getAddress());
                linkerJson.put("ContactState", null != link.getLinkerStatus() ? link.getLinkerStatus().toString() : null);
                if (erpLinkerSourceMap.containsKey(link.getThirdSourceId())) {
                    this.fillSupLinkerInfo(linkerJson, (JSONObject)erpLinkerSourceMap.get(link.getThirdSourceId()));
                }
                linkerArr.add((Object)linkerJson);
            }
        }
    }

    private void fillSupLinkerInfo(JSONObject linkerJson, JSONObject erpLinkerJson) {
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("ContactState")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("ContactState"))) {
            linkerJson.put("ContactState", (Object)erpLinkerJson.getString("ContactState"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("AuthorFlag")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("AuthorFlag"))) {
            linkerJson.put("AuthorFlag", (Object)erpLinkerJson.getString("AuthorFlag"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("ServerArea")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("ServerArea"))) {
            linkerJson.put("ServerArea", (Object)erpLinkerJson.getString("ServerArea"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("Position")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("Position"))) {
            linkerJson.put("Position", (Object)erpLinkerJson.getString("Position"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("Industry")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("Industry"))) {
            linkerJson.put("Industry", (Object)erpLinkerJson.getString("Industry"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("lable")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("lable"))) {
            linkerJson.put("lable", (Object)erpLinkerJson.getString("lable"));
        }
        if (StringUtils.isBlank((CharSequence)linkerJson.getString("ContactType")) && StringUtils.isNotBlank((CharSequence)erpLinkerJson.getString("ContactType"))) {
            linkerJson.put("ContactType", (Object)erpLinkerJson.getString("ContactType"));
        }
    }

    @Override
    public void syncSupplierErpSid(Long supplierId) {
        SupplierSyncParam syncParam = new SupplierSyncParam();
        syncParam.setHandleServiceName("matSupplierService");
        syncParam.setSupplierId(supplierId);
        syncParam.setDelaySeconds(Integer.valueOf(0));
        syncParam.setRetry(Boolean.valueOf(false));
        this.supplierSync(syncParam);
    }

    @Override
    public JSONObject getSupErpInfo(Long supplierId) {
        this.logger.info("\u67e5\u8be2\u4f9b\u5e94\u5546id-{}ERP\u4fe1\u606f", (Object)supplierId);
        MatSupplierEntity supplier = (MatSupplierEntity)((Object)super.selectById((Serializable)supplierId));
        String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL + (StringUtils.isBlank((CharSequence)supplier.getThirdSourceId()) ? supplier.getId() : supplier.getThirdSourceId());
        String reqResp = null;
        try {
            HashMap param = new HashMap();
            Map<String, String> headers = ZDSReqUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
            this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            return JSONObject.parseObject((String)reqResp);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546ERP\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            JSONObject resp = new JSONObject();
            resp.put("erpResult", reqResp);
            resp.put("status", (Object)"false");
            return resp;
        }
    }

    @Override
    public boolean supplierSync(SupplierSyncParam supplierSyncParam) {
        block34: {
            try {
                if (null != supplierSyncParam.getDelaySeconds() && supplierSyncParam.getDelaySeconds() > 0) {
                    TimeUnit.SECONDS.sleep(supplierSyncParam.getDelaySeconds().intValue());
                    this.logger.info("********************\u66f4\u65b0\u4f9b\u5e94\u5546\uff1aid-{}\u4fe1\u606f\uff0c{}s\u540e\u5f00\u59cb\u6267\u884c********************", (Object)supplierSyncParam.getSupplierId(), (Object)supplierSyncParam.getDelaySeconds());
                }
            }
            catch (InterruptedException e) {
                this.logger.error("\u66f4\u65b0\u4f9b\u5e94\u5546\uff1aid-{}\u4fe1\u606f\u5ef6\u8fdf{}\u79d2\u5f02\u5e38", new Object[]{supplierSyncParam.getSupplierId(), supplierSyncParam.getDelaySeconds(), e});
            }
            this.logger.info("********************\u66f4\u65b0\u4f9b\u5e94\u5546\uff1aid-{}\u4fe1\u606f\u5f00\u59cb********************", (Object)supplierSyncParam.getSupplierId());
            MatSupplierEntity supplier = (MatSupplierEntity)((Object)super.selectById((Serializable)supplierSyncParam.getSupplierId()));
            HashMap param = new HashMap();
            String reqUrl = ZDSReqUtil.getErpReqHost() + ERP_MAT_SUPPLIER_UPDATE_URL + (null != supplier.getAccessId() ? supplier.getId() : supplier.getThirdSourceId());
            JSONObject reqJson = null;
            JSONArray pageData = null;
            HashMap<String, String> linkerMap = new HashMap<String, String>();
            HashMap<String, String> bankMap = new HashMap<String, String>();
            HashMap<String, String> attachMap = new HashMap<String, String>();
            HashMap<String, String> materialMap = new HashMap<String, String>();
            SupplierSyncParam syncParam = new SupplierSyncParam();
            syncParam.setSupplierId(supplierSyncParam.getSupplierId());
            syncParam.setHandleServiceName("matSupplierService");
            String queueName = "erp_sup_upd_" + this.profile;
            try {
                Map<String, String> headers = ZDSReqUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)120000, (Integer)120000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), JSONObject.toJSONString((Object)reqJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
                    boolean updateSucFlag = true;
                    pageData = reqJson.getJSONArray("MESupplierList");
                    if (null == pageData || pageData.size() == 0) {
                        this.logger.info("\u540c\u6b65ERP\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u4f9b\u5e94\u5546SID-{}\u67e5\u8be2ERP\u4fe1\u606f\u4e3a\u7a7a\uff01");
                        if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                            this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                        }
                        return false;
                    }
                    JSONObject supplierJson = (JSONObject)pageData.get(0);
                    String supplierSid = supplierJson.getString("C_PS_MESupplierInfoOID");
                    if (StringUtil.isBlank((CharSequence)supplierSid)) {
                        this.logger.info("\u540c\u6b65ERP\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0cERP\u4f9b\u5e94\u5546SID\u4e3a\u7a7a:{}", (Object)JSONObject.toJSONString((Object)pageData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                        if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                            this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                        }
                        return false;
                    }
                    if (StringUtil.isNotBlank((CharSequence)supplierSid) && StringUtil.isBlank((CharSequence)supplier.getThirdSourceId())) {
                        supplier.setThirdSourceId(supplierSid);
                    }
                    if (null != reqJson.get((Object)"ContactList") && reqJson.getJSONArray("ContactList").size() > 0) {
                        this.handleLinker(linkerMap, reqJson.getJSONArray("ContactList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getLinkerList())) {
                        for (MatLinkerEntity linker : supplier.getLinkerList()) {
                            if (StringUtil.isNotBlank((CharSequence)linker.getThirdSourceId())) continue;
                            if (linkerMap.containsKey(linker.getId().toString())) {
                                linker.setThirdSourceId((String)linkerMap.get(linker.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u8054\u7cfb\u4ebaid-{}\uff0c SID-{}", (Object)linker.getId(), (Object)linker.getThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("\u4f9b\u5e94\u5546\uff1aid-{} ERP\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u5339\u914d:{}", (Object)supplier.getId(), (Object)JSONObject.toJSONString(linkerMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"ArchivesList") && reqJson.getJSONArray("ArchivesList").size() > 0) {
                        this.handleArchive(attachMap, reqJson.getJSONArray("ArchivesList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getAttachesList())) {
                        for (MatSupplierAttachesEntity attach : supplier.getAttachesList()) {
                            if (null == attach.getFileId() || StringUtil.isNotBlank((CharSequence)attach.getThirdSourceId())) continue;
                            if (attachMap.containsKey(attach.getId().toString())) {
                                attach.setThirdSourceId((String)attachMap.get(attach.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u9644\u4ef6id-{}\uff0c SID-{}", (Object)attach.getId(), (Object)attach.getThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("\u4f9b\u5e94\u5546\uff1aid-{} ERP\u4f9b\u5e94\u5546\u9644\u4ef6\u4fe1\u606f\u4e0d\u5339\u914d:{}", (Object)supplier.getId(), (Object)JSONObject.toJSONString(attachMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"BankList") && reqJson.getJSONArray("BankList").size() > 0) {
                        this.handleBank(bankMap, reqJson.getJSONArray("BankList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getBankList())) {
                        for (MatSupplierBankEntity bank : supplier.getBankList()) {
                            if (StringUtil.isNotBlank((CharSequence)bank.getBankThirdSourceId())) continue;
                            if (bankMap.containsKey(bank.getId().toString())) {
                                bank.setBankThirdSourceId((String)bankMap.get(bank.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u94f6\u884cid-{}\uff0c SID-{}", (Object)bank.getId(), (Object)bank.getBankThirdSourceId());
                                continue;
                            }
                            if (bankMap.containsKey(bank.getBankNumber())) {
                                bank.setBankThirdSourceId((String)bankMap.get(bank.getBankNumber()));
                                this.logger.info("\u66f4\u65b0\u94f6\u884cid-{}\uff0c SID-{}", (Object)bank.getId(), (Object)bank.getBankThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                            this.logger.error("*********\u4f9b\u5e94\u5546\u9879\u94f6\u884c\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)bank.getId());
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("****************\u4f9b\u5e94\u5546\uff1aid-{} ERP\u4f9b\u5e94\u5546\u94f6\u884c\u4fe1\u606f\u4e0d\u5339\u914d:{}****************", (Object)supplier.getId(), (Object)JSONObject.toJSONString(bankMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    updateSucFlag = true;
                    if (null != reqJson.get((Object)"SupplyList") && reqJson.getJSONArray("SupplyList").size() > 0) {
                        this.handleMaterialInfo(materialMap, reqJson.getJSONArray("SupplyList"));
                    }
                    if (CollectionUtils.isNotEmpty(supplier.getMaterialInfoList())) {
                        for (MatSupplierMaterialInfoEntity material : supplier.getMaterialInfoList()) {
                            if (StringUtil.isNotBlank((CharSequence)material.getInfoThirdSourceId())) continue;
                            if (materialMap.containsKey(material.getId().toString())) {
                                material.setInfoThirdSourceId((String)materialMap.get(material.getId().toString()));
                                this.logger.info("\u66f4\u65b0\u4f9b\u8d27\u5185\u5bb9id-{}\uff0c SID-{}", (Object)material.getId(), (Object)material.getInfoThirdSourceId());
                                continue;
                            }
                            updateSucFlag = false;
                            this.logger.error("*********\u4f9b\u5e94\u5546\u4f9b\u8d27\u5185\u5bb9\u4fe1\u606fid-{}\u5728ERP\u4e2d\u65e0\u5339\u914d\u4fe1\u606f*********", (Object)material.getId());
                        }
                    }
                    if (!updateSucFlag) {
                        this.logger.info("****************\u4f9b\u5e94\u5546\uff1aid-{} ERP\u4f9b\u5e94\u5546\u4f9b\u8d27\u5185\u5bb9\u4fe1\u606f\u4e0d\u5339\u914d:{}****************", (Object)supplier.getId(), (Object)JSONObject.toJSONString(materialMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    }
                    this.logger.info("\u66f4\u65b0\u4f9b\u5e94\u5546id-{}\uff0cname-{}ERP SID\u4fe1\u606f\u6210\u529f", (Object)supplier.getId(), (Object)supplier.getName());
                    super.saveOrUpdate((Object)supplier, false);
                } else {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u4f9b\u5e94\u5546\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                    if (!BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) {
                        this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u7269\u8d44\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
                if (BooleanUtils.isFalse((Boolean)supplierSyncParam.getRetry())) break block34;
                this.sendMq(queueName, JSONObject.toJSONString((Object)supplierSyncParam));
            }
        }
        this.logger.info("********************\u66f4\u65b0\u4f9b\u5e94\u5546\u4fe1\u606f\u7ed3\u675f********************");
        return false;
    }

    private void handleMaterialInfo(Map<String, String> materialMap, JSONArray supplyList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u4f9b\u8d27\u5185\u5bb9\u6570\u636e:{}\u6761", (Object)supplyList.size());
        JSONObject tmpJson = null;
        for (Object obj : supplyList) {
            tmpJson = (JSONObject)obj;
            materialMap.put(StringUtils.isNotBlank((CharSequence)tmpJson.getString("YQL_SID")) ? tmpJson.getString("YQL_SID") : tmpJson.getString("C_PS_MESupplierInfo_SubDOID"), tmpJson.getString("C_PS_MESupplierInfo_SubDOID"));
        }
    }

    private void handleBank(Map<String, String> bankMap, JSONArray bankList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u94f6\u884c\u6570\u636e\uff1a{}\u6761", (Object)bankList.size());
        JSONObject tmpBankJson = null;
        for (Object obj : bankList) {
            tmpBankJson = (JSONObject)obj;
            bankMap.put(StringUtils.isNotBlank((CharSequence)tmpBankJson.getString("YQL_SID")) ? tmpBankJson.getString("YQL_SID") : tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"), tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
            bankMap.put(tmpBankJson.getString("Contact_BankAccount"), tmpBankJson.getString("C_PS_MESupplierInfo_SubBOID"));
        }
    }

    private void handleArchive(Map<String, String> attachMap, JSONArray archivesList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u9644\u4ef6\u6570\u636e\uff1a{}\u6761", (Object)archivesList.size());
        JSONObject tmpAttachJson = null;
        for (Object obj : archivesList) {
            tmpAttachJson = (JSONObject)obj;
            attachMap.put(StringUtils.isNotBlank((CharSequence)tmpAttachJson.getString("YQL_SID")) ? tmpAttachJson.getString("YQL_SID") : tmpAttachJson.getString("C_PS_ArchivesOID"), tmpAttachJson.getString("C_PS_ArchivesOID"));
        }
    }

    private void handleLinker(Map<String, String> linkerMap, JSONArray contactList) {
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4f9b\u5e94\u5546-\u8054\u7cfb\u4eba\u6570\u636e\uff1a{}\u6761", (Object)contactList.size());
        JSONObject tmpLinkerJson = null;
        for (Object obj : contactList) {
            tmpLinkerJson = (JSONObject)obj;
            linkerMap.put(StringUtils.isNotBlank((CharSequence)tmpLinkerJson.getString("YQL_SID")) ? tmpLinkerJson.getString("YQL_SID") : tmpLinkerJson.getString("subA_oid"), tmpLinkerJson.getString("subA_oid"));
        }
    }
}

