/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdssupplier.common.utils.EntityUtil;
import com.ejianc.business.zdssupplier.common.utils.PushSupUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.cons.enums.BillTypeEnum;
import com.ejianc.business.zdssupplier.sub.bean.LinkerAccessEntity;
import com.ejianc.business.zdssupplier.sub.bean.LinkerEntity;
import com.ejianc.business.zdssupplier.sub.mapper.LinkerAccessMapper;
import com.ejianc.business.zdssupplier.sub.service.ILinkerAccessService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerInviteService;
import com.ejianc.business.zdssupplier.sub.service.ILinkerService;
import com.ejianc.business.zdssupplier.sub.vo.LinkerAccessVO;
import com.ejianc.business.zdssupplier.sub.vo.LinkerInviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="linkerAccessService")
public class LinkerAccessServiceImpl
extends BaseServiceImpl<LinkerAccessMapper, LinkerAccessEntity>
implements ILinkerAccessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u51c6\u5165.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u5206\u5305\u8054\u7cfb\u4eba\u51c6\u5165.getName();
    private static final String BILL_CODE = "ZDS_SUB_LINKER_ACCESS";
    private static final String SYNC_SUPP_DETAIL_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/linkerAccess/syncDetailBill";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private ILinkerInviteService inviteService;
    @Autowired
    private ILinkerService linkerService;

    @Override
    public LinkerAccessVO saveOrUpdate(LinkerAccessVO saveOrUpdateVO) {
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LinkerAccessEntity.class));
        this.validateUnique(entity, entity.getId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setSourceType(PlanConstant.SOURCE_TYPE_EL.toString());
            entity.setInviterId(InvocationInfoProxy.getUserid());
            entity.setInviterName(this.sessionManager.getUserContext().getUserName());
        }
        super.saveOrUpdate((Object)entity, false);
        return (LinkerAccessVO)BeanMapper.map((Object)((Object)entity), LinkerAccessVO.class);
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        Long fileId;
        String transData = request.getParameter("transData");
        LinkerAccessEntity saveEntity = (LinkerAccessEntity)((Object)JSONObject.parseObject((String)transData, LinkerAccessEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("inviteId", new Parameter("eq", (Object)saveEntity.getInviteId()));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9080\u8bf7\u94fe\u63a5\u5df2\u751f\u6210\u51c6\u5165\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\uff01");
        }
        this.validateUnique(saveEntity, null);
        Long id = this.pushSupUtil.saveSyncBill(request, LinkerAccessEntity.class, BILL_TYPE, BILL_NAME);
        if (null == id) {
            throw new BusinessException("\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01");
        }
        LinkerAccessEntity entity = (LinkerAccessEntity)((Object)super.selectById((Serializable)id));
        entity.setCode(EntityUtil.createBillCode(entity, BILL_CODE));
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        if (entity.getUserType() == 2) {
            fileId = this.pushSupUtil.getFileId((long)entity.getId(), BILL_TYPE, "agentFile", Long.valueOf(entity.getAgencyFileId()));
            entity.setAgencyFileId(fileId.toString());
            Long certifyFileId = this.pushSupUtil.getFileId((long)entity.getId(), BILL_TYPE, "certify", Long.valueOf(entity.getCertifyFileId()));
            entity.setCertifyFileId(certifyFileId.toString());
        } else {
            fileId = this.pushSupUtil.getFileId((long)entity.getId(), BILL_TYPE, "legalPersonFile", Long.valueOf(entity.getLegalPersonFileId()));
            entity.setLegalPersonFileId(fileId.toString());
        }
        super.saveOrUpdate((Object)entity, false);
        LinkerInviteVO inviteVO = new LinkerInviteVO();
        inviteVO.setId(entity.getInviteId());
        inviteVO.setStatus("2");
        inviteVO.setInviterId(entity.getInviterId());
        inviteVO.setInviterName(entity.getInviterName());
        this.inviteService.updateBillStatus(inviteVO, true);
        return id;
    }

    @Override
    public Boolean validateUnique(LinkerAccessEntity linker, Long id) {
        List accessList;
        if (linker.getSupplierId() == null) {
            return true;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("mobileLinkPhone", new Parameter("eq", (Object)linker.getMobileLinkPhone()));
        param.getParams().put("supplierId", new Parameter("eq", (Object)linker.getSupplierId()));
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(accessList = super.queryList(param)))) {
            this.logger.error("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7{}\u5df2\u751f\u6210\u51c6\u5165\u3010{}\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01", (Object)linker.getMobileLinkPhone(), (Object)((LinkerAccessEntity)((Object)accessList.get(0))).getId());
            throw new BusinessException("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7\u5df2\u751f\u6210\u51c6\u5165\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01");
        }
        param.getParams().remove("supplierId");
        param.getParams().put("enableStatus", new Parameter("eq", (Object)1));
        List linkerList = this.linkerService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)linkerList)) {
            this.logger.error("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7{}\u5df2\u751f\u6210\u6863\u6848\u3010{}\u3011\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01", (Object)linker.getMobileLinkPhone(), (Object)((LinkerEntity)((Object)linkerList.get(0))).getId());
            throw new BusinessException("\u8be5\u8054\u7cfb\u4eba\u7684\u624b\u673a\u53f7\u5df2\u751f\u6210\u6863\u6848\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u51c6\u5165\uff01");
        }
        return true;
    }

    @Override
    public Boolean validateUnique(List<LinkerAccessEntity> linkerList) {
        Integer legalNum = (int)(linkerList = linkerList.stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList())).stream().filter(x -> PlanConstant.INTEGER_YES.equals(x.getUserType())).count();
        if (legalNum > 1) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7c7b\u578b\u4e3a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u6700\u591a\u53ea\u80fd\u6709\u4e00\u6761\uff01");
        }
        for (LinkerAccessEntity linker : linkerList) {
            this.validateUnique(linker, linker.getId());
        }
        return true;
    }

    @Override
    public LinkerAccessVO syncDetailBill(Long inviteId) {
        LinkerAccessEntity entity = this.getEntityByInviteId(inviteId, null);
        if (null == entity.getId()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("inviteId", String.valueOf(inviteId));
            CommonResponse<String> response = this.pushSupUtil.exchangeDataAndFilesWithUniversal(SYNC_SUPP_DETAIL_BILL_SERVER_URL, params);
            if (response.isSuccess()) {
                CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)response.getData()), CommonResponse.class);
                if (!resp.isSuccess()) {
                    throw new BusinessException(resp.getMsg());
                }
                entity = this.getEntityByInviteId(null, Long.valueOf((String)resp.getData()));
            } else {
                throw new BusinessException(response.getMsg());
            }
        }
        return (LinkerAccessVO)BeanMapper.map((Object)((Object)entity), LinkerAccessVO.class);
    }

    private LinkerAccessEntity getEntityByInviteId(Long inviteId, Long sourceId) {
        QueryParam queryParam = new QueryParam();
        if (sourceId != null) {
            queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        } else {
            queryParam.getParams().put("inviteId", new Parameter("eq", (Object)inviteId));
        }
        List list = super.queryList(queryParam);
        LinkerAccessEntity entity = new LinkerAccessEntity();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (LinkerAccessEntity)((Object)super.selectById((Serializable)((LinkerAccessEntity)((Object)list.get(0))).getId()));
        }
        return entity;
    }
}

