/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdssupplier.utils.enterprise.processor.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdssupplier.utils.enterprise.processor.ICompanyCheckProcessor;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.BaseCompanyInfoVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.tyc.TYCCertificateVO;
import com.ejianc.business.zdssupplier.utils.enterprise.vo.tyc.TYCEnterpriseInfoVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TYCProcessor
implements ICompanyCheckProcessor {
    private static Logger logger = LoggerFactory.getLogger(TYCProcessor.class);
    private static final String DEFAULT_BASE_INFO_URL = "http://open.api.tianyancha.com/services/open/ic/baseinfo/normal";
    private static final String DEFAULT_CERTIFICATE_URL = "http://open.api.tianyancha.com/services/open/bq/qualification/2.0";
    private static final Integer DEFAULT_REQ_PAGE_SIZE = 20;
    @Value(value="${enterpriseCheck.tycToken:NULL}")
    private String tycToken;
    @Value(value="${enterpriseCheck.baseInfoReqUrl:http://open.api.tianyancha.com/services/open/ic/baseinfo/normal}")
    private String baseInfoReqUrl;
    @Value(value="${enterpriseCheck.certiReqUrl:http://open.api.tianyancha.com/services/open/bq/qualification/2.0}")
    private String certiReqUrl;

    private static void handlePageData(TYCEnterpriseInfoVO companyInfo, JSONArray items) {
        TYCCertificateVO tmpCerti = null;
        for (Object itemObj : items) {
            tmpCerti = new TYCCertificateVO();
            JSONObject certiJson = (JSONObject)itemObj;
            tmpCerti.transfer(tmpCerti, certiJson);
            companyInfo.getCertiList().add(tmpCerti);
        }
    }

    @Override
    public BaseCompanyInfoVO getCompanyInfo(String companyName, JSONObject extParams) {
        TYCEnterpriseInfoVO companyInfo = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)this.tycToken)) {
            throw new BusinessException("\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u5929\u773c\u67e5token\uff0c\u5f53\u524d\u83b7\u53d6token\u4e3a\u7a7a\uff01");
        }
        headers.put("Authorization", this.tycToken);
        Integer pageNum = 1;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keyword", companyName);
        boolean hasNext = true;
        try {
            String resultStr = HttpTookit.get((String)this.baseInfoReqUrl, params, headers);
            JSONObject resultJson = JSONObject.parseObject((String)resultStr);
            companyInfo = new TYCEnterpriseInfoVO();
            if ("ok".equals(resultJson.getString("reason"))) {
                JSONObject baseInfo = resultJson.getJSONObject("result");
                TYCEnterpriseInfoVO.transfer(companyInfo, baseInfo);
            } else {
                logger.info("\u8bf7\u6c42\u4f01\u4e1a\u3010{}\u3011\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)companyName, (Object)JSONObject.toJSONString((Object)resultJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                hasNext = false;
            }
            params.put("pageSize", DEFAULT_REQ_PAGE_SIZE);
            while (hasNext) {
                params.put("pageNum", pageNum);
                String certificateRs = HttpTookit.get((String)DEFAULT_CERTIFICATE_URL, params, headers);
                JSONObject certificateJson = JSONObject.parseObject((String)certificateRs);
                if ("ok".equals(certificateJson.getString("reason"))) {
                    JSONObject itemResult = certificateJson.getJSONObject("result");
                    Integer totalItems = itemResult.getInteger("total");
                    JSONArray items = itemResult.getJSONArray("items");
                    if (null != items && items.size() > 0) {
                        logger.info("\u67e5\u8be2\u4f01\u4e1a\u3010{}\u3011\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", new Object[]{companyName, pageNum, items.size()});
                        TYCProcessor.handlePageData(companyInfo, items);
                    } else {
                        logger.info("\u4f01\u4e1a\u3010{}\u3011\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)companyName, (Object)pageNum);
                        hasNext = false;
                    }
                    if (pageNum * DEFAULT_REQ_PAGE_SIZE >= totalItems) {
                        hasNext = false;
                    }
                    Integer n = pageNum;
                    Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                    continue;
                }
                hasNext = false;
                logger.error("\u67e5\u8be2\u4f01\u4e1a\u3010{}\u3011\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)companyName, (Object)JSONObject.toJSONString((Object)certificateRs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f01\u4e1a\u3010{}\u3011\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u5f02\u5e38\uff0c", (Object)companyName, (Object)e);
        }
        return companyInfo;
    }
}

