package com.ejianc.business.prjdocs.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 项目安全生产检查
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjexecute_secure_inspection")
public class PrjexecuteSecureInspectionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="project_leader_user_id")
    private Long projectLeaderUserId; // 被考核项目负责人id
    @TableField(value="project_leader_user_name")
    private String projectLeaderUserName; // 被考核项目负责人
    @TableField(value="inspection_member_user_id")
    private Long inspectionMemberUserId; // 检查组成员id
    @TableField(value="inspection_member_user_name")
    private String inspectionMemberUserName; // 检查组成员
    @TableField(value="inspection_date")
    private Date inspectionDate; // 检查日期
    @TableField(value="check_score")
    private BigDecimal checkScore; // 检查得分
    @TableField(value="remarks")
    private String remarks; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="prjexecuteSecureInspectionItemService", pidName = "inspectionId")
    private List<PrjexecuteSecureInspectionItemEntity> itemList = new ArrayList<>(); // 项目安全生产检查项
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectLeaderUserId() {
        return projectLeaderUserId;
    }

    public void setProjectLeaderUserId(Long projectLeaderUserId) {
        this.projectLeaderUserId = projectLeaderUserId;
    }
    public String getProjectLeaderUserName() {
        return projectLeaderUserName;
    }

    public void setProjectLeaderUserName(String projectLeaderUserName) {
        this.projectLeaderUserName = projectLeaderUserName;
    }
    public Long getInspectionMemberUserId() {
        return inspectionMemberUserId;
    }

    public void setInspectionMemberUserId(Long inspectionMemberUserId) {
        this.inspectionMemberUserId = inspectionMemberUserId;
    }
    public String getInspectionMemberUserName() {
        return inspectionMemberUserName;
    }

    public void setInspectionMemberUserName(String inspectionMemberUserName) {
        this.inspectionMemberUserName = inspectionMemberUserName;
    }
    public Date getInspectionDate() {
        return inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }
    public BigDecimal getCheckScore() {
        return checkScore;
    }

    public void setCheckScore(BigDecimal checkScore) {
        this.checkScore = checkScore;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PrjexecuteSecureInspectionItemEntity> getItemList() {
        return itemList;
    }

    public void setItemList(List<PrjexecuteSecureInspectionItemEntity> itemList) {
        this.itemList = itemList;
    }
}
