package com.ejianc.business.prjdocs.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 项目管理人员任命
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prjdocs_prjmanager_assign")
public class PrjmanagerAssignEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="signer_id")
    private Long signerId; // 签发人
    @TableField(value="signer_name")
    private String signerName; // 签发人
    @TableField(value="sign_post")
    private String signPost; // 签发人职务
    @TableField(value="sign_date")
    private Date signDate; // 签发日期
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="prjmanagerAssignDetailService", pidName="parentId")
    private List<PrjmanagerAssignDetailEntity> prjmanagerAssignDetailList = new ArrayList<>(); // 项目管理人员任命明细
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSignerId() {
        return signerId;
    }

    public void setSignerId(Long signerId) {
        this.signerId = signerId;
    }

    public String getSignerName() {
        return signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getSignPost() {
        return signPost;
    }

    public void setSignPost(String signPost) {
        this.signPost = signPost;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    

    public List<PrjmanagerAssignDetailEntity> getPrjmanagerAssignDetailList() {
        return prjmanagerAssignDetailList;
    }

    public void setPrjmanagerAssignDetailList(List<PrjmanagerAssignDetailEntity> prjmanagerAssignDetailList) {
        this.prjmanagerAssignDetailList = prjmanagerAssignDetailList;
    }
}
