package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 资料交接单（外部）
 * 
 * @author generator
 * 
 */
public class PrjCompletionDataHandoverFormOutsideVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位名称
    private Long constructionOrgId; // 施工单位id
    private String constructionOrgName; // 施工单位名称
    private Long dataTransferOrgId; // 资料移交单位id
    private String dataTransferOrgName; // 资料移交单位
    private Long dataTransferUserId; // 资料移交人id
    private String dataTransferUserName; // 资料移交人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dataTransferDate; // 资料移交日期
    private Long dataReceiveOrgId; // 资料接收单位id
    private String dataReceiveOrgName; // 资料接收单位
    private Long dataReceiveUserId; // 资料接收人id
    private String dataReceiveUserName; // 资料接收人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dataReceiveDate; // 检查日期
    private String remarks; // 备注
    
    private List<PrjCompletionDataHandoverFormOutsideDetailVO> detailList = new ArrayList<>(); // 资料交接单（外部）-资料明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getConstructionOrgId() {
        return constructionOrgId;
    }

    public void setConstructionOrgId(Long constructionOrgId) {
        this.constructionOrgId = constructionOrgId;
    }
    public String getConstructionOrgName() {
        return constructionOrgName;
    }

    public void setConstructionOrgName(String constructionOrgName) {
        this.constructionOrgName = constructionOrgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDataTransferOrgId() {
        return dataTransferOrgId;
    }

    @ReferDeserialTransfer
    public void setDataTransferOrgId(Long dataTransferOrgId) {
        this.dataTransferOrgId = dataTransferOrgId;
    }
    public String getDataTransferOrgName() {
        return dataTransferOrgName;
    }

    public void setDataTransferOrgName(String dataTransferOrgName) {
        this.dataTransferOrgName = dataTransferOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDataTransferUserId() {
        return dataTransferUserId;
    }

    @ReferDeserialTransfer
    public void setDataTransferUserId(Long dataTransferUserId) {
        this.dataTransferUserId = dataTransferUserId;
    }
    public String getDataTransferUserName() {
        return dataTransferUserName;
    }

    public void setDataTransferUserName(String dataTransferUserName) {
        this.dataTransferUserName = dataTransferUserName;
    }
    public Date getDataTransferDate() {
        return dataTransferDate;
    }

    public void setDataTransferDate(Date dataTransferDate) {
        this.dataTransferDate = dataTransferDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDataReceiveOrgId() {
        return dataReceiveOrgId;
    }

    @ReferDeserialTransfer
    public void setDataReceiveOrgId(Long dataReceiveOrgId) {
        this.dataReceiveOrgId = dataReceiveOrgId;
    }
    public String getDataReceiveOrgName() {
        return dataReceiveOrgName;
    }

    public void setDataReceiveOrgName(String dataReceiveOrgName) {
        this.dataReceiveOrgName = dataReceiveOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getDataReceiveUserId() {
        return dataReceiveUserId;
    }

    @ReferDeserialTransfer
    public void setDataReceiveUserId(Long dataReceiveUserId) {
        this.dataReceiveUserId = dataReceiveUserId;
    }
    public String getDataReceiveUserName() {
        return dataReceiveUserName;
    }

    public void setDataReceiveUserName(String dataReceiveUserName) {
        this.dataReceiveUserName = dataReceiveUserName;
    }
    public Date getDataReceiveDate() {
        return dataReceiveDate;
    }

    public void setDataReceiveDate(Date dataReceiveDate) {
        this.dataReceiveDate = dataReceiveDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<PrjCompletionDataHandoverFormOutsideDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PrjCompletionDataHandoverFormOutsideDetailVO> detailList) {
        this.detailList = detailList;
    }
}
