package com.ejianc.business.prjdocs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 工作量确认单
 * 
 * @author generator
 * 
 */
public class PrjCompletionWorkloadConfirmationFormVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long projectDepartmentId; // 项目部id
    private Long orgId; // 所属单位id
    private String orgName; // 所属单位名称
    private Long constructionOrgId; // 施工单位id
    private String constructionOrgName; // 施工单位名称
    private Long commissionOrgId; // 委托单位id
    private String commissionOrgName; // 委托单位名称
    private Long establishmentUserId; // 编制人id
    private String establishmentUserName; // 编制人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate; // 编制时间
    private String remarks; // 备注
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getConstructionOrgId() {
        return constructionOrgId;
    }

    public void setConstructionOrgId(Long constructionOrgId) {
        this.constructionOrgId = constructionOrgId;
    }
    public String getConstructionOrgName() {
        return constructionOrgName;
    }

    public void setConstructionOrgName(String constructionOrgName) {
        this.constructionOrgName = constructionOrgName;
    }
    public Long getCommissionOrgId() {
        return commissionOrgId;
    }

    public void setCommissionOrgId(Long commissionOrgId) {
        this.commissionOrgId = commissionOrgId;
    }
    public String getCommissionOrgName() {
        return commissionOrgName;
    }

    public void setCommissionOrgName(String commissionOrgName) {
        this.commissionOrgName = commissionOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEstablishmentUserId() {
        return establishmentUserId;
    }

    @ReferDeserialTransfer
    public void setEstablishmentUserId(Long establishmentUserId) {
        this.establishmentUserId = establishmentUserId;
    }
    public String getEstablishmentUserName() {
        return establishmentUserName;
    }

    public void setEstablishmentUserName(String establishmentUserName) {
        this.establishmentUserName = establishmentUserName;
    }
    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    
}
