package com.ejianc.business.safe.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 安全管理人员审查备案表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_safe_manger_person_check")
public class SafeMangerPersonCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="belong_project")
    private Boolean belongProject; // 是否属于项目
    @TableField(value="project_id")
    private Long projectId; // 项目名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属单位
    @TableField(value="org_name")
    private String orgName; // 所属单位
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="processer_id")
    private Long processerId; // 经办人
    @TableField(value="processer_name")
    private String processerName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="work_exp")
    private String workExp; // 工作经历
    @TableField(value="busi_quality")
    private String busiQuality; // 业务素质
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="safeMangerPersonCheckSubService")
    private List<SafeMangerPersonCheckSubEntity> safeMangerPersonCheckSubList = new ArrayList<>(); // 安全管理人员审查备案表-子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Boolean getBelongProject() {
        return belongProject;
    }

    public void setBelongProject(Boolean belongProject) {
        this.belongProject = belongProject;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public Long getProcesserId() {
        return processerId;
    }

    public void setProcesserId(Long processerId) {
        this.processerId = processerId;
    }
    public String getProcesserName() {
        return processerName;
    }

    public void setProcesserName(String processerName) {
        this.processerName = processerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getWorkExp() {
        return workExp;
    }

    public void setWorkExp(String workExp) {
        this.workExp = workExp;
    }
    public String getBusiQuality() {
        return busiQuality;
    }

    public void setBusiQuality(String busiQuality) {
        this.busiQuality = busiQuality;
    }
    

    public List<SafeMangerPersonCheckSubEntity> getSafeMangerPersonCheckSubList() {
        return safeMangerPersonCheckSubList;
    }

    public void setSafeMangerPersonCheckSubList(List<SafeMangerPersonCheckSubEntity> safeMangerPersonCheckSubList) {
        this.safeMangerPersonCheckSubList = safeMangerPersonCheckSubList;
    }
}
