package com.ejianc.business.safe.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目部安全检查
 * 
 * @author generator
 * 
 */
 @TableName("ejc_safe_project_check")
public class SafeProjectCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据审批状态
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属单位
    @TableField(value="org_name")
    private String orgName; // 所属单位
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="processor")
    private Long processor; // 经办人
    @TableField(value="processor_name")
    private String processorName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(exist=false)
    @SubEntity(serviceName="safeProjectCheckDetailService")
    private List<SafeProjectCheckDetailEntity> detailList = new ArrayList<>(); // 项目部安全检查-子表

    public List<SafeProjectCheckDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SafeProjectCheckDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public Long getProcessor() {
        return processor;
    }

    public void setProcessor(Long processor) {
        this.processor = processor;
    }
    public String getProcessorName() {
        return processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
